/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.client.CIMClient;
import com.sun.wbem.security.PasswordCredential;
import com.sun.wbem.security.UserPrincipal;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.Principal;

public class ClassRemover {
    private static final int xcPlatform = 0;
    private static final int sgPlatform = 1;

    private static CIMClient connectClient(CIMNameSpace cns, String rootPassword) {
        CIMClient cc = null;
        try {
            cc = new CIMClient(cns, (Principal)new UserPrincipal("root"), (Object)new PasswordCredential(rootPassword));
        }
        catch (Exception exception) {
            System.err.println("Failed to connect to " + cns);
            System.exit(1);
        }
        return cc;
    }

    private static void deleteClasses(CIMClient cc, int platform) {
        String[][] ClassList = new String[][]{{"Solaris_SystemBoardHasControllers", "Solaris_SystemBoardHasMemory", "Solaris_SystemBoardHasProcessors", "Solaris_SystemBoardHasMCProcessors", "Solaris_DomainHasSlots", "Solaris_DomainHasAttachmentPoints", "Solaris_SlotHasSystemBoard", "Solaris_CHController", "Solaris_CHMemory", "Solaris_CHCPU", "Solaris_MCCPU", "Solaris_CHSystemBoard", "Solaris_WDRAttachmentPoint", "Solaris_XCDomain", "Solaris_WDRDomain", "Solaris_XCSlot", "Solaris_WDRSlot", "Solaris_XCComponentRemove", "Solaris_XCComponentInsert", "Solaris_XCBoardPowerOn", "Solaris_XCBoardPowerOff", "Solaris_XCDomainConfigChange", "Solaris_XCDomainUp", "Solaris_XCDomainDown", "Solaris_XCDomainStop", "Solaris_XCDomainStateChange", "Solaris_XCEnvironmentalIndication", "Solaris_XCSystemBoardConfigChange", "Solaris_XCDomainIndication", "Solaris_WDRIndication"}, {"Solaris_SystemBoardHasControllers", "Solaris_SystemBoardHasMemory", "Solaris_SystemBoardHasProcessors", "Solaris_SystemBoardHasMCProcessors", "Solaris_DomainHasSlots", "Solaris_DomainHasAttachmentPoints", "Solaris_SlotHasSystemBoard", "Solaris_CHController", "Solaris_CHMemory", "Solaris_CHCPU", "Solaris_MCCPU", "Solaris_CHSystemBoard", "Solaris_WDRAttachmentPoint", "Solaris_SGDomain", "Solaris_WDRDomain", "Solaris_SGSlot", "Solaris_WDRSlot", "Solaris_SGBoardPresenceChange", "Solaris_SGSlotAssignmentChange", "Solaris_SGDomainAclChange", "Solaris_SGBoardStateChange", "Solaris_SGDomainStateChange", "Solaris_SGSlotAvailabilityChange", "Solaris_WDRIndication"}};
        int i = 0;
        while (i < ClassList[platform].length) {
            ClassRemover.deleteIfClass(cc, new CIMObjectPath(ClassList[platform][i]));
            ++i;
        }
    }

    protected static void deleteIfClass(CIMClient cc, CIMObjectPath classOP) {
        try {
            System.out.println("deleting class " + classOP);
            cc.deleteClass(classOP);
        }
        catch (CIMException ce) {
            System.err.println(ce.toString());
        }
    }

    protected static void deleteIfInstance(CIMClient cc, CIMObjectPath instOP) {
        try {
            System.out.println("deleting instance " + instOP);
            cc.deleteInstance(instOP);
        }
        catch (CIMException ce) {
            System.err.println(ce.toString());
        }
    }

    private static void deleteProviderPath(CIMClient cc) {
        CIMObjectPath providerPath = new CIMObjectPath("Solaris_ProviderPath");
        providerPath.addKey("pathurl", new CIMValue((Object)"file:///usr/sadm/lib/wbem/wdr.jar"));
        ClassRemover.deleteIfInstance(cc, providerPath);
    }

    private static String getRootPassword() throws IOException {
        BufferedReader stdIn = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Please enter the root password:");
        return stdIn.readLine();
    }

    public static void main(String[] args) throws CIMException, IOException {
        if (args.length != 1) {
            ClassRemover.printUsage();
        } else {
            int platform;
            String platformStr = args[0];
            if (platformStr.equals("xc")) {
                platform = 0;
            } else if (platformStr.equals("sg")) {
                platform = 1;
            } else {
                ClassRemover.printUsage();
                return;
            }
            String rootPassword = ClassRemover.getRootPassword();
            CIMClient defaultClient = ClassRemover.connectClient(new CIMNameSpace(), rootPassword);
            ClassRemover.deleteClasses(defaultClient, platform);
            defaultClient.close();
            CIMNameSpace systemNameSpace = new CIMNameSpace("localhost", "/root/system");
            CIMClient systemClient = ClassRemover.connectClient(systemNameSpace, rootPassword);
            ClassRemover.deleteProviderPath(systemClient);
            systemClient.close();
        }
    }

    private static void printUsage() {
        System.err.println("Usage: ClassRemover xc | sg");
    }
}

