/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.wdr.AttachmentPoint;
import com.sun.wbem.wdr.AttachmentPointProvider;
import com.sun.wbem.wdr.CHSystemBoard;
import com.sun.wbem.wdr.Logger;
import com.sun.wbem.wdr.ResourceMessage;
import com.sun.wbem.wdr.UserPermission;
import java.util.Vector;

public class CHSystemBoardProvider
extends AttachmentPointProvider {
    public CHSystemBoardProvider() {
        Logger.logDebug("CHSystemBoardProvider constructor");
        this.m_ProviderClass = this.getClass().getName();
    }

    protected AttachmentPoint createAttachmentPoint() {
        return new CHSystemBoard(this.m_Provider.getCurrentUser());
    }

    protected Integer invokeSubclassMethod(AttachmentPoint attachPoint, String methodName, Vector inParams, Vector outParams) throws CIMException {
        Integer status = null;
        CHSystemBoard sysBoard = (CHSystemBoard)attachPoint;
        Logger.logDebug("CHSystemBoardProvider::invokeSubclassMethod called");
        if (methodName.equalsIgnoreCase("Assign")) {
            if (!UserPermission.mayAssignBoard(this.m_Provider.getCurrentUser(), sysBoard.getDomainID(), sysBoard.getLogicalID())) {
                throw new CIMException("CIM_ERR_ACCESS_DENIED", (Object)ResourceMessage.getMsg("WDR.noPermissionToAssignBoardToDomain", new Object[]{this.m_Provider.getCurrentUser(), sysBoard.getLogicalID(), new Integer(sysBoard.getDomainID())}));
            }
            status = sysBoard.assign(inParams, outParams);
        } else if (methodName.equalsIgnoreCase("PowerOn")) {
            if (!UserPermission.mayPowerBoard(this.m_Provider.getCurrentUser(), sysBoard.getDomainID(), sysBoard.getLogicalID())) {
                throw new CIMException("CIM_ERR_ACCESS_DENIED", (Object)ResourceMessage.getMsg("WDR.noPermissionToPowerOnBoard", new Object[]{this.m_Provider.getCurrentUser(), sysBoard.getLogicalID()}));
            }
            status = sysBoard.poweron(inParams, outParams);
        } else if (methodName.equalsIgnoreCase("PowerOff")) {
            if (!UserPermission.mayPowerBoard(this.m_Provider.getCurrentUser(), sysBoard.getDomainID(), sysBoard.getLogicalID())) {
                throw new CIMException("CIM_ERR_ACCESS_DENIED", (Object)ResourceMessage.getMsg("WDR.noPermissionToPowerOffBoard", new Object[]{this.m_Provider.getCurrentUser(), sysBoard.getLogicalID()}));
            }
            status = sysBoard.poweroff(inParams, outParams);
        } else if (methodName.equalsIgnoreCase("Unassign")) {
            if (!UserPermission.mayUnassignBoard(this.m_Provider.getCurrentUser(), sysBoard.getDomainID(), sysBoard.getLogicalID())) {
                throw new CIMException("CIM_ERR_ACCESS_DENIED", (Object)ResourceMessage.getMsg("WDR.noPermissionToUnassignBoardFromDomain", new Object[]{this.m_Provider.getCurrentUser(), sysBoard.getLogicalID(), new Integer(sysBoard.getDomainID())}));
            }
            status = sysBoard.unassign(inParams, outParams);
        } else {
            status = new Integer(3);
        }
        return status;
    }

    public void updateLocalProps(CIMInstance inst, AttachmentPoint ap) {
        Logger.logDebug("CHSystemBoardProvider::updateLocalProps");
        if (ap instanceof CHSystemBoard) {
            CHSystemBoard sb = (CHSystemBoard)ap;
            inst.setProperty("Assigned", new CIMValue((Object)new Boolean(sb.getAssigned())));
            inst.setProperty("PoweredOn", new CIMValue((Object)new Boolean(sb.getPoweredOn())));
        }
    }
}

