/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.wdr.AttachmentPoint;
import com.sun.wbem.wdr.Logger;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;

public class CHSystemBoard
extends AttachmentPoint {
    protected boolean m_Assigned;
    protected boolean m_PoweredOn;

    public CHSystemBoard() {
        Logger.logDebug("CHSystemBoard() constructor");
    }

    public CHSystemBoard(AttachmentPoint ap) {
        super(ap);
        Logger.logDebug("CHSystemBoard(AttachmentPoint ap) constructor");
        this.populateSubclassMembers();
    }

    public CHSystemBoard(String user) {
        super(user);
        Logger.logDebug("CHSystemBoard(String user) constructor");
    }

    public Integer assign(Vector inParams, Vector outParams) {
        return this.hardwareFunc(0, inParams, outParams);
    }

    public boolean getAssigned() {
        return this.m_Assigned;
    }

    public boolean getPoweredOn() {
        return this.m_PoweredOn;
    }

    public boolean getResource(String hwOptions, StringBuffer error) {
        boolean status = super.getResource(hwOptions, error);
        if (status && this.isSystemBoardType(this.m_Type)) {
            this.populateSubclassMembers();
        } else if (status) {
            Logger.logErr("CHSystemBoard::getResource() m_LogicalID = " + this.m_LogicalID + "m_DomainID = " + this.m_DomainID + " is not " + "SystemBoard type");
            status = false;
        }
        return status;
    }

    public Vector getResources(int domainID, String hwOptions, String listOptions, StringBuffer error) {
        Vector<CHSystemBoard> sbVector = null;
        Vector apVector = super.getResources(domainID, hwOptions, listOptions, error);
        if (apVector != null) {
            sbVector = new Vector<CHSystemBoard>(apVector.size());
            Iterator apIter = ((AbstractList)apVector).iterator();
            CHSystemBoard sb = null;
            while (apIter.hasNext()) {
                AttachmentPoint ap = (AttachmentPoint)apIter.next();
                if (!this.isSystemBoardType(ap.m_Type)) continue;
                sb = new CHSystemBoard(ap);
                sbVector.add(sb);
            }
        }
        return sbVector;
    }

    private boolean isSystemBoardType(String apType) {
        boolean isSGSystemBoard = false;
        boolean isXCSystemBoard = false;
        boolean isNewSGSystemBoard = false;
        boolean bl = isXCSystemBoard = apType.equals("CPU") || apType.equals("V3CPU") || apType.equals("WIB") || apType.equals("MCPU") || apType.equals("PCI") || apType.equals("HPCI") || apType.equals("HPCI+") || apType.equals("WPCI");
        if (!isXCSystemBoard) {
            boolean bl2 = isSGSystemBoard = apType.equals("CPU_Board") || apType.equals("CPU") || apType.equals("CPU_V2") || apType.equals("CPU_V3") || apType.equals("COD_CPU_Boa") || apType.equals("COD_CPU") || apType.equals("COD_CPU_V2") || apType.equals("COD_CPU_V3") || apType.equals("WIB_Board") || apType.equals("CPU_Board_V") || apType.equals("PCI_I/O_Boa") || apType.equals("PCI+_I/O_Bo") || apType.equals("CPCI_I/O_bo") || apType.equals("CPCI_I/O_Bo") || apType.equals("Fire_Link/C") || apType.equals("WCI_cPCI_I/");
        }
        if (!isXCSystemBoard && !isSGSystemBoard) {
            try {
                isNewSGSystemBoard = "CPU_V".equals(apType.substring(0, 5));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                isNewSGSystemBoard = false;
            }
        }
        if (!(isXCSystemBoard || isSGSystemBoard || isNewSGSystemBoard)) {
            try {
                isNewSGSystemBoard = "COD_CPU_V".equals(apType.substring(0, 9));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                isNewSGSystemBoard = false;
            }
        }
        return isSGSystemBoard || isXCSystemBoard || isNewSGSystemBoard;
    }

    public void populateSubclassMembers() {
        boolean assigned = false;
        boolean poweredOn = false;
        Iterator nameIter = ((AbstractList)this.getMiscInfoPairs()).iterator();
        while (nameIter.hasNext()) {
            String name = (String)nameIter.next();
            if (name.equals("assigned")) {
                assigned = true;
                continue;
            }
            if (!name.equals("powered-on")) continue;
            poweredOn = true;
        }
        this.setAssigned(assigned);
        this.setPoweredOn(poweredOn);
    }

    public Integer poweroff(Vector inParams, Vector outParams) {
        return this.hardwareFunc(3, inParams, outParams);
    }

    public Integer poweron(Vector inParams, Vector outParams) {
        return this.hardwareFunc(2, inParams, outParams);
    }

    public void setAssigned(boolean assigned) {
        this.m_Assigned = assigned;
    }

    public void setPoweredOn(boolean poweredOn) {
        this.m_PoweredOn = poweredOn;
    }

    public Integer unassign(Vector inParams, Vector outParams) {
        return this.hardwareFunc(1, inParams, outParams);
    }
}

