/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.wdr;

import com.sun.wbem.wdr.AttachmentPoint;
import com.sun.wbem.wdr.Logger;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class CHCPU
extends AttachmentPoint {
    protected int m_ID;
    protected int m_Speed;
    protected int m_ECache;

    public CHCPU() {
        Logger.logDebug("CHCPU() constructor");
    }

    public CHCPU(AttachmentPoint ap) {
        super(ap);
        Logger.logDebug("CHCPU(AttachmentPoint ap) constructor");
        this.populateSubclassMembers();
    }

    public CHCPU(String user) {
        super(user);
        Logger.logDebug("CHCPU(String user) constructor");
    }

    public int getECache() {
        return this.m_ECache;
    }

    public int getID() {
        return this.m_ID;
    }

    public boolean getResource(String hwOptions, StringBuffer error) {
        boolean status = super.getResource(hwOptions, error);
        if (status && this.m_Type.equals("cpu")) {
            this.populateSubclassMembers();
        } else if (status) {
            Logger.logErr("CHCPU::getResource() m_LogicalID = " + this.m_LogicalID + "m_DomainID = " + this.m_DomainID + " is not of type cpu");
            status = false;
        }
        return status;
    }

    public Vector getResources(int domainID, String hwOptions, String listOptions, StringBuffer error) {
        Vector<CHCPU> cpuVector = null;
        Vector apVector = super.getResources(domainID, hwOptions, listOptions, error);
        if (apVector != null) {
            cpuVector = new Vector<CHCPU>(apVector.size());
            Iterator apIter = ((AbstractList)apVector).iterator();
            CHCPU cpu = null;
            while (apIter.hasNext()) {
                AttachmentPoint ap = (AttachmentPoint)apIter.next();
                if (!ap.m_Type.equals("cpu")) continue;
                cpu = new CHCPU(ap);
                cpuVector.add(cpu);
            }
        }
        return cpuVector;
    }

    public int getSpeed() {
        return this.m_Speed;
    }

    public void populateSubclassMembers() {
        int id = 0;
        int ecache = 0;
        int speed = 0;
        Iterator nameValueIter = ((AbstractList)this.getMiscInfoPairs()).iterator();
        while (nameValueIter.hasNext()) {
            String name = (String)nameValueIter.next();
            String value = (String)nameValueIter.next();
            if (name.equals("cpuid")) {
                StringTokenizer st = new StringTokenizer(value, ",");
                String numStr = st.nextToken();
                id = Integer.parseInt(numStr);
                continue;
            }
            if (name.equals("ecache")) {
                ecache = Integer.parseInt(value);
                continue;
            }
            if (!name.equals("speed")) continue;
            speed = Integer.parseInt(value);
        }
        this.setID(id);
        this.setECache(ecache);
        this.setSpeed(speed);
    }

    public void setECache(int eCache) {
        this.m_ECache = eCache;
    }

    public void setID(int id) {
        this.m_ID = id;
    }

    public void setSpeed(int speed) {
        this.m_Speed = speed;
    }
}

