#!/bin/sh
#
# $Id: set_admin.sh,v 1.1.1.1.2.2 2003/02/05 17:28:21 pj140600 Exp $
#
# set_admin.sh sam-admin-group
#
# if no "sam-admin-group" is specified, the user will be prompted for one.
#

#  List of programs in /opt/SUNWsamfs/sbin to be SAM-FS admin group executable.

ADMLIST="archive_audit archiver auditslot build_cat chmed cleandrive \
  d2format devicetool dmpshm dump_cat dump_log export import itemize libmgr \
  load move odlabel previewtool robottool \
  sam-recycler samtrace samcmd samset samtool \
  samu set_state showqueue tplabel     \
  unarchive unload"

#  Check for root and exit if not.

UID=`/bin/id | sed -e "s/^[^=]*=//" -e "s/(.*//"`
if [ $UID -ne 0 ] ; then
    echo "This script must be run as 'root'."
	exit
fi

if [ X$1 = X ]; then
	#
	#  Get the group for the administrators
	#
	echo " "
	echo " "
	echo " "
	echo By default, the SAM-FS administrator commands may be executed by
	echo root only.  However, if you wish, you can supply a group name now
	echo which will also be allowed to execute the administrator commands.
	echo This group must currently exist in your system \(either in the
	echo /etc/group file or in YP/NIS/NIS+\)
	 
	ADDGROUP=0
	CONTINUE=1
	while [ $CONTINUE -eq 1 ]; do
		echo " "
		echo Do you wish to change back to the default behavior?
		echo " "
		echo Enter \"y\" if you do, or \"n\" if you wish to define an administrator group.
		read reply
	 
		if [ X$reply = Xn ]; then
			ADDGROUP=1
			CONTINUE=0
		elif [ X$reply = Xy ]; then
			ADDGROUP=0
			CONTINUE=0
		else
			echo Your reply of \"$reply\" was not \"y\" or \"n\".
		fi
	done


	if [ $ADDGROUP = 1 ]; then
		ADMMODE=04550
		CONTINUE=1
		while [ $CONTINUE -eq 1 ]; do
			echo Enter the name of the group which you wish to use as the SAM-FS
			echo administrator group.
			echo " "
			read GROUPADM
	 
			echo " "
			echo You entered \"$GROUPADM\".  Enter y if this is what you wanted.
			read reply
			if [ X$reply = Xy ]; then
				if [ X$GROUPADM = XSAM_FS ]; then
					echo You cannot use SAM_FS as the administrator group.
					echo Choose another group.
					echo " "
				else
					CONTINUE=0
				fi
			fi
		done
		echo The administrator commands will be executable by root and
		echo members of group $GROUPADM.
	else
		ADMMODE=550
		GROUPADM=bin
		echo Very well.  The administrator commands will be executable by root only.
	fi
	echo " "
elif [ $1 = "bin" ]; then
	ADMMODE=550
	GROUPADM=bin
else
	ADMMODE=04550
	GROUPADM=$1
fi

#  change the group on (most of) the adm commands in /opt/SUNWsamfs/sbin
 
	chgrp $GROUPADM /opt/SUNWsamfs/sbin
    for object in $ADMLIST
    do
		if [ ! -f /opt/SUNWsamfs/sbin/$object ]; then
			continue
		fi
        chgrp $GROUPADM /opt/SUNWsamfs/sbin/$object
        if [ $? -ne 0 ]; then
            echo " "
            echo FATAL:  Group $GROUPADM does not exist in your system.
            echo This was the group you named as the sam administrator group.
            echo " "
            echo Please add the group following your site procedures, and
            echo then \"pkgrm SUNWsamfs\" and retry the \"pkgadd\".
            exit 1
        fi
        chmod $ADMMODE /opt/SUNWsamfs/sbin/$object
    done
    if [ $GROUPADM = "bin" ]; then
    echo The administrator commands are now executable by root only.
    else
    echo The administrator commands are now executable by group $GROUPADM.
    fi	

exit 0
