/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import jclass.bwt.JCContainer;
import jclass.bwt.JCSeparator;
import jclass.bwt.SplitterWindowSeparator;
import jclass.util.JCUtilConverter;

public class JCSplitterWindow
extends JCContainer {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    int dir = 0;
    int min_child_size = 20;
    boolean resized = false;
    private static final String base = "splitterwindow";
    private static int nameCounter;
    static final String[] orient_strings;
    static final int[] orient_values;

    public JCSplitterWindow() {
        this(0, null, null);
    }

    public JCSplitterWindow(int n) {
        this(n, null, null);
    }

    public JCSplitterWindow(int n, Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.dir = n;
        if (this.getClass().getName().equals("jclass.bwt.JCSplitterWindow")) {
            this.getParameters(applet);
        }
        this.setLayout(null);
    }

    protected void getParameters() {
        super.getParameters();
        this.dir = JCContainer.conv.toEnum(this.getParam("Orientation"), "orientation", orient_strings, orient_values, this.dir);
        this.min_child_size = JCContainer.conv.toInt(this.getParam("MinChildSize"), this.min_child_size);
    }

    public int getOrientation() {
        return this.dir;
    }

    public void setOrientation(int n) {
        JCUtilConverter.checkEnum(n, "orientation", orient_values);
        this.dir = n;
        this.layout();
    }

    public int getMinChildSize() {
        return this.min_child_size;
    }

    public void setMinChildSize(int n) {
        this.min_child_size = n;
    }

    protected void addImpl(Component component, Object object, int n) {
        if (this.countComponents() % 2 != 0) {
            super.addImpl(new SplitterWindowSeparator(this), null, -1);
        }
        super.addImpl(component, null, -1);
    }

    public void remove(Component component) {
        Component component2;
        int n = this.getComponent(component);
        if (n < 0) {
            return;
        }
        if (!(component instanceof JCSeparator) && (component2 = this.getComponent(n == 0 ? n + 1 : n - 1)) instanceof JCSeparator) {
            super.remove(component2);
        }
        super.remove(component);
    }

    protected int preferredHeight() {
        Component[] componentArray = this.getComponents();
        if (componentArray.length == 0) {
            return 100;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.countComponents()) {
            int n3 = componentArray[n2].preferredSize().height;
            n = this.dir == 1 ? (n += n3) : Math.max(n, n3);
            ++n2;
        }
        return n;
    }

    protected int preferredWidth() {
        Component[] componentArray = this.getComponents();
        if (componentArray.length == 0) {
            return 100;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.countComponents()) {
            int n3 = componentArray[n2].preferredSize().width;
            n = this.dir == 0 ? (n += n3) : Math.max(n, n3);
            ++n2;
        }
        return n;
    }

    public void layout() {
        int n;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        Component[] componentArray = this.getComponents();
        JCSplitterWindow jCSplitterWindow = this;
        synchronized (jCSplitterWindow) {
            n2 = this.insets().left;
            n3 = this.insets().top;
            n4 = this.size().width - this.insets().left - this.insets().right;
            n5 = this.size().height - this.insets().top - this.insets().bottom;
            n = this.dir;
        }
        int n6 = 0;
        while (n6 < componentArray.length) {
            int n7;
            int n8;
            Component component = componentArray[n6];
            Dimension dimension = this.resized && component.size().width > 0 && component.size().height > 0 ? component.size() : component.preferredSize();
            if (n6 != componentArray.length - 1) {
                n8 = n == 1 ? n4 : dimension.width;
                n7 = n == 0 ? n5 : dimension.height;
            } else {
                n8 = n == 1 ? n4 : n4 - n2;
                n7 = n == 0 ? n5 : n5 - n3;
            }
            component.reshape(n2, n3, n8, n7);
            n2 += this.dir == 1 ? 0 : dimension.width + 1;
            n3 += this.dir == 1 ? dimension.height + 1 : 0;
            ++n6;
        }
    }

    public final void setLayout(LayoutManager layoutManager) {
    }

    static {
        orient_strings = new String[]{"horizontal", "vertical"};
        orient_values = new int[]{0, 1};
    }
}

