/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.util.Vector;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCComponent;

class Focus {
    private static boolean isTraversable(Component component) {
        if (component instanceof JCComponent) {
            return ((JCComponent)component).isFocusTraversable();
        }
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            int n = 0;
            while (n < componentArray.length) {
                if (Focus.isTraversable(componentArray[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return component.isShowing() && component.isEnabled();
    }

    static JCComponent findFocus(Container container) {
        if (container == null) {
            return null;
        }
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof Container) {
                return Focus.findFocus((Container)componentArray[n]);
            }
            if (componentArray[n] instanceof JCComponent && ((JCComponent)componentArray[n]).has_focus) {
                return (JCComponent)componentArray[n];
            }
            ++n;
        }
        return null;
    }

    static Component getFirstChild(Container container) {
        if (!container.isVisible()) {
            return null;
        }
        Component[] componentArray = container.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] instanceof Container) {
                Component component = Focus.getFirstChild((Container)componentArray[n]);
                if (component != null) {
                    return component;
                }
            } else if (Focus.isTraversable(componentArray[n])) {
                return componentArray[n];
            }
            ++n;
        }
        return null;
    }

    private static final int countChildren(Component component, Vector vector) {
        if (component == null) {
            return 0;
        }
        if (!(component instanceof Container)) {
            if (Focus.isTraversable(component)) {
                if (vector != null) {
                    vector.addElement(component);
                }
                return 1;
            }
            return 0;
        }
        int n = 1;
        Component[] componentArray = ((Container)component).getComponents();
        int n2 = 0;
        while (n2 < componentArray.length) {
            n += Focus.countChildren(componentArray[n2], vector);
            ++n2;
        }
        return n;
    }

    private static Component getNextChild(Container container, Component component) {
        Vector vector = new Vector(Focus.countChildren(container, null));
        Focus.countChildren(container, vector);
        int n = vector.indexOf(component);
        int n2 = n + 1;
        while (n2 < vector.size()) {
            Component component2 = (Component)vector.elementAt(n2);
            if (component2.getParent() != component.getParent()) {
                return component2;
            }
            ++n2;
        }
        return null;
    }

    private static Component getPreviousChild(Container container, Component component) {
        Vector vector = new Vector(Focus.countChildren(container, null));
        Focus.countChildren(container, vector);
        int n = vector.indexOf(component);
        int n2 = n - 1;
        while (n2 >= 0) {
            Component component2 = (Component)vector.elementAt(n2);
            if (component2.getParent() != component.getParent()) {
                return component2;
            }
            --n2;
        }
        return null;
    }

    static Component getLastChild(Container container) {
        Component[] componentArray = container.getComponents();
        int n = componentArray.length - 1;
        while (n >= 0) {
            if (componentArray[n] instanceof Container) {
                return Focus.getLastChild((Container)componentArray[n]);
            }
            if (Focus.isTraversable(componentArray[n])) break;
            --n;
        }
        if (n >= 0) {
            return componentArray[n];
        }
        return null;
    }

    static void nextFocus(Component component) {
        if (component.getParent() == null) {
            return;
        }
        Component[] componentArray = component.getParent().getComponents();
        if (componentArray.length == 1) {
            return;
        }
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] == component) break;
            ++n;
        }
        component = null;
        int n2 = n + 1;
        while (component == null && n2 < componentArray.length) {
            if (Focus.isTraversable(componentArray[n2])) {
                component = componentArray[n2];
            }
            ++n2;
        }
        n2 = 0;
        while (component == null && n2 < n) {
            if (Focus.isTraversable(componentArray[n2])) {
                component = componentArray[n2];
            }
            ++n2;
        }
        if (component != null) {
            component.requestFocus();
        }
    }

    static void nextFocus(Container container, Component component) {
        Frame frame = BWTUtil.getFrame(container);
        Component component2 = Focus.getNextChild(frame, component);
        if (component2 == null) {
            component2 = Focus.getFirstChild(frame);
        }
        if (component2 != null) {
            component2.requestFocus();
        }
    }

    static void previousFocus(Container container, Component component) {
        Frame frame = BWTUtil.getFrame(container);
        Component component2 = Focus.getPreviousChild(frame, component);
        if (component2 == null) {
            component2 = Focus.getLastChild(frame);
        }
        if (component2 != null) {
            component2.requestFocus();
        }
    }

    static void previousFocus(Component component) {
        if (component.getParent() == null) {
            return;
        }
        Component[] componentArray = component.getParent().getComponents();
        if (componentArray.length == 1) {
            return;
        }
        int n = 0;
        while (n < componentArray.length) {
            if (componentArray[n] == component) break;
            ++n;
        }
        component = null;
        int n2 = n - 1;
        while (component == null && n2 >= 0) {
            if (Focus.isTraversable(componentArray[n2])) {
                component = componentArray[n2];
            }
            --n2;
        }
        n2 = componentArray.length - 1;
        while (component == null && n2 != n) {
            if (Focus.isTraversable(componentArray[n2])) {
                component = componentArray[n2];
            }
            --n2;
        }
        if (component != null) {
            component.requestFocus();
        }
    }

    Focus() {
    }
}

