/*
 * Decompiled with CFR 0.152.
 */
package jclass.beans;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.lang.reflect.Array;
import jclass.beans.BeanError;
import jclass.beans.JCPropertyEditor;
import jclass.bwt.JCContainer;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;
import jclass.bwt.JCOutliner;
import jclass.bwt.JCOutlinerFolderNode;
import jclass.bwt.JCOutlinerNode;
import jclass.bwt.JCSplitterWindow;
import jclass.util.JCVector;

public class IndexedPropertyEditor
extends JCContainer
implements PropertyEditor,
ActionListener,
JCItemListener {
    private PropertyChangeSupport support = new PropertyChangeSupport(this);
    protected Object target;
    protected JCOutliner outliner;
    protected JCVector objects;
    protected Panel pane;
    PropertyEditor ed;

    public IndexedPropertyEditor() {
        this.setLayout(new GridLayout(1, 1));
        JCSplitterWindow jCSplitterWindow = new JCSplitterWindow();
        this.add(jCSplitterWindow);
        Panel panel = new Panel();
        jCSplitterWindow.add(panel);
        panel.setLayout(new BorderLayout());
        this.outliner = new JCOutliner();
        panel.add((Component)this.outliner, "Center");
        this.outliner.setScrollbarDisplay(0);
        this.outliner.setPreferredSize(200, 100);
        this.outliner.setVisibleRows(2);
        this.outliner.addItemListener(this);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout());
        panel.add((Component)panel2, "South");
        Button button = new Button("Add");
        panel2.add(button);
        button.addActionListener(this);
        button = new Button("Remove");
        panel2.add(button);
        button.addActionListener(this);
        this.pane = new Panel();
        jCSplitterWindow.add(this.pane);
    }

    public Dimension preferredSize() {
        if (this.outliner == null || this.pane == null) {
            return new Dimension(500, 200);
        }
        Dimension dimension = this.outliner.preferredSize();
        return new Dimension(dimension.width * 3, dimension.height * 2);
    }

    public void setValue(Object object) {
        try {
            this.target = object;
            this.setArrayValue();
            this.outliner.folderChanged(this.outliner.getRootNode());
            this.outliner.repaint();
            return;
        }
        catch (Exception exception) {
            BeanError.raise("Error setting new value in IndexedPropertyEditor");
            exception.printStackTrace(System.out);
            return;
        }
    }

    protected void setArrayValue() {
        this.objects = new JCVector();
        JCOutlinerFolderNode jCOutlinerFolderNode = new JCOutlinerFolderNode("Indexed Property");
        this.outliner.setRootNode(jCOutlinerFolderNode);
        if (this.target == null) {
            return;
        }
        int n = 0;
        while (n < Array.getLength(this.target)) {
            Object object = Array.get(this.target, n);
            if (object != null) {
                JCOutlinerNode jCOutlinerNode = new JCOutlinerNode(object.toString());
                this.objects.setElementAt(n, jCOutlinerNode);
                jCOutlinerFolderNode.addNode(jCOutlinerNode);
            }
            ++n;
        }
    }

    protected void addItem(int n) {
        try {
            Class<?> clazz = this.target.getClass().getComponentType();
            int n2 = Array.getLength(this.target);
            Object object = Array.newInstance(clazz, n2 + 1);
            if (n < 0) {
                n = 0;
            }
            if (n > n2) {
                n = n2;
            }
            int n3 = 0;
            while (n3 < n) {
                Array.set(object, n3, Array.get(this.target, n3));
                ++n3;
            }
            try {
                Object obj = clazz.newInstance();
                Array.set(object, n, obj);
            }
            catch (Exception exception) {}
            int n4 = n + 1;
            while (n4 < Array.getLength(object)) {
                Object object2 = Array.get(this.target, n4 - 1);
                Array.set(object, n4, object2);
                ++n4;
            }
            this.setValue(object);
            return;
        }
        catch (Exception exception) {
            BeanError.raise("Error adding a new item in IndexedPropertyEditor");
            return;
        }
    }

    protected void removeItem(int n) {
        try {
            int n2 = Array.getLength(this.target) - 1;
            if (n2 < 0) {
                n2 = 0;
            }
            Object[] objectArray = (Object[])this.target;
            Object object = Array.newInstance(this.target.getClass().getComponentType(), n2);
            int n3 = 0;
            while (n3 < n && n3 < n2) {
                Array.set(object, n3, Array.get(this.target, n3));
                ++n3;
            }
            int n4 = n + 1;
            while (n4 < objectArray.length) {
                Array.set(object, n4 - 1, Array.get(this.target, n4));
                ++n4;
            }
            this.setValue(object);
            return;
        }
        catch (Exception exception) {
            BeanError.raise("Error removing an item from IndexedPropertyEditor");
            return;
        }
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        if (jCItemEvent.getStateChange() != 1) {
            return;
        }
        Object object = jCItemEvent.getItem();
        Object[] objectArray = (Object[])this.target;
        if (objectArray == null) {
            return;
        }
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n].toString().equals(object.toString())) break;
            ++n;
        }
        if (n < 0 || n >= objectArray.length) {
            return;
        }
        this.launchPropertySheet(objectArray[n]);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JCOutlinerNode jCOutlinerNode = this.outliner.getSelectedNode();
        Object[] objectArray = (Object[])this.target;
        int n = this.objects.indexOf(jCOutlinerNode);
        if (n < 0) {
            n = 0;
        }
        if (n > objectArray.length) {
            n = objectArray.length;
        }
        Object object = this.target;
        if (actionEvent.getActionCommand().equals("Add")) {
            this.addItem(n);
        } else if (actionEvent.getActionCommand().equals("Remove")) {
            this.removeItem(n);
        }
        this.support.firePropertyChange(null, object, this.target);
    }

    public Object getValue() {
        return this.target;
    }

    public boolean isPaintable() {
        return true;
    }

    public void paintValue(Graphics graphics, Rectangle rectangle) {
    }

    public String getJavaInitializationString() {
        return null;
    }

    public String getAsText() {
        return null;
    }

    public void setAsText(String string) throws IllegalArgumentException {
        throw new IllegalArgumentException(string);
    }

    public String[] getTags() {
        return null;
    }

    public Component getCustomEditor() {
        return this;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    void launchPropertySheet(Object object) {
        try {
            this.setCursor(3);
            if (this.ed == null) {
                this.ed = PropertyEditorManager.findEditor(object.getClass());
                if (this.ed == null) {
                    this.ed = new JCPropertyEditor();
                }
                this.ed.setValue(object);
                if (!(this.ed.getCustomEditor() instanceof Frame)) {
                    this.pane.removeAll();
                    this.pane.setLayout(new GridLayout(1, 1));
                    this.pane.add(this.ed.getCustomEditor());
                    this.validate();
                }
            } else {
                this.ed.setValue(object);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            BeanError.raise("Error launching property sheet for item in array");
        }
        this.setCursor(0);
    }
}

