/*
 * Decompiled with CFR 0.152.
 */
package sam.gui.status;

import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import jclass.bwt.JCGroupBox;
import sam.gui.StatusPanel;
import sam.model.Media;
import sam.model.MountRequestEntry;
import sam.model.OpticalMedia;
import sam.resource.ResourceManager;

public class MountReqEntryStatus
extends StatusPanel {
    private MountRequestEntry entry;

    public boolean apply() {
        this.isEditable();
        return true;
    }

    public void setup() {
        if (this.isInitialized()) {
            this.removeAll();
        }
        Media media = this.entry.getMedia();
        this.options.weightx = 1.0;
        this.options.weighty = 1.0;
        this.options.gridheight = 1;
        this.options.anchor = 17;
        this.options.fill = 2;
        this.options.gridwidth = 1;
        this.options.insets = new Insets(2, 5, 2, 5);
        this.addField(ResourceManager.getString("VSN"), media.getName());
        this.addField(ResourceManager.getString("Type"), media.getTypeString());
        this.addField(ResourceManager.getString("Slot number"), Integer.toString(this.entry.getSlotNumber()));
        this.addField(ResourceManager.getString("Request count"), Integer.toString(this.entry.getRequestCount()));
        this.addEndLine();
        this.addField(ResourceManager.getString("User"), this.entry.getUser());
        this.addField(ResourceManager.getString("Process Id"), Integer.toString(this.entry.getPID()));
        this.addField(ResourceManager.getString("Elapsed time"), this.entry.getElapsedTimeString());
        this.addField(ResourceManager.getString("Priority"), Float.toString(this.entry.getPriority()));
        this.addEndLine();
        JCGroupBox jCGroupBox = new JCGroupBox((Object)(" " + ResourceManager.getString("Mount Request Entry Attributes") + " "));
        GridLayout gridLayout = null;
        gridLayout = media instanceof OpticalMedia ? new GridLayout(3, 3) : new GridLayout(2, 3);
        jCGroupBox.setLayout(gridLayout);
        Checkbox checkbox = new Checkbox(ResourceManager.getString("Processing"), this.entry.isBusy());
        checkbox.setEnabled(false);
        jCGroupBox.add((Component)checkbox);
        checkbox = new Checkbox(ResourceManager.getString("Clear requested"), this.entry.isClearing());
        checkbox.setEnabled(false);
        jCGroupBox.add((Component)checkbox);
        checkbox = new Checkbox(ResourceManager.getString("Using block I/O"), this.entry.usingBlockIO());
        checkbox.setEnabled(false);
        jCGroupBox.add((Component)checkbox);
        checkbox = new Checkbox(ResourceManager.getString("Write request"), this.entry.isWriteRequest());
        checkbox.setEnabled(false);
        jCGroupBox.add((Component)checkbox);
        checkbox = new Checkbox(ResourceManager.getString("File system request"), this.entry.isFileSystemRequest());
        checkbox.setEnabled(false);
        jCGroupBox.add((Component)checkbox);
        checkbox = new Checkbox(ResourceManager.getString("Stage request"), this.entry.isStageRequest());
        checkbox.setEnabled(false);
        jCGroupBox.add((Component)checkbox);
        if (media instanceof OpticalMedia) {
            checkbox = new Checkbox(ResourceManager.getString("Using flip side"), this.entry.usingFlipSide());
            checkbox.setEnabled(false);
            jCGroupBox.add((Component)checkbox);
        }
        this.addComponent((Component)jCGroupBox);
        this.addEndLine();
        this.setInitialized(true);
    }

    public MountReqEntryStatus(MountRequestEntry mountRequestEntry) {
        this.entry = mountRequestEntry;
    }
}

