/*
 * Decompiled with CFR 0.152.
 */
package sam.gui.status;

import java.awt.Insets;
import java.awt.List;
import java.awt.TextField;
import sam.gui.StatusPanel;
import sam.gui.dialog.ErrorDialog;
import sam.gui.dialog.MessageDialog;
import sam.model.Media;
import sam.model.Robot;
import sam.model.SamManager;
import sam.model.robot.Historian;
import sam.resource.ResourceManager;

public class ManualImportPanel
extends StatusPanel {
    private Robot robot;
    private boolean historian;
    private short mediaType = (short)-1;
    private TextField newLabel;
    private TextField newBarcode;
    private List mediaList;

    public boolean apply() {
        if (this.isEditable()) {
            Object object;
            String string = this.newLabel.getText();
            if (this.historian) {
                object = this.mediaList.getSelectedItem();
                if (object == null) {
                    ErrorDialog errorDialog = new ErrorDialog(ResourceManager.getString("A media type is required.  Please select one from the media type list."), this);
                    errorDialog.show();
                    return false;
                }
                this.mediaType = Media.getMediaStringType((String)object);
            }
            if (string.length() == 0) {
                object = new ErrorDialog(ResourceManager.getString("You must specify a VSN name."), this);
                ((MessageDialog)object).show();
                return false;
            }
            if ((this.mediaType & 0x200) == 512) {
                string = string.toUpperCase();
            }
            if (SamManager.isMediaDefined(string, this.mediaType)) {
                object = new ErrorDialog(ResourceManager.getString("This label is already in use.  Please choose another label name for this media."), this);
                ((MessageDialog)object).show();
                return false;
            }
            if (this.historian) {
                this.robot.importMedia(new Media(string, this.newBarcode.getText(), this.mediaType));
            } else {
                this.robot.importMedia(new Media(string, null, this.mediaType));
            }
        }
        return true;
    }

    public void setup() {
        if (this.isInitialized()) {
            this.removeAll();
        }
        int n = 31;
        this.options.weightx = 1.0;
        this.options.weighty = 1.0;
        this.options.gridheight = 1;
        this.options.anchor = 17;
        this.options.fill = 2;
        this.options.gridwidth = 1;
        this.options.insets = new Insets(2, 5, 2, 5);
        if (!this.historian) {
            this.mediaType = this.robot.getDefaultMediaType();
            if ((this.mediaType & 0x200) == 512) {
                n = 6;
            }
        }
        this.newLabel = this.addInputField(ResourceManager.getString("VSN"), "", n);
        this.newLabel.setEnabled(this.isEditable());
        this.addEndLine();
        if (this.historian) {
            this.newBarcode = this.addInputField(ResourceManager.getString("Barcode"), "", 32);
            this.newBarcode.setEnabled(this.isEditable());
            this.addEndLine();
            this.mediaList = new List(2, false);
            String[] stringArray = Media.getTypeStrings();
            int n2 = 0;
            while (n2 < stringArray.length) {
                this.mediaList.addItem(stringArray[n2]);
                ++n2;
            }
            this.addLabel(ResourceManager.getString("Media type"));
            this.addComponent(this.mediaList);
            this.mediaList.setEnabled(this.isEditable());
            this.addEndLine();
        } else {
            this.addField(ResourceManager.getString("Media type"), Media.getMediaString(this.mediaType));
            this.addEndLine();
        }
        this.setInitialized(true);
    }

    public ManualImportPanel(Robot robot) {
        this.robot = robot;
        this.historian = robot instanceof Historian;
    }
}

