/*
 * Decompiled with CFR 0.152.
 */
package sam.gui.status;

import java.awt.Checkbox;
import java.awt.Insets;
import java.awt.List;
import java.awt.TextField;
import sam.authority.AuthorityManager;
import sam.gui.StatusPanel;
import sam.gui.dialog.ConfirmDialog;
import sam.gui.dialog.ErrorDialog;
import sam.model.CatalogEntry;
import sam.model.Media;
import sam.model.OpticalDrive;
import sam.model.Robot;
import sam.model.SamDevice;
import sam.model.SamManager;
import sam.model.TapeDrive;
import sam.model.TapeMedia;
import sam.resource.ResourceManager;

public class LabelPanel
extends StatusPanel {
    private SamDevice device;
    private Media media;
    private int slotNumber;
    private TextField newLabel;
    private Checkbox relabelBox;
    private Checkbox eraseBox;
    private List blockList;

    public boolean apply() {
        if (this.isEditable()) {
            Object object;
            if (this.relabelBox != null) {
                ConfirmDialog confirmDialog;
                if (!this.relabelBox.getState()) {
                    ErrorDialog errorDialog = new ErrorDialog(ResourceManager.getString("Media is already labeled.  You will need to check the relabel option if you still desire to label it."), this);
                    errorDialog.show();
                    return false;
                }
                if (AuthorityManager.requiresConfirmation() && !(confirmDialog = new ConfirmDialog(ResourceManager.getString("You are requesting to relabel this media.  This could potentially result in the loss of data if the media was not recycled.  Do you want to proceed?"), this)).getConfirmation()) {
                    return false;
                }
            }
            int n = 0;
            try {
                n = Integer.parseInt(this.blockList.getSelectedItem());
            }
            catch (Exception exception) {}
            String string = this.newLabel.getText();
            if (string.length() == 0) {
                ErrorDialog errorDialog = new ErrorDialog(ResourceManager.getString("You must specify a VSN name."), this);
                errorDialog.show();
                return false;
            }
            if (this.media instanceof TapeMedia) {
                string = string.toUpperCase();
            }
            if (!string.equals(this.media.getName()) && SamManager.isMediaDefined(string, this.media.getType())) {
                ErrorDialog errorDialog = new ErrorDialog(ResourceManager.getString("This label is already in use.  Please choose another label name for this media."), this);
                errorDialog.show();
                return false;
            }
            if (this.eraseBox.getState() && AuthorityManager.requiresConfirmation() && this.media instanceof TapeMedia && !((ConfirmDialog)(object = new ConfirmDialog(ResourceManager.getString("Erasing tape media can possibly take hours to complete.  Are you sure you want to proceed?"), this))).getConfirmation()) {
                return false;
            }
            object = null;
            if (this.device instanceof Robot) {
                object = (Robot)this.device;
            } else if (this.device.getParent() != null) {
                object = (Robot)this.device.getParent();
                try {
                    this.slotNumber = ((Robot)object).getCatalog().getCatalogEntry(this.media).getSlotNumber();
                }
                catch (Exception exception) {}
            }
            if (object != null) {
                CatalogEntry catalogEntry = (CatalogEntry)((Robot)object).getCatalog().getEntry(this.slotNumber);
                ((Robot)object).label(this.media, catalogEntry.getEa(), string, this.eraseBox.getState(), n, null);
            } else if (this.device instanceof TapeDrive) {
                ((TapeDrive)this.device).label(this.media, string, n, this.eraseBox.getState());
            } else if (this.device instanceof OpticalDrive) {
                ((OpticalDrive)this.device).label(this.media, string, this.eraseBox.getState());
            }
        }
        return true;
    }

    public void setup() {
        if (this.isInitialized()) {
            this.removeAll();
        }
        int n = this.media.getLabelLength();
        this.options.weightx = 1.0;
        this.options.weighty = 1.0;
        this.options.gridheight = 1;
        this.options.anchor = 17;
        this.options.fill = 2;
        this.options.gridwidth = 1;
        this.options.insets = new Insets(2, 5, 2, 5);
        this.newLabel = this.addInputField(ResourceManager.getString("VSN"), "", n);
        this.addEndLine();
        if (this.media.isLabeled()) {
            this.relabelBox = new Checkbox(ResourceManager.getString("Relabel"), false);
            this.addComponent(this.relabelBox);
            this.addEndLine();
        }
        this.eraseBox = new Checkbox(ResourceManager.getString("Erase"), false);
        this.addComponent(this.eraseBox);
        this.addEndLine();
        if (this.media instanceof TapeMedia) {
            this.blockList = new List(2, false);
            int n2 = 16;
            int n3 = this.media.getMaxBlocksize();
            if (this.device instanceof TapeDrive) {
                n3 = ((TapeDrive)this.device).getMaxBlocksize();
            }
            while (n2 <= n3) {
                this.blockList.addItem(Integer.toString(n2));
                n2 <<= 1;
            }
            this.addLabel(ResourceManager.getString("Block size"));
            this.addComponent(this.blockList);
            this.addEndLine();
        }
        if (!this.isEditable()) {
            this.newLabel.setEnabled(false);
            this.relabelBox.setEnabled(false);
            this.eraseBox.setEnabled(false);
            if (this.blockList != null) {
                this.blockList.setEnabled(false);
            }
        }
        this.setInitialized(true);
    }

    public LabelPanel(SamDevice samDevice, Media media, int n) {
        this.device = samDevice;
        this.media = media;
        this.slotNumber = n;
    }

    public LabelPanel(SamDevice samDevice, Media media) {
        this.device = samDevice;
        this.media = media;
    }
}

