/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Component;
import java.awt.Font;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import sam.gui.DialogBox;

public abstract class PopUp
extends PopupMenu
implements ActionListener {
    protected Component parentComponent;

    public void actionPerformed(ActionEvent actionEvent) {
        this.handleCommand(actionEvent.getActionCommand());
    }

    public abstract void handleCommand(String var1);

    public abstract void setupMenu();

    public void show() {
        try {
            Font font = this.getFont();
            if (font.isBold()) {
                this.setFont(new Font(font.getName(), 0, font.getSize()));
            }
        }
        catch (Exception exception) {}
        this.removeAll();
        this.setupMenu();
        this.show(this.parentComponent, 5, 5);
    }

    public void show(MouseEvent mouseEvent) {
        try {
            Font font = this.getFont();
            if (font.isBold()) {
                this.setFont(new Font(font.getName(), 0, font.getSize()));
            }
        }
        catch (Exception exception) {}
        this.removeAll();
        this.setupMenu();
        this.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
    }

    public void addMenuItem(String string, boolean bl) {
        MenuItem menuItem = new MenuItem(string);
        menuItem.setEnabled(bl);
        menuItem.addActionListener(this);
        this.add(menuItem);
    }

    private MenuItem findMenuItem(String string) {
        int n = 0;
        while (n < this.getItemCount()) {
            if (this.getItem(n).getLabel().equals(string)) {
                return this.getItem(n);
            }
            ++n;
        }
        return null;
    }

    public void setEnabled(String string, boolean bl) {
        try {
            this.findMenuItem(string).setEnabled(bl);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void setHighlighted(String string) {
        try {
            MenuItem menuItem = this.findMenuItem(string);
            Font font = menuItem.getFont();
            menuItem.setFont(new Font(font.getName(), 1, font.getSize()));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void doDialogBox(DialogBox dialogBox) {
        DialogThread dialogThread = new DialogThread(dialogBox);
        dialogThread.start();
    }

    public PopUp(String string, Component component) {
        super(string);
        this.parentComponent = component;
    }

    private class DialogThread
    extends Thread {
        DialogBox dialogBox;

        public void run() {
            this.dialogBox.show();
        }

        DialogThread(DialogBox dialogBox) {
            PopUp.this = PopUp.this;
        }
    }
}

