/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import jclass.bwt.JCGroupBox;
import sam.gui.DeviceMgrDisplay;
import sam.gui.FSMgrDisplay;
import sam.gui.GUIManager;
import sam.gui.MountRequestDisplay;
import sam.gui.RobotMgrDisplay;
import sam.model.Robot;
import sam.model.SamManager;
import sam.resource.ResourceManager;

public class OperatorDisplay
extends Panel {
    private GridBagLayout gridbag = new GridBagLayout();

    private void setupDisplay() {
        JCGroupBox jCGroupBox;
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = SamManager.getRobotCount();
        this.setLayout(this.gridbag);
        this.setBackground(Color.lightGray);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 0;
        DeviceMgrDisplay deviceMgrDisplay = new DeviceMgrDisplay();
        if (n != 0) {
            RobotMgrDisplay robotMgrDisplay = new RobotMgrDisplay(n);
            Robot[] robotArray = SamManager.getRobots();
            int n2 = 0;
            while (n2 < robotArray.length) {
                robotMgrDisplay.addRobot(robotArray[n2]);
                deviceMgrDisplay.addRobot(robotArray[n2]);
                ++n2;
            }
            jCGroupBox = new JCGroupBox((Object)(" " + ResourceManager.getString("Robots") + " "));
            jCGroupBox.setLayout(new GridLayout(1, 1));
            jCGroupBox.setBackground(Color.lightGray);
            jCGroupBox.setFont(new Font("SansSerif", 1, GUIManager.getFontPointSize(2)));
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints.weighty = 0.0;
            jCGroupBox.add((Component)robotMgrDisplay);
            this.gridbag.setConstraints((Component)jCGroupBox, gridBagConstraints);
            this.add((Component)jCGroupBox);
            robotMgrDisplay.addRobotSelectionListener(deviceMgrDisplay);
        }
        if (SamManager.getManualMountCount() > 0) {
            deviceMgrDisplay.addManualMount();
        }
        if (SamManager.getHistorian() != null) {
            deviceMgrDisplay.addRobot(SamManager.getHistorian());
        }
        if (n > 1 || n == 1 && SamManager.getManualMountCount() > 0) {
            deviceMgrDisplay.addAllDevices();
        }
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weighty = 0.9;
        jCGroupBox = new JCGroupBox();
        jCGroupBox.setLayout(new GridLayout(1, 1));
        jCGroupBox.setBackground(Color.lightGray);
        jCGroupBox.add((Component)deviceMgrDisplay);
        this.gridbag.setConstraints((Component)jCGroupBox, gridBagConstraints);
        this.add((Component)jCGroupBox);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.1;
        gridBagConstraints.fill = 2;
        FSMgrDisplay fSMgrDisplay = new FSMgrDisplay(SamManager.getFileSystems());
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        jCGroupBox = new JCGroupBox((Object)(" " + ResourceManager.getString("File Systems") + " "));
        jCGroupBox.setLayout(new GridLayout(1, 1));
        jCGroupBox.setBackground(Color.lightGray);
        jCGroupBox.setFont(new Font("SansSerif", 1, GUIManager.getFontPointSize(2)));
        jCGroupBox.add((Component)fSMgrDisplay);
        this.gridbag.setConstraints((Component)jCGroupBox, gridBagConstraints);
        this.add((Component)jCGroupBox);
        gridBagConstraints.weightx = 1.0;
        MountRequestDisplay mountRequestDisplay = new MountRequestDisplay(SamManager.getMountRequestTable());
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        jCGroupBox = new JCGroupBox((Object)(" " + ResourceManager.getString("Mount Requests") + " "));
        jCGroupBox.setLayout(new GridLayout(1, 1));
        jCGroupBox.setBackground(Color.lightGray);
        jCGroupBox.setFont(new Font("SansSerif", 1, GUIManager.getFontPointSize(2)));
        jCGroupBox.add((Component)mountRequestDisplay);
        this.gridbag.setConstraints((Component)jCGroupBox, gridBagConstraints);
        this.add((Component)jCGroupBox);
    }

    public OperatorDisplay() {
        this.setupDisplay();
    }
}

