/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.util.Observable;
import java.util.Observer;
import jclass.bwt.JCProgressMeter;
import sam.gui.DialogBox;
import sam.gui.MediaIcon;
import sam.gui.ObjectDisplay;
import sam.gui.dialog.MediaDialog;
import sam.gui.popup.MediaPopUp;
import sam.model.Media;

public class MediaDisplay
extends ObjectDisplay
implements Observer {
    private static final int MIN_METER_HEIGHT = 15;
    private JCProgressMeter meter = new JCProgressMeter(0, 0, 100);
    private Media media;

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = this.meter.getPreferredSize();
        dimension.height += dimension2.height;
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        return dimension;
    }

    public Media getMedia() {
        return this.media;
    }

    public void update(Observable observable, Object object) {
        this.meter.setValue((int)this.media.getPercentageFull());
        this.repaint();
    }

    public DialogBox getDialogBox() {
        return new MediaDialog(this);
    }

    public void setVisibility(boolean bl) {
        Component[] componentArray = this.getComponents();
        int n = 0;
        while (n < componentArray.length) {
            componentArray[n].setVisible(bl);
            ++n;
        }
        this.invalidate();
        this.validate();
    }

    public void setMedia(Media media) {
        if (this.media != null) {
            this.media.deleteObserver(this);
        }
        this.media = media;
        this.setText(this.media == null ? "" : this.media.getName());
        ((MediaIcon)this.getIcon()).setMedia(this.media);
        int n = (int)((double)this.getIconWidth() * 1.2);
        int n2 = n / 10;
        if (n2 < 15) {
            n2 = 15;
        }
        this.meter.setPreferredSize(n, n2);
        if (this.media != null) {
            this.setVisibility(true);
            this.meter.setValue((int)this.media.getPercentageFull());
            this.media.addObserver(this);
            this.setEnabled(true);
        } else {
            this.setVisibility(false);
            this.setEnabled(false);
        }
        this.repaint();
    }

    MediaDisplay(Media media) {
        super(new MediaIcon(media), media == null ? "" : media.getName());
        this.meter.setBarSpacing(0);
        this.meter.setBarCount(20);
        this.meter.setShowLabel(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        this.gridBag.setConstraints((Component)this.meter, gridBagConstraints);
        this.meter.addMouseListener(this);
        this.add((Component)this.meter);
        this.setMedia(media);
        this.setPopupMenu(new MediaPopUp(this));
    }
}

