/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Observable;
import java.util.Observer;
import jclass.bwt.JCProgressMeter;
import sam.gui.DialogBox;
import sam.gui.GUIManager;
import sam.gui.ObjectPanel;
import sam.gui.popup.FSPopUp;
import sam.model.MassStorage;

public class FSDisplay
extends ObjectPanel
implements Observer {
    private MassStorage fileSystem;
    private JCProgressMeter meter;

    public MassStorage getMassStorage() {
        return this.fileSystem;
    }

    public DialogBox getDialogBox() {
        return null;
    }

    public void update(Observable observable, Object object) {
        if (this.fileSystem.isMounted()) {
            if (!this.meter.isVisible()) {
                this.meter.setVisible(true);
            }
            this.meter.setValue((int)this.fileSystem.getPercentageFull());
            this.repaint();
            return;
        }
        if (this.meter.isVisible()) {
            this.meter.setVisible(false);
            this.repaint();
        }
    }

    FSDisplay(MassStorage massStorage) {
        this.fileSystem = massStorage;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBackground(Color.lightGray);
        this.meter = new JCProgressMeter((int)massStorage.getPercentageFull(), 0, 100);
        this.meter.setBarSpacing(0);
        this.meter.setBarCount(100);
        this.meter.setBackground(Color.gray);
        this.meter.setForeground(Color.yellow);
        this.meter.setFont(new Font("Monospaced", 1, GUIManager.getFontPointSize(2)));
        this.meter.setLabelPosition(4);
        if (!massStorage.isMounted()) {
            this.meter.setVisible(false);
        }
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints((Component)this.meter, gridBagConstraints);
        this.add((Component)this.meter);
        this.meter.addMouseListener(this);
        massStorage.addObserver(this);
        this.setPopupMenu(new FSPopUp(this));
    }
}

