/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.util.Observable;
import java.util.Observer;
import sam.gui.DeviceIcon;
import sam.gui.DialogBox;
import sam.gui.GUIManager;
import sam.gui.ObjectDisplay;
import sam.gui.TextTicker;
import sam.gui.dialog.DeviceDialog;
import sam.gui.popup.DevicePopUp;
import sam.model.SamDevice;
import sam.resource.ResourceManager;

public class DeviceDisplay
extends ObjectDisplay
implements Observer {
    private Font textFont = new Font("Monospaced", 0, GUIManager.getFontPointSize(1));
    private int textCols = 20;
    private TextTicker textMessage;
    private SamDevice device;

    public static String getNameResource(SamDevice samDevice) {
        String string = ResourceManager.getDeviceName(samDevice.getEqId());
        if (string == null) {
            string = String.valueOf(samDevice.getVendorId()) + " " + samDevice.getProductId() + " : " + samDevice.getEqId();
        }
        return string;
    }

    public SamDevice getDevice() {
        return this.device;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = this.textMessage.getPreferredSize();
        dimension.height += dimension2.height;
        if (dimension.width < dimension2.width) {
            dimension.width = dimension2.width;
        }
        return dimension;
    }

    public void setMessage(String string) {
        string.trim();
        this.textMessage.setText(string);
    }

    public void setMessageFont(Font font) {
        this.textMessage.setFont(font);
    }

    public void update(Observable observable, Object object) {
        this.textMessage.setText(this.device.getCurrentMessageText());
        this.repaint();
    }

    public DialogBox getDialogBox() {
        return new DeviceDialog(this);
    }

    DeviceDisplay(SamDevice samDevice) {
        super(new DeviceIcon(samDevice), DeviceDisplay.getNameResource(samDevice));
        this.device = samDevice;
        this.textMessage = new TextTicker(this.textCols, this.textFont);
        this.textMessage.setText(samDevice.getCurrentMessageText());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        this.gridBag.setConstraints(this.textMessage, gridBagConstraints);
        this.add(this.textMessage);
        samDevice.addObserver(this);
        this.setPopupMenu(new DevicePopUp(this));
    }
}

