/*
 * Decompiled with CFR 0.152.
 */
package sam.authority;

import java.util.Hashtable;
import sam.model.Robot;
import sam.model.SamDevice;

public class AuthorityManager {
    public static final int ROOT = 0;
    public static final int OPERATOR = 1;
    public static final int USER = 2;
    private static int userLevel;
    private static Authorization base;
    private static Hashtable deviceAuthority;

    public static void setAuthorization(SamDevice samDevice, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        if (deviceAuthority == null) {
            deviceAuthority = new Hashtable();
        }
        deviceAuthority.put(samDevice, new Authorization(bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9));
    }

    public static void setAuthorization(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
        base = new Authorization(bl, bl2, bl3, bl4, bl5, bl6, bl7, bl8, bl9);
    }

    public static void setUserLevel(int n) {
        userLevel = n;
    }

    public static boolean checkUserLevel(int n) {
        return userLevel == n;
    }

    public static boolean isRootLevel() {
        return userLevel == 0;
    }

    public static boolean isOperatorLevel() {
        return userLevel == 0 || userLevel == 1;
    }

    public static boolean canLabel(SamDevice samDevice) {
        try {
            Authorization authorization = (Authorization)deviceAuthority.get(samDevice);
            return authorization.label;
        }
        catch (Exception exception) {
            return AuthorityManager.base.label;
        }
    }

    public static boolean canMove(Robot robot) {
        try {
            Authorization authorization = (Authorization)deviceAuthority.get(robot);
            return authorization.move;
        }
        catch (Exception exception) {
            return AuthorityManager.base.move;
        }
    }

    public static boolean canAudit(Robot robot) {
        try {
            Authorization authorization = (Authorization)deviceAuthority.get(robot);
            return authorization.audit;
        }
        catch (Exception exception) {
            return AuthorityManager.base.audit;
        }
    }

    public static boolean canChangeState(SamDevice samDevice) {
        try {
            Authorization authorization = (Authorization)deviceAuthority.get(samDevice);
            return authorization.state;
        }
        catch (Exception exception) {
            return AuthorityManager.base.state;
        }
    }

    public static boolean canClearMountRequests() {
        return AuthorityManager.base.clear;
    }

    public static boolean canExport(Robot robot) {
        try {
            Authorization authorization = (Authorization)deviceAuthority.get(robot);
            return authorization.export;
        }
        catch (Exception exception) {
            return AuthorityManager.base.export;
        }
    }

    public static boolean canUnload(Robot robot) {
        try {
            Authorization authorization = (Authorization)deviceAuthority.get(robot);
            return authorization.unload;
        }
        catch (Exception exception) {
            return AuthorityManager.base.unload;
        }
    }

    public static boolean canRelabel(SamDevice samDevice) {
        try {
            Authorization authorization = (Authorization)deviceAuthority.get(samDevice);
            return authorization.relabel;
        }
        catch (Exception exception) {
            return AuthorityManager.base.relabel;
        }
    }

    public static boolean requiresConfirmation() {
        return AuthorityManager.base.confirmation;
    }

    static {
        base = new Authorization(true, true, true, true, true, true, true, true, true);
    }

    private static class Authorization {
        boolean label;
        boolean relabel;
        boolean move;
        boolean audit;
        boolean state;
        boolean clear;
        boolean export;
        boolean unload;
        boolean confirmation;

        Authorization(boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6, boolean bl7, boolean bl8, boolean bl9) {
            this.label = bl;
            this.relabel = bl2;
            this.move = bl3;
            this.audit = bl4;
            this.state = bl5;
            this.clear = bl6;
            this.export = bl7;
            this.unload = bl8;
            this.confirmation = bl9;
        }
    }
}

