#!/bin/sh
# $Id: backto331.sh,v 1.1.1.1.2.2 2002/05/03 17:06:04 hm129959 Exp $

echo " "

ETCDIR=/etc/opt/SUNWsamfs
DATE=`/usr/bin/date +%m%d%y-%H%M`

# convert to old (pre-3.5.0) directory structure

OLD_DIR="/etc/fs/samfs"
NEW_ETC="/etc/opt/SUNWsamfs"
NEW_EXE="/opt/SUNWsamfs/sbin"
VAR_DIR="/var/opt/SUNWsamfs"
LAST_DIR="/etc/opt/SUNWsamfs/samfs.old.last"
DUMP_DIR=$LAST_DIR/cat.dump
CAT_DIR=$VAR_DIR/catalog
RSV_VSNS=${OLD_DIR}/.archive/ReservedVSNs


#  Function definitions

#  convert from 40 to 33x catalogs

convert_cat()
{

#  Extract the reserved VSNs info from this catalog.
	${NEW_EXE}/dump_cat -V $cat | /bin/sed -n -e "s/^#R//p" >> ${RSV_VSNS}

	echo $cat | grep '/' > /dev/null
	if [ $? -ne 0 ] ; then
		## cat in /etc/opt/SUNWsamfs/catalog
		## must live in /etc/fs/samfs, but mcf will be wrong
		cat_40_name=$CAT_DIR/$cat
		cat_331_name=$OLD_DIR/$cat
		echo "Catalog "$cat" will be converted to 33x version in "$OLD_DIR
		echo "mcf change required."
	else
		## cat someplace else
		## must be someplace else
		cat_40_name=${cat}.40
		cat_331_name=$cat
		if [ -f $cat ] ; then
			/bin/mv $cat ${cat}.40 
			echo "Catalog "$cat" moved to "$cat_40_name
		fi
	fi

	cat_size=`$NEW_EXE/dump_cat -n $cat_40_name`
	$NEW_EXE/dump_cat $cat_40_name | $NEW_EXE/old_build_cat -s $cat_size - $cat_331_name
	if [ ! $? -eq 0 ] ; then
		if [ ! -d $DUMP_DIR ] ; then
			/usr/bin/mkdir $DUMP_DIR
			/usr/bin/chmod 775 $DUMP_DIR
		fi
		echo "Problem converting catalog "$cat
		$NEW_EXE/dump_cat $cat_40_name > $DUMP_DIR/$eqord.cat
		if [ ! $? -eq 0 ] ; then
			echo "Could not dump catalog for equipment "$eqord
		else
			echo "Catalog for equipment "$eqord" dumped to "$DUMP_DIR/$eqord.cat
		fi
	else
		echo "Catalog "$cat_40_name" converted to "$cat_331_name
	fi

}

#  Main script.

if [ -d $LAST_DIR ] ; then
	echo "Converting to the pre-4.0 directory structure. . ."

	# create the pre-4.0 directory
	if [ ! -d $OLD_DIR ] ; then
		/usr/bin/mkdir $OLD_DIR
		/usr/bin/chmod 775 $OLD_DIR
	fi

	# move the mcf or issue a warning if it has changed.


	if [ -f ${LAST_DIR}/mcf -a -f ${NEW_ETC}/mcf ] ; then
		/bin/diff ${LAST_DIR}/mcf ${NEW_ETC}/mcf > /dev/null
		if [ $? -ne 0 ]; then
			/usr/bin/cp ${LAST_DIR}/mcf ${OLD_DIR}/mcf.33x
			echo "WARNING: mcf has changed - original 33x version saved "
			echo "WARNING: as " ${OLD_DIR}/mcf.33x 
		else
			/usr/bin/cp ${LAST_DIR}/mcf ${OLD_DIR}
		fi
	fi

	# move any files that go directly back from 4.0

NEWLIST="inquiry.conf recycler.cmd releaser.cmd samfs.cmd"

	for object in $NEWLIST
	do
		if [ -f ${NEW_ETC}/${object} ] ; then
			/usr/bin/cp ${NEW_ETC}/${object} $OLD_DIR
		fi
	done

	if [ ! -d ${OLD_DIR}/.archive ] ; then
		/bin/mkdir ${OLD_DIR}/.archive
	fi
	/bin/touch ${RSV_VSNS}

	# move any files that still work that we saved from the old 3.3.x

SAVELIST="LICENSE.3.3 ar_notify.sh ssi.sh"

	for object in $SAVELIST
	do
		if [ -f ${LAST_DIR}/${object} ] ; then
			/usr/bin/cp ${LAST_DIR}/${object} $OLD_DIR
		fi
	done

	# move any files that may have changed that we saved from the old 3.3.x

CHGLIST="archiver.cmd defaults.conf recycler.sh"

	for object in $CHGLIST
	do
		if [ -f ${LAST_DIR}/${object} ] ; then
			/usr/bin/cp ${LAST_DIR}/${object} $OLD_DIR/${object}.33xorig
			echo "WARNING:"$LAST_DIR/${object}" moved to "$OLD_DIR/${object}.33xorig
			echo "WARNING: If you have made changes to the 350 version you"
			echo "WARNING: will need to make the same changes in this file."
		fi
	done

	if [ -f $OLD_DIR/mcf ] ; then
		found_hist=0

		exec <$OLD_DIR/mcf
		while read eqid eqord eqtype famset state cat
		do
			case $eqid in
			\#*)
				continue
				;;
			esac

			if [ X = X$cat ]; then
				cat=$famset
			fi

			case $eqtype in
			'rb'|'hp'|'ml'|'cy'|'dm'|'ds'|'me'|'ac'|'eb'|'ad'|'a1'|'a2'|'sl'|'s9'|'ic')
				convert_cat
				;;
			'fj'|'gr'|'im'|'sk'|'sc')
				convert_cat
				## restore the network robot configuration file.
				nrconfig=`basename $eqid`
				if [ -f ${LAST_DIR}/${nrconfig} ] ; then
					/usr/bin/cp ${LAST_DIR}/${nrconfig} $OLD_DIR
				echo "Network or remote "$famset" configuration file "${nrconfig}" restored."
				fi
				;;
			'ss')
				## restore the remote configuration file.
				nrconfig=`basename $eqid`
				if [ -f ${LAST_DIR}/${nrconfig} ] ; then
					/usr/bin/cp ${LAST_DIR}/${nrconfig} $OLD_DIR
				echo "Remote "$famset" configuration file "${nrconfig}" restored."
				fi
				;;
			'hy')
				convert_cat
				found_hist=1
				;;
			default)
				;;
			esac
		done
		if [ $found_hist -eq 0 ] ; then
			if [ -f $CAT_DIR/historian ] ; then
				cat_size=`$NEW_EXE/dump_cat -n $CAT_DIR/historian`
				$NEW_EXE/dump_cat $CAT_DIR/historian | $NEW_EXE/old_build_cat -s $cat_size - $OLD_DIR/sam_historian
				echo "Catalog "$CAT_DIR/historian" converted to "$OLD_DIR/sam_historian
			fi
		fi
	fi
	echo "Conversion to the pre-3.5.x directory structure complete."
fi
