/* sefvals.h - SAM-FS system error facility (SEF)  information.
 *
 *      Description:
 *          Definitions for SAM-FS system error facility
 *
 */

/*    LSC_notice_begin
 *
 *      Solaris 2.x Sun Storage & Archiving Management File System
 *
 *      Copyright (c) 2003 Sun Microsystems, Inc.
 *      All Rights Reserved.
 *      SUN PROPRIETARY/CONFIDENTIAL.
 *
 *      Government Rights Notice
 *      Use, duplication, or disclosure by the U.S. Government is
 *      subject to restrictions set forth in the Sun Microsystems,
 *      Inc. license agreements and as provided in DFARS 227.7202-1(a)
 *      and 227.7202-3(a) (1995), DRAS 252.227-7013(c)(ii) (OCT 1988),
 *      FAR 12.212(a)(1995), FAR 52.227-19, or FAR 52.227-14 (ALT III),
 *      as applicable.  Sun Microsystems, Inc.
 *
 *    LSC_notice_end
 */

#ifndef SEFVALS_H
#define SEFVALS_H

#pragma ident "$ID$"

#ifndef SEFCODE

#ifndef SEFAPP

extern boolean_t	sef_on;			/* B_TRUE if sef is on; B_FALSE if not */

extern int			sef_file;		/* fd of sef log file */

extern boolean_t	sef_status(); /* check if sef is on and open sef log */

extern void			sef_init(dev_ent_t *, int);

extern int			sef_data(dev_ent_t *, int);

#endif /* !SEFAPP */
#endif /* !SEFCODE */

/*
 * Use a bitmask to specify which log sense pages we're interested in.
 * Right now, those are:
 * 02	write error counter page
 * 03	read error counter page
 * 06	nonmedia error page
 *
 * If the SEFPAGES bitmask is changed, SEF_HIGHEST, specifying the
 * highest-numbered page we're interested in, must also be changed.
 */
#define		SEFPAGES	0x4C

#define		SEFHIGHEST 6

#define		SEFMAGIC	0x94F

#define		SEFVERSION	1

#define		SEFFILE		SAM_VARIABLE_PATH"/sef/sefdata"

#endif /* !SEFVALS_H */
