/*
 * Decompiled with CFR 0.152.
 */
package sam.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import sam.model.DataSource;
import sam.model.MassStorage;
import sam.model.Media;
import sam.model.MountRequestTable;
import sam.model.OpticalDrive;
import sam.model.OpticalMedia;
import sam.model.RawDisk;
import sam.model.Robot;
import sam.model.SamDevice;
import sam.model.TapeDrive;
import sam.model.TapeMedia;
import sam.model.datasource.LiveData;
import sam.model.robot.ATL452Robot;
import sam.model.robot.Historian;
import sam.model.robot.IBMAPIRobot;
import sam.model.robot.MailboxNonSCSIRobot;
import sam.model.robot.MailboxSCSIRobot;
import sam.model.robot.NoMovementSCSIRobot;
import sam.model.robot.NonSCSIRobot;
import sam.model.robot.SCSIRobot;
import sam.resource.ResourceManager;

public class SamManager {
    private static Hashtable deviceTable = new Hashtable();
    private static Hashtable mediaTable = new Hashtable();
    private static MountRequestTable mountRequests = new MountRequestTable();
    private static Historian historian;
    private static String messageText;
    private static String priorityMessageText;
    private static int robotCount;
    private static boolean initialized;
    private static Updater updater;
    private static int passNumber;
    public static DataSource dataSource;

    public static void addDevice(SamDevice samDevice) {
        deviceTable.put(new Integer(samDevice.getEqId()), samDevice);
        if (samDevice instanceof Robot && !(samDevice instanceof Historian)) {
            ++robotCount;
        }
    }

    public static void setHistorian(Historian historian) {
        SamManager.historian = historian;
    }

    public static SamDevice getDevice(int n) {
        return (SamDevice)deviceTable.get(new Integer(n));
    }

    public static SamDevice[] getManualMountDevices() {
        Vector<SamDevice> vector = new Vector<SamDevice>();
        Enumeration enumeration = deviceTable.elements();
        while (enumeration.hasMoreElements()) {
            SamDevice samDevice = (SamDevice)enumeration.nextElement();
            if (samDevice.getParent() != null || samDevice instanceof Robot || samDevice instanceof MassStorage) continue;
            vector.insertElementAt(samDevice, 0);
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new SamDevice[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static MassStorage[] getFileSystems() {
        Vector<MassStorage> vector = new Vector<MassStorage>();
        Enumeration enumeration = deviceTable.elements();
        while (enumeration.hasMoreElements()) {
            try {
                MassStorage massStorage = (MassStorage)enumeration.nextElement();
                vector.insertElementAt(massStorage, 0);
            }
            catch (Exception exception) {}
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new MassStorage[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Robot[] getRobots() {
        if (robotCount == 0) {
            return null;
        }
        Vector<Robot> vector = new Vector<Robot>();
        Enumeration enumeration = deviceTable.elements();
        while (enumeration.hasMoreElements()) {
            try {
                Robot robot = (Robot)enumeration.nextElement();
                if (robot instanceof Historian) continue;
                vector.insertElementAt(robot, 0);
            }
            catch (ClassCastException classCastException) {}
        }
        if (vector.size() == 0) {
            return null;
        }
        Object[] objectArray = new Robot[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Historian getHistorian() {
        return historian;
    }

    public static MountRequestTable getMountRequestTable() {
        return mountRequests;
    }

    public static int getRobotCount() {
        return robotCount;
    }

    public static int getManualMountCount() {
        SamDevice[] samDeviceArray = SamManager.getManualMountDevices();
        if (samDeviceArray == null) {
            return 0;
        }
        return samDeviceArray.length;
    }

    public static void initialize() {
        if (initialized) {
            return;
        }
        if (dataSource == null) {
            dataSource = new LiveData();
        }
        if (!dataSource.setup()) {
            System.exit(1);
        }
        SamManager.resolveParentChild();
        updater = new Updater(SamManager.dataSource.updateInterval);
        SamManager.refresh();
        initialized = true;
    }

    public static void setDataSource(String string) {
        try {
            System.out.println(String.valueOf(ResourceManager.getString("Loading")) + ": " + string);
            Class<?> clazz = Class.forName(string);
            dataSource = (DataSource)clazz.newInstance();
            return;
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(ResourceManager.getString("Unable to load")) + ": " + string);
            System.exit(1);
            return;
        }
    }

    public static void start() {
        if (!initialized) {
            return;
        }
        updater.start();
    }

    public static void refresh() {
        dataSource.update();
        if (updater.getDuration() * ++passNumber >= SamManager.dataSource.garbageCollectionInterval) {
            SamManager.reconcileFuzzyMedia();
            passNumber = 0;
        }
        if (passNumber % 15 == 0) {
            mountRequests.refresh();
        }
    }

    public static String getMessageText() {
        return messageText;
    }

    public static String getPriorityMessageText() {
        return priorityMessageText;
    }

    public static Robot createRobot(String string, String string2, int n, int n2, int n3, int n4, int n5, String string3, String string4) {
        Robot robot;
        if (n3 == 8197) {
            robot = historian = new Historian(string, string2, n, n2, n3, n4, n5, string3, string4);
        } else {
            switch (n3) {
                case 6274: 
                case 6275: 
                case 6276: 
                case 6344: 
                case 6347: 
                case 6351: 
                case 6352: 
                case 6354: 
                case 6356: 
                case 6358: 
                case 6360: 
                case 6363: 
                case 6365: 
                case 6366: 
                case 6367: 
                case 6368: 
                case 6369: 
                case 6370: 
                case 6371: 
                case 6372: {
                    robot = new MailboxSCSIRobot(string, string2, n, n2, n3, n4, n5, string3, string4);
                    break;
                }
                case 6343: 
                case 6349: 
                case 6357: 
                case 6364: {
                    robot = new SCSIRobot(string, string2, n, n2, n3, n4, n5, string3, string4);
                    break;
                }
                case 6341: 
                case 6355: {
                    robot = new NoMovementSCSIRobot(string, string2, n, n2, n3, n4, n5, string3, string4);
                    break;
                }
                case 6225: {
                    robot = new IBMAPIRobot(string, string2, n, n2, n3, n4, n5, string3, string4);
                    break;
                }
                case 6231: {
                    robot = new NonSCSIRobot(string, string2, n, n2, n3, n4, n5, string3, string4);
                    break;
                }
                case 6220: 
                case 6222: {
                    robot = new MailboxNonSCSIRobot(string, string2, n, n2, n3, n4, n5, string3, string4);
                    break;
                }
                case 6346: {
                    robot = new ATL452Robot(string, string2, n, n2, n3, n4, n5, string3, string4);
                    break;
                }
                default: {
                    robot = new Robot(string, string2, n, n2, n3, n4, n5, string3, string4);
                }
            }
        }
        SamManager.addDevice(robot);
        return robot;
    }

    public static MassStorage createMassStorage(String string, String string2, int n, int n2, int n3, int n4, int n5, String string3, String string4, String string5) {
        MassStorage massStorage = new MassStorage(string, string2, n, n2, n3, n4, n5, string3, string4, string5);
        SamManager.addDevice(massStorage);
        return massStorage;
    }

    public static RawDisk createRawDisk(String string, String string2, int n, int n2, int n3, int n4, int n5, String string3, String string4, String string5) {
        RawDisk rawDisk = new RawDisk(string, string2, n, n2, n3, n4, n5, string3, string4, string5);
        SamManager.addDevice(rawDisk);
        return rawDisk;
    }

    public static TapeDrive createTapeDrive(String string, String string2, int n, int n2, int n3, int n4, int n5, String string3, String string4, String string5, int n6, int n7, int n8, int n9) {
        TapeDrive tapeDrive = new TapeDrive(string, string2, n, n2, n3, n4, n5, string3, string4, string5, n6, n7, n8, n9);
        SamManager.addDevice(tapeDrive);
        return tapeDrive;
    }

    public static OpticalDrive createOpticalDrive(String string, String string2, int n, int n2, int n3, int n4, int n5, String string3, String string4) {
        OpticalDrive opticalDrive = new OpticalDrive(string, string2, n, n2, n3, n4, n5, string3, string4);
        SamManager.addDevice(opticalDrive);
        return opticalDrive;
    }

    public static void update(String string, String string2) {
        if (!string.equals(messageText)) {
            messageText = string;
        }
        if (!string2.equals(priorityMessageText)) {
            priorityMessageText = string2;
        }
    }

    public static Media findMedia(String string, String string2, short s, int n, int n2, boolean bl) {
        if (s != 0 && !bl && string != null && string.trim().length() > 0) {
            return SamManager.findMedia(string, string2, s);
        }
        Media media = null;
        if (s == 0) {
            media = new Media(string, string2, s, bl, SamManager.getDevice(n), n2);
        } else if ((s & 0x200) == 512) {
            media = new TapeMedia(string, string2, s, bl, SamManager.getDevice(n), n2);
        } else if ((s & 0x500) == 1280) {
            media = new OpticalMedia(string, string2, s, bl, SamManager.getDevice(n), n2);
        }
        return media;
    }

    public static Media findMedia(String string, String string2, short s) {
        Media media = null;
        if ((s & 0x200) == 512) {
            media = new TapeMedia(string, string2, s);
        } else if ((s & 0x500) == 1280) {
            media = new OpticalMedia(string, string2, s);
        }
        return media;
    }

    public static Media getMedia(String string, String string2, short s, int n, int n2, boolean bl) {
        MediaEntry mediaEntry = null;
        Media media = SamManager.findMedia(string, string2, s, n, n2, bl);
        mediaEntry = (MediaEntry)mediaTable.get(media);
        if (mediaEntry == null) {
            mediaEntry = new MediaEntry(media);
            mediaTable.put(media, mediaEntry);
        } else if (mediaEntry.stale) {
            mediaEntry.stale = false;
            mediaTable.put(media, mediaEntry);
        }
        return mediaEntry.media;
    }

    public static boolean isMediaDefined(String string, short s) {
        return mediaTable.get(SamManager.findMedia(string, "", s)) != null;
    }

    private static void reconcileFuzzyMedia() {
        if (mediaTable.size() == 0) {
            return;
        }
        Enumeration enumeration = mediaTable.elements();
        while (enumeration.hasMoreElements()) {
            MediaEntry mediaEntry = (MediaEntry)enumeration.nextElement();
            if (mediaEntry.stale) {
                mediaTable.remove(mediaEntry.media);
                continue;
            }
            mediaEntry.stale = true;
            mediaTable.put(mediaEntry.media, mediaEntry);
        }
    }

    private static void resolveParentChild() {
        Enumeration enumeration = deviceTable.elements();
        while (enumeration.hasMoreElements()) {
            SamDevice samDevice = (SamDevice)enumeration.nextElement();
            if (!samDevice.isParent()) continue;
            Enumeration enumeration2 = deviceTable.elements();
            while (enumeration2.hasMoreElements()) {
                SamDevice samDevice2 = (SamDevice)enumeration2.nextElement();
                if (!samDevice2.isChild(samDevice)) continue;
                if (samDevice instanceof Robot) {
                    ((Robot)samDevice).insertDeviceAt(samDevice2, 0);
                    continue;
                }
                if (!(samDevice instanceof MassStorage) || !(samDevice2 instanceof RawDisk)) continue;
                ((MassStorage)samDevice).insertDiskAt((RawDisk)samDevice2, 0);
            }
        }
    }

    public static void printDump() {
        System.out.println("devices:" + deviceTable.size() + " media:" + mediaTable.size() + " mntreqs:" + mountRequests.getSize() + "  robots:" + robotCount);
    }

    public static void printMediaDump() {
        MediaEntry mediaEntry;
        System.out.println("++++ Media");
        Enumeration enumeration = mediaTable.elements();
        while (enumeration.hasMoreElements()) {
            mediaEntry = (MediaEntry)enumeration.nextElement();
            if (mediaEntry.fuzzy) continue;
            System.out.println(mediaEntry.media.toString());
        }
        System.out.println("---- Fuzzy Media");
        enumeration = mediaTable.elements();
        while (enumeration.hasMoreElements()) {
            mediaEntry = (MediaEntry)enumeration.nextElement();
            if (!mediaEntry.fuzzy) continue;
            System.out.println(mediaEntry.media.toString());
        }
    }

    private SamManager() {
    }

    private static class MediaEntry {
        public Media media;
        public boolean stale;
        public boolean fuzzy;

        MediaEntry(Media media) {
            this.media = media;
            this.fuzzy = media.isFuzzy();
        }
    }

    private static class Updater
    extends Thread {
        private int sleepDuration;

        Updater(int n) {
            this.setDuration(n);
        }

        public void setDuration(int n) {
            this.sleepDuration = n * 1000;
        }

        public int getDuration() {
            return this.sleepDuration / 1000;
        }

        public void run() {
            while (this.isAlive()) {
                try {
                    Thread.sleep(this.sleepDuration);
                }
                catch (Exception exception) {}
                SamManager.refresh();
            }
        }
    }
}

