/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.ScrollPane;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import sam.gui.ClickPanel;
import sam.gui.GUIManager;
import sam.gui.event.MouseClicksListener;
import sam.gui.event.SelectionListener;

public class GridManager
extends Panel
implements MouseClicksListener {
    private static final int INS_PIXELS = 5;
    protected GridBagLayout gridbag;
    protected Panel display;
    private int rowMax;
    private int colMax;
    private int curRow;
    private int curCol;
    private int minDisplayRow = 1;
    private int minDisplayCol = 1;
    private Panel currentPanel;
    private ScrollPane pane;
    private boolean dummyRowExists = false;
    private Vector selectionHandlers = new Vector();

    public void setTopAlignment() {
        if (!this.dummyRowExists) {
            this.dummyRowExists = true;
            this.addTopAlignRow();
            this.repaint();
        }
    }

    public int getRowCount() {
        return this.rowMax;
    }

    public int getRow(int n) {
        return n / this.colMax;
    }

    public int getColumn(int n) {
        return n - this.getRow(n) * this.colMax;
    }

    public int getPanelCount() {
        return this.display.getComponentCount();
    }

    public Panel getPanel(int n) {
        try {
            return (Panel)this.display.getComponent(n);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionHandlers.addElement(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.selectionHandlers.removeElement(selectionListener);
    }

    public void setMinimumSize(int n, int n2) {
        this.minDisplayRow = n;
        this.minDisplayCol = n2;
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.getPreferredSize().width / (this.colMax - this.minDisplayCol + 1), this.getPreferredSize().height / (this.rowMax - this.minDisplayRow + 1));
    }

    public Dimension getPreferredSize() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (this.display == null) {
            return new Dimension(-1, -1);
        }
        int n6 = this.display.getComponentCount();
        if (this.dummyRowExists) {
            n6 -= this.colMax;
        }
        int n7 = 0;
        while (n7 < n6) {
            Panel panel = (Panel)this.display.getComponent(n7);
            n += panel.getPreferredSize().width + 10;
            if (panel.getPreferredSize().height + 10 > n2) {
                n2 = panel.getPreferredSize().height + 10;
            }
            if (++n5 >= this.colMax) {
                n5 = 0;
                if (n > n3) {
                    n3 = n;
                }
                n = 0;
                n4 += n2;
                n2 = 0;
            }
            ++n7;
        }
        this.pane.setSize(n3, n4);
        return new Dimension(n3 += this.pane.getVScrollbarWidth() + 10, n4 += this.pane.getHScrollbarHeight() + 10);
    }

    private void notifyListeners(Panel panel) {
        if (this.selectionHandlers.isEmpty()) {
            return;
        }
        Enumeration enumeration = this.selectionHandlers.elements();
        while (enumeration.hasMoreElements()) {
            ((SelectionListener)enumeration.nextElement()).selected(panel);
        }
    }

    public void updatePanel(int n, Panel panel) {
        this.display.remove(n);
        this.addPanel(n, panel);
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public void removeAll() {
        if (this.display.getComponentCount() == 0) {
            return;
        }
        this.display.removeAll();
    }

    public void mouseLeftClicked(MouseEvent mouseEvent) {
        Panel panel = ClickPanel.findParentPanel(mouseEvent);
        this.setCurrentPanel(panel);
    }

    public void mouseRightClicked(MouseEvent mouseEvent) {
    }

    public void mouseDoubleClicked(MouseEvent mouseEvent) {
    }

    public void setCurrentPanel(Panel panel) {
        this.currentPanel = panel;
        this.notifyListeners(this.currentPanel);
    }

    public Panel getCurrentPanel() {
        return this.currentPanel;
    }

    public void addPanel(int n, Panel panel) {
        int n2;
        int n3;
        if (n < 0) {
            n3 = this.curRow;
            n2 = this.curCol;
        } else {
            n3 = this.getRow(n);
            n2 = this.getColumn(n);
        }
        if (n3 >= this.rowMax) {
            return;
        }
        Insets insets = new Insets(5, 5, 5, 5);
        if (panel == null) {
            panel = new Panel();
        }
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        if (n2 == this.colMax - 1) {
            gridBagConstraints.gridwidth = 0;
        }
        gridBagConstraints.insets = insets;
        this.gridbag.setConstraints(panel, gridBagConstraints);
        this.display.add((Component)panel, n);
        if (panel instanceof ClickPanel) {
            ((ClickPanel)panel).addMouseClicksListener(this);
        }
    }

    private void addTopAlignRow() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        while (n < this.colMax) {
            Panel panel = new Panel();
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = n == this.colMax - 1 ? 0 : 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 3;
            this.gridbag.setConstraints(panel, gridBagConstraints);
            this.display.add((Component)panel, -1);
            ++n;
        }
    }

    public void addPanel(Panel panel) {
        if (this.curRow >= this.rowMax) {
            return;
        }
        this.addPanel(-1, panel);
        ++this.curCol;
        if (this.curCol >= this.colMax) {
            this.curCol = 0;
            ++this.curRow;
        }
    }

    GridManager(int n, int n2) {
        this.rowMax = n;
        this.colMax = n2;
        this.display = new Panel();
        this.gridbag = new GridBagLayout();
        this.display.setLayout(this.gridbag);
        this.pane = new ScrollPane();
        this.pane.getVAdjustable().setUnitIncrement(GUIManager.getIconHeight(5) / 10);
        this.pane.getHAdjustable().setUnitIncrement(GUIManager.getIconHeight(5) / 10);
        this.pane.add(this.display);
        this.setLayout(new GridLayout(1, 1));
        this.add(this.pane);
    }
}

