/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.util.Hashtable;
import sam.gui.CatalogMediaIcon;
import sam.gui.TableDisplay;
import sam.gui.dialog.CatEntryDialog;
import sam.gui.dialog.TableEntryDialog;
import sam.gui.popup.CatEntryPopUp;
import sam.model.Catalog;
import sam.model.CatalogEntry;
import sam.model.Media;
import sam.model.Robot;
import sam.model.Table;
import sam.model.TableEntry;
import sam.resource.ResourceManager;

public class CatalogDisplay
extends TableDisplay {
    private static final String[] columnHeaders = new String[]{"Slot", "Ea", "Media", "ImportExport", "VSN", "Barcode", "Access Count", "Capacity", "Space", "% Full", "Label Date", "Modification Date", "Mount Date"};
    private static final int[] columnAlignments = new int[]{TableDisplay.ALIGN_RIGHT, TableDisplay.ALIGN_RIGHT, TableDisplay.ALIGN_MIDDLE, TableDisplay.ALIGN_MIDDLE, TableDisplay.ALIGN_LEFT, TableDisplay.ALIGN_LEFT, TableDisplay.ALIGN_RIGHT, TableDisplay.ALIGN_RIGHT, TableDisplay.ALIGN_RIGHT, TableDisplay.ALIGN_RIGHT, TableDisplay.ALIGN_LEFT, TableDisplay.ALIGN_LEFT, TableDisplay.ALIGN_LEFT};
    private static final String[] defaultHeaders = new String[]{"Slot", "Media", "% Full", "VSN"};

    protected Hashtable buildSlotData(TableEntry tableEntry) {
        CatalogEntry catalogEntry = (CatalogEntry)tableEntry;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        Media media = catalogEntry.getMedia();
        hashtable.put("Slot", new Integer(catalogEntry.getSlotNumber()));
        if (catalogEntry.isImportExport()) {
            hashtable.put("ImportExport", "X");
        }
        if (media != null) {
            try {
                hashtable.put("Media", CatalogDisplay.getMediaIcon(catalogEntry, this.getRowHeight()));
            }
            catch (Exception exception) {}
            hashtable.put("VSN", media.getName());
            if (media.getBarcode() != null) {
                hashtable.put("Barcode", media.getBarcode());
            }
            hashtable.put("Access Count", new Integer(media.getAccessCount()));
            hashtable.put("Capacity", new Long(media.getCapacity()));
            hashtable.put("Space", new Long(media.getSpace()));
            if (media.getPercentageFull() >= 0) {
                hashtable.put("% Full", new Integer(media.getPercentageFull()));
            }
            hashtable.put("Label Date", media.getLabelDate());
            if (media.getModificationDate() != null) {
                hashtable.put("Modification Date", media.getModificationDate());
            }
            if (media.getMountDate() != null) {
                hashtable.put("Mount Date", media.getMountDate());
            }
        }
        hashtable.put("Slot", catalogEntry.getEa());
        return hashtable;
    }

    public static CatalogMediaIcon getMediaIcon(CatalogEntry catalogEntry, int n) {
        if (!catalogEntry.isOccupied() || !catalogEntry.isInUse()) {
            return null;
        }
        CatalogMediaIcon catalogMediaIcon = new CatalogMediaIcon(catalogEntry, -1, n);
        return catalogMediaIcon;
    }

    protected void defineHeaders(Table table) {
        Catalog catalog = (Catalog)table;
        Robot robot = catalog.getParent();
        String[] stringArray = ResourceManager.getCatalogHeaders(robot.getEqId());
        if (stringArray == null) {
            stringArray = ResourceManager.getCatalogTypeHeaders(robot.getTypeString());
        }
        if (stringArray == null) {
            stringArray = defaultHeaders;
        }
        this.setHeaderRow(stringArray, columnHeaders, columnAlignments);
    }

    protected TableEntryDialog getDialogBox() {
        return new CatEntryDialog(this);
    }

    public CatalogDisplay(Catalog catalog) {
        super(catalog);
        this.setPopupMenu(new CatEntryPopUp(this));
    }
}

