/*
 * Decompiled with CFR 0.152.
 */
package sam.gui.status;

import java.awt.Checkbox;
import java.awt.CheckboxGroup;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Insets;
import jclass.bwt.JCGroupBox;
import sam.authority.AuthorityManager;
import sam.gui.StatusPanel;
import sam.model.MassStorage;
import sam.model.OpticalDrive;
import sam.model.Robot;
import sam.model.SamDevice;
import sam.model.TapeDrive;
import sam.resource.ResourceManager;

public class DeviceStatus
extends StatusPanel {
    private SamDevice device;
    private CheckboxGroup stateGroup;
    private Checkbox oldState;

    public boolean apply() {
        Checkbox checkbox;
        if (this.isEditable() && this.oldState != (checkbox = this.stateGroup.getSelectedCheckbox())) {
            if (checkbox.getLabel().equals(ResourceManager.getString("On"))) {
                this.device.setState(0);
            } else if (checkbox.getLabel().equals(ResourceManager.getString("Off"))) {
                this.device.setState(4);
            } else if (checkbox.getLabel().equals(ResourceManager.getString("Unavailable"))) {
                this.device.setState(3);
            } else if (checkbox.getLabel().equals(ResourceManager.getString("Down"))) {
                this.device.setState(5);
            }
        }
        return true;
    }

    public void setup() {
        if (this.isInitialized()) {
            this.removeAll();
        }
        this.options.weightx = 1.0;
        this.options.weighty = 1.0;
        this.options.gridheight = 1;
        this.options.anchor = 17;
        this.options.fill = 2;
        this.options.gridwidth = 1;
        this.options.insets = new Insets(2, 5, 2, 5);
        this.addField(ResourceManager.getString("Name"), this.device.getName());
        if (!(this.device instanceof MassStorage) && this.device.getTypeString() != null) {
            this.addField(ResourceManager.getString("Type"), this.device.getTypeString());
        }
        if (!this.device.isParent()) {
            this.addField(ResourceManager.getString("Equipment ID"), Integer.toString(this.device.getEqId()));
            this.addField(ResourceManager.getString("Parent ID"), Integer.toString(this.device.getFamilySetEqId()));
        } else {
            this.addField(ResourceManager.getString("Equipment ID"), Integer.toString(this.device.getEqId()));
        }
        this.addEndLine();
        try {
            if (this.device.getVendorId().length() > 0) {
                this.addField(ResourceManager.getString("Vendor"), this.device.getVendorId());
                this.addField(ResourceManager.getString("Product"), this.device.getProductId());
                this.addEndLine();
            }
        }
        catch (Exception exception) {}
        this.stateGroup = new CheckboxGroup();
        JCGroupBox jCGroupBox = new JCGroupBox((Object)(" " + ResourceManager.getString("Device State") + " "));
        jCGroupBox.setLayout(new GridLayout(2, 3));
        Checkbox checkbox = new Checkbox(ResourceManager.getString("On"), this.device.getState() == 0, this.stateGroup);
        jCGroupBox.add((Component)checkbox);
        Checkbox checkbox2 = new Checkbox(ResourceManager.getString("Off"), this.device.getState() == 4, this.stateGroup);
        jCGroupBox.add((Component)checkbox2);
        Checkbox checkbox3 = new Checkbox(ResourceManager.getString("Read-only"), this.device.getState() == 1, this.stateGroup);
        jCGroupBox.add((Component)checkbox3);
        Checkbox checkbox4 = new Checkbox(ResourceManager.getString("Idle"), this.device.getState() == 2, this.stateGroup);
        jCGroupBox.add((Component)checkbox4);
        checkbox4.setEnabled(false);
        Checkbox checkbox5 = new Checkbox(ResourceManager.getString("Unavailable"), this.device.getState() == 3, this.stateGroup);
        jCGroupBox.add((Component)checkbox5);
        Checkbox checkbox6 = new Checkbox(ResourceManager.getString("Down"), this.device.getState() == 5, this.stateGroup);
        jCGroupBox.add((Component)checkbox6);
        this.addComponent((Component)jCGroupBox);
        this.addEndLine();
        if (this.device.getState() == 5) {
            checkbox.setEnabled(false);
            checkbox5.setEnabled(false);
        }
        if (this.device instanceof TapeDrive || this.device instanceof OpticalDrive || this.device instanceof Robot) {
            JCGroupBox jCGroupBox2 = new JCGroupBox((Object)(" " + ResourceManager.getString("Device Attributes") + " "));
            jCGroupBox2.setLayout(new GridLayout(5, 3));
            Checkbox checkbox7 = new Checkbox(ResourceManager.getString("Maintenance mode"), this.device.inMaintenanceMode());
            jCGroupBox2.add((Component)checkbox7);
            checkbox7.setEnabled(false);
            checkbox7 = new Checkbox(ResourceManager.getString("Scanning"), this.device.isScanning());
            jCGroupBox2.add((Component)checkbox7);
            checkbox7.setEnabled(false);
            checkbox7 = new Checkbox(ResourceManager.getString("Scan error"), this.device.scanError());
            jCGroupBox2.add((Component)checkbox7);
            checkbox7.setEnabled(false);
            checkbox7 = new Checkbox(ResourceManager.getString("Audit mode"), this.device.inAuditMode());
            jCGroupBox2.add((Component)checkbox7);
            checkbox7.setEnabled(false);
            checkbox7 = new Checkbox(ResourceManager.getString("Wait for idle"), this.device.isIdleWaiting());
            jCGroupBox2.add((Component)checkbox7);
            checkbox7.setEnabled(false);
            checkbox7 = new Checkbox(ResourceManager.getString("Operator attention"), this.device.needsOperatorAttention());
            jCGroupBox2.add((Component)checkbox7);
            checkbox7.setEnabled(false);
            checkbox7 = new Checkbox(ResourceManager.getString("Unload requested"), this.device.isUnloading());
            jCGroupBox2.add((Component)checkbox7);
            checkbox7.setEnabled(false);
            checkbox7 = new Checkbox(ResourceManager.getString("Reserved"), this.device.isReserved());
            jCGroupBox2.add((Component)checkbox7);
            checkbox7.setEnabled(false);
            checkbox7 = new Checkbox(ResourceManager.getString("Writing"), this.device.isWriting());
            jCGroupBox2.add((Component)checkbox7);
            checkbox7.setEnabled(false);
            checkbox7 = new Checkbox(ResourceManager.getString("Open"), this.device.isOpen());
            jCGroupBox2.add((Component)checkbox7);
            checkbox7.setEnabled(false);
            checkbox7 = new Checkbox(ResourceManager.getString("Ready"), this.device.isReady());
            jCGroupBox2.add((Component)checkbox7);
            checkbox7.setEnabled(false);
            checkbox7 = new Checkbox(ResourceManager.getString("Present"), this.device.isPresent());
            jCGroupBox2.add((Component)checkbox7);
            checkbox7.setEnabled(false);
            checkbox7 = new Checkbox(ResourceManager.getString("Requires cleaning"), this.device.needsCleaning());
            jCGroupBox2.add((Component)checkbox7);
            checkbox7.setEnabled(false);
            if (this.device instanceof TapeDrive) {
                checkbox7 = new Checkbox(ResourceManager.getString("Positioning"), ((TapeDrive)this.device).isPositioning());
                jCGroupBox2.add((Component)checkbox7);
                checkbox7.setEnabled(false);
            }
            if (this.device instanceof Robot) {
                checkbox7 = new Checkbox(ResourceManager.getString("Slots full"), ((Robot)this.device).isFull());
                jCGroupBox2.add((Component)checkbox7);
                checkbox7.setEnabled(false);
            }
            this.addComponent((Component)jCGroupBox2);
            this.addEndLine();
        } else if (this.device instanceof MassStorage) {
            JCGroupBox jCGroupBox3 = new JCGroupBox((Object)(" " + ResourceManager.getString("File System Attributes") + " "));
            jCGroupBox3.setLayout(new GridLayout(1, 3));
            Checkbox checkbox8 = new Checkbox(ResourceManager.getString("Mounted"), ((MassStorage)this.device).isMounted());
            jCGroupBox3.add((Component)checkbox8);
            checkbox8.setEnabled(false);
            checkbox8 = new Checkbox(ResourceManager.getString("Archiver active"), ((MassStorage)this.device).isArchiverActive());
            jCGroupBox3.add((Component)checkbox8);
            checkbox8.setEnabled(false);
            checkbox8 = new Checkbox(ResourceManager.getString("Releaser active"), ((MassStorage)this.device).isReleaserActive());
            jCGroupBox3.add((Component)checkbox8);
            checkbox8.setEnabled(false);
            this.addComponent((Component)jCGroupBox3);
            this.addEndLine();
        }
        if (!this.isEditable()) {
            checkbox.setEnabled(false);
            checkbox2.setEnabled(false);
            checkbox5.setEnabled(false);
            checkbox6.setEnabled(false);
        } else if (!AuthorityManager.canChangeState(this.device)) {
            checkbox2.setEnabled(false);
            checkbox5.setEnabled(false);
            checkbox6.setEnabled(false);
            checkbox3.setEnabled(false);
        }
        this.oldState = this.stateGroup.getSelectedCheckbox();
        this.setInitialized(true);
    }

    public DeviceStatus(SamDevice samDevice) {
        this.device = samDevice;
    }
}

