/*
 * Decompiled with CFR 0.152.
 */
package sam.gui.popup;

import sam.authority.AuthorityManager;
import sam.gui.HistorianCatDisplay;
import sam.gui.dialog.ConfirmDialog;
import sam.gui.dialog.ManualImportDialog;
import sam.gui.popup.TableEntryPopUp;
import sam.model.Catalog;
import sam.model.CatalogEntry;
import sam.model.Robot;
import sam.model.TableEntry;
import sam.model.robot.Historian;
import sam.resource.ResourceManager;

public class HistorianPopUp
extends TableEntryPopUp {
    private CatalogEntry entry;
    private Catalog catalog;
    private Historian historian;

    public void handleCommand(String string) {
        if (string.equals(ResourceManager.getString("Import"))) {
            ManualImportDialog manualImportDialog = new ManualImportDialog((HistorianCatDisplay)this.parentComponent);
            manualImportDialog.show();
            return;
        }
        if (string.equals(ResourceManager.getString("Export"))) {
            ConfirmDialog confirmDialog;
            if (AuthorityManager.requiresConfirmation() && !(confirmDialog = new ConfirmDialog(ResourceManager.getString("Exporting this entry will result in the loss of all history information for this media.  Do you want to proceed?"), (HistorianCatDisplay)this.parentComponent)).getConfirmation()) {
                return;
            }
            this.historian.export(this.entry.getEa());
        }
    }

    protected void setupMenu(TableEntry tableEntry) {
        this.entry = (CatalogEntry)tableEntry;
        Robot robot = this.catalog.getParent();
        this.addMenuItem(ResourceManager.getString("Import"), AuthorityManager.canExport(robot));
        this.addMenuItem(ResourceManager.getString("Export"), AuthorityManager.isRootLevel());
    }

    public HistorianPopUp(HistorianCatDisplay historianCatDisplay) {
        super(ResourceManager.getString("Historian Entry"), historianCatDisplay);
        this.catalog = (Catalog)historianCatDisplay.getDataTable();
        this.historian = (Historian)this.catalog.getParent();
    }
}

