#!/bin/sh
# $Id: backto350.sh,v 1.1.2.1 2002/05/03 17:06:04 hm129959 Exp $

echo " "

ETCDIR=/etc/opt/SUNWsamfs
DATE=`/usr/bin/date +%m%d%y-%H%M`

# convert to old (3.5.0) directory structure

OLD_ETC="/etc/opt/LSCsamfs"
OLD_EXE="/opt/LSCsamfs/sbin"
OLD_VAR="/var/opt/LSCsamfs"
OLD_CAT=$OLD_VAR/catalog
RSV_VSNS=${OLD_VAR}/archiver/ReservedVSNs

NEW_ETC="/etc/opt/SUNWsamfs"
NEW_EXE="/opt/SUNWsamfs/sbin"
VAR_DIR="/var/opt/SUNWsamfs"
CAT_DIR=$VAR_DIR/catalog


#  Function definitions

#  copy files back to 350 directory if not there
#  copy_conf file olddir newdir

copy_conf()
{
	if [ -f $3/$1 ]; then
		if [ ! -f $2/$1 ]; then
			/bin/cp $3/$1 $2/$1
		else
			/bin/diff $2/$1 $3/$1 > /dev/null
			if [ $? -ne 0 ]; then
				echo "Configuration file $2/$1 exists but is not"
				echo "identical to SAM-FS 4.0 file $3/$1."
			fi
		fi
	else
		if [ -f $2/$1 ]; then
			echo "Note:  configuration file $3/$1 does not exist"
			echo "but it is in your SAM-FS 3.5.0 configuration."
		fi
	fi
	
}

#  convert from 40 to 350 catalog locations

convert_cat()
{
	echo $cat | grep '/' > /dev/null
	if [ $? -ne 0 ] ; then
		## catalog in /etc/opt/SUNWsamfs/catalog
		## must live in /etc/opt/LSCsamfs/catalog
		cat_40_name=$CAT_DIR/$cat
		cat_350_name=$OLD_CAT/$cat
		echo "Catalog "$cat" will be converted to 350 version in "${OLD_CAT}.
	else
		## catalog someplace else - leave it where it is, back it up
		cat_40_name=${cat}.40
		cat_350_name=$cat
		if [ -f $cat ] ; then
			/bin/cp $cat ${cat}.40 
			echo "Catalog "$cat" backed up to "$cat_40_name
			echo "Catalog "$cat" will be converted to 350 version."
		fi
	fi
	## Extract the reserved VSNs info from this catalog.
	${NEW_EXE}/dump_cat -V $cat | /bin/sed -n -e "s/^#R//p" >> ${RSV_VSNS}
}

#  main script.

echo "Copying files to the 3.5.0 directory structure if necessary..."

CONFLIST="mcf defaults.conf \
  archiver.cmd preview.cmd recycler.cmd releaser.cmd samfs.cmd"

if [ ! -d $OLD_ETC ]; then
	/bin/mkdir -p $OLD_ETC
	/bin/chmod 770 $OLD_ETC
fi
if [ ! -d $OLD_VAR ]; then
	/bin/mkdir -p $OLD_VAR
	/bin/chmod 770 $OLD_VAR
fi
if [ ! -d $OLD_CAT ]; then
	/bin/mkdir -p $OLD_CAT
	/bin/chmod 770 $OLD_CAT
fi

for object in $CONFLIST
do
	copy_conf $object $OLD_ETC $NEW_ETC
done

if [ -f ${RSV_VSNS} ] ; then
  /bin/mv ${RSV_VSNS} ${RSV_VSNS}.350
  /bin/touch ${RSV_VSNS}
fi

if [ -f $OLD_ETC/mcf ] ; then
	found_hist=0

	exec <$OLD_ETC/mcf
	while read eqid eqord eqtype famset state cat
	do
		case $eqid in
		\#*)
			continue
			;;
		esac

		if [ X = X$cat ]; then
			cat=$famset
		fi

		case $eqtype in
		rb|hp|ml|cy|dm|ds|me|ac|eb|ad|a1|a2|sl|s9|ic|pd|ae|as|a3|e8|hc|q8|sn|il)
			convert_cat
			;;
		fj|gr|im|sk|sc|pe)
			convert_cat
			## restore the network robot configuration file.
			nrconfig=`basename $eqid`
			copy_conf ${nrconfig} ${VAR_DIR} $OLD_VAR
			;;
		ss)
			## restore the remote configuration file.
			nrconfig=`basename $eqid`
			copy_conf ${nrconfig} ${VAR_DIR} $OLD_VAR
			;;
		hy)
			convert_cat
			found_hist=1
			;;
		default)
			;;
		esac
	done
	if [ $found_hist -eq 0 ] ; then
		if [ -f $CAT_DIR/historian ] ; then
			if [ -f $OLD_CAT/historian ] ; then
				/bin/mv $OLD_CAT/historian $OLD_CAT/historian.old350
			fi
			/bin/cp $CAT_DIR/historian $OLD_CAT/historian	
		fi
	fi
fi
echo "Conversion to the 3.5.0 directory structure complete."
