/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import jclass.bwt.JCTextAreaComponent;

class TextLine {
    JCTextAreaComponent comp;
    char[] text = new char[0];
    int row;
    int start_pos;
    int num_char;
    int width;

    TextLine(JCTextAreaComponent jCTextAreaComponent, int n, String string) {
        this.comp = jCTextAreaComponent;
        this.row = n;
        this.setText(string);
    }

    TextLine(JCTextAreaComponent jCTextAreaComponent, int n, char[] cArray, int n2, int n3) {
        this(jCTextAreaComponent, n, new String(cArray, n2, n3));
        this.start_pos = n2;
    }

    synchronized void setStartPos(int n) {
        this.start_pos = n;
    }

    void calcWidth() {
        this.width = this.comp.fm.charsWidth(this.text, 0, this.num_char);
    }

    synchronized void append(String string) {
        this.insert(string, this.num_char);
    }

    synchronized void deleteToEnd(int n) {
        this.delete(n, this.num_char);
    }

    synchronized void delete(int n, int n2) {
        if (n2 > n) {
            this.width -= this.comp.fm.charsWidth(this.text, n, n2 - n);
            System.arraycopy(this.text, n2, this.text, n, this.num_char - n2);
            this.num_char -= n2 - n;
        }
    }

    void insert(String string, int n) {
        int n2;
        int n3 = n2 = string != null ? string.length() : 0;
        if (n2 == 0) {
            return;
        }
        if (this.num_char + n2 + n >= this.text.length) {
            char[] cArray = new char[Math.max(this.num_char * 2, this.num_char + n + n2 + 1)];
            System.arraycopy(this.text, 0, cArray, 0, this.num_char);
            this.text = cArray;
        }
        if (this.num_char > n) {
            System.arraycopy(this.text, n, this.text, n + n2, this.num_char - n);
        }
        string.getChars(0, n2, this.text, n);
        this.num_char += n2;
        this.width += this.comp.fm.stringWidth(string);
    }

    synchronized void replace(String string, int n, int n2) {
        this.delete(n, n2);
        this.insert(string, n);
    }

    synchronized void setText(String string) {
        this.num_char = 0;
        this.insert(string, 0);
        this.calcWidth();
    }

    int getWidth() {
        return this.width;
    }

    int getWidth(int n) {
        int n2 = Math.max(0, Math.min(this.num_char, n - this.start_pos));
        return this.comp.fm.charsWidth(this.text, 0, n2);
    }

    int getWidthToEnd(int n) {
        int n2 = n - this.start_pos;
        return this.comp.fm.charsWidth(this.text, n2, Math.max(0, this.num_char - n2));
    }

    int xToPosition(int n) {
        int[] nArray = this.comp.fm.getWidths();
        Rectangle rectangle = this.comp.getDrawingArea();
        switch (this.comp.alignment) {
            case 1: {
                n -= rectangle.x + (rectangle.width - this.width) / 2;
                break;
            }
            case 2: {
                n -= rectangle.x + rectangle.width - this.width - this.comp.horiz_origin;
                break;
            }
            default: {
                n -= rectangle.x - this.comp.horiz_origin;
            }
        }
        int n2 = 0;
        while (n2 < this.num_char) {
            int n3 = nArray[this.text[n2]];
            if (n < n3 / 2) break;
            n -= n3;
            ++n2;
        }
        return n2 + this.start_pos;
    }

    synchronized void paint(Graphics graphics) {
        Rectangle rectangle = this.comp.getDrawingArea();
        rectangle.reshape(rectangle.x - this.comp.horiz_origin, rectangle.y + this.comp.getRowPosition(this.row) - this.comp.vert_origin, rectangle.width + this.comp.horiz_origin, this.comp.getRowHeight(this.row));
        if (!rectangle.intersects(this.comp.getPaintRect())) {
            return;
        }
        FontMetrics fontMetrics = this.comp.fm;
        int n = rectangle.height;
        int n2 = n - fontMetrics.getAscent();
        int n3 = rectangle.x;
        int n4 = rectangle.y + n - n2;
        int n5 = this.comp.select_start - this.start_pos;
        int n6 = this.comp.select_end - this.start_pos;
        switch (this.comp.alignment) {
            case 1: {
                n3 += (rectangle.width - this.width) / 2;
                break;
            }
            case 2: {
                n3 += rectangle.width - this.width;
            }
        }
        if (n5 != n6 && n5 < this.num_char && n6 >= 0) {
            n5 = Math.max(n5, 0);
            n6 = Math.min(n6, this.num_char);
            if (n5 > 0) {
                graphics.drawChars(this.text, 0, n5, n3, n4);
                n3 += fontMetrics.charsWidth(this.text, 0, n5);
            }
            int n7 = fontMetrics.charsWidth(this.text, n5, n6 - n5);
            Color color = graphics.getColor();
            this.comp.setSelectedBg(graphics);
            graphics.fillRect(n3, rectangle.y, n7, rectangle.height);
            this.comp.setSelectedFg(graphics);
            graphics.drawChars(this.text, n5, n6 - n5, n3, n4);
            n3 += n7;
            graphics.setColor(color);
            if (n6 < this.num_char) {
                graphics.drawChars(this.text, n6, this.num_char - n6, n3, n4);
                return;
            }
        } else {
            graphics.drawChars(this.text, 0, this.num_char, n3, n4);
        }
    }

    public String toString() {
        return "row=" + this.row + " start=" + this.start_pos + " num_char=" + this.num_char + " width=" + this.width + " text=" + new String(this.text, 0, this.num_char) + "|";
    }
}

