/*
 * Decompiled with CFR 0.152.
 */
package jclass.bwt;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import jclass.bwt.BWTUtil;
import jclass.bwt.JCComponent;
import jclass.bwt.ProgressMeterConverter;
import jclass.bwt.Shadow;

public class JCProgressMeter
extends JCComponent {
    public static final int STRING_LEFT = 0;
    public static final int STRING_RIGHT = 1;
    public static final int STRING_TOP = 2;
    public static final int STRING_BOTTOM = 3;
    public static final int STRING_CENTER = 4;
    int value;
    int min;
    int max = 100;
    Color bar_color = Color.red;
    int bar_count = 10;
    int bar_spacing = 2;
    int label_position = 1;
    String label;
    boolean auto_label = true;
    boolean show_label = true;
    int label_width_ext;
    int label_width;
    double chunk_width;
    long time0;
    private static final String base = "progressmeter";
    private static int nameCounter;
    protected int label_inset = 5;
    protected Rectangle bar_area = new Rectangle();
    protected Rectangle bar_rect = new Rectangle();
    protected int bar_height = 15;
    protected int bar_vert_inset = 3;
    protected int bar_horiz_inset = 2;
    protected int bar_shadow = 1;

    public JCProgressMeter() {
        this(null, null);
    }

    public JCProgressMeter(Applet applet, String string) {
        super(applet, string);
        if (string == null) {
            this.setName(base + nameCounter++);
        }
        this.traversable = false;
        this.highlight = 0;
        this.shadow = 0;
        this.insets = new Insets(5, 5, 5, 5);
        this.setAutoLabel(true);
        if (this.getClass().getName().equals("jclass.bwt.JCProgressMeter")) {
            this.getParameters(applet);
        }
        this.time0 = System.currentTimeMillis();
    }

    public JCProgressMeter(int n, int n2, int n3) {
        this();
        this.setValues(n, n2, n3);
    }

    protected void getParameters() {
        super.getParameters();
        ProgressMeterConverter.getParams(this);
    }

    public int getValue() {
        return this.value;
    }

    public int getValuePercentage() {
        if (this.max > this.min) {
            return 100 * (this.value - this.min) / (this.max - this.min);
        }
        return 0;
    }

    public synchronized void setValue(int n) {
        if (this.value != (n = Math.max(this.min, Math.min(n, this.max)))) {
            this.value = n;
            this.repaint();
            this.getToolkit().sync();
        }
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int n) {
        this.setValues(this.value, n, this.max);
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int n) {
        this.setValues(this.value, this.min, n);
    }

    public synchronized void setValues(int n, int n2, int n3) {
        this.min = n2;
        this.max = n3;
        this.setValue(n);
        this.time0 = System.currentTimeMillis();
    }

    public Color getBarColor() {
        return this.bar_color;
    }

    public synchronized void setBarColor(Color color) {
        this.bar_color = color;
        this.repaint();
    }

    public int getBarCount() {
        return this.bar_count;
    }

    public synchronized void setBarCount(int n) {
        this.bar_count = n;
        this.layout();
        this.repaint();
    }

    public int getBarSpacing() {
        return this.bar_spacing;
    }

    public synchronized void setBarSpacing(int n) {
        this.bar_spacing = n;
        this.layout();
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    public synchronized void setLabel(String string) {
        this.label = string;
        this.repaint();
    }

    public boolean getAutoLabel() {
        return this.auto_label;
    }

    public synchronized void setAutoLabel(boolean bl) {
        this.auto_label = bl;
        if (this.label_width_ext == 0) {
            this.label_width = bl ? 4 : 10;
        }
        this.repaint();
    }

    public boolean getShowLabel() {
        return this.show_label;
    }

    public synchronized void setShowLabel(boolean bl) {
        this.show_label = bl;
        this.repaint();
    }

    public int getLabelPosition() {
        return this.label_position;
    }

    public synchronized void setLabelPosition(int n) {
        ProgressMeterConverter.checkPosition(n);
        this.label_position = n;
        this.layout();
        this.repaint();
    }

    public int getLabelWidth() {
        return this.label_width_ext;
    }

    public synchronized void setLabelWidth(int n) {
        this.label_width_ext = this.label_width = n;
        this.layout();
        this.repaint();
    }

    public long getTimeElapsed() {
        return System.currentTimeMillis() - this.time0;
    }

    public long getTimeToCompletion() {
        if (this.value == this.min) {
            return Integer.MAX_VALUE;
        }
        long l = this.getTimeElapsed();
        return (long)((double)(this.max - this.min) / (double)(this.value - this.min) * (double)l - (double)l);
    }

    private final String str(int n) {
        if (n < 10) {
            return "0" + n;
        }
        return String.valueOf(n);
    }

    public String getTimeToCompletionString() {
        if (this.value == this.min) {
            return "?";
        }
        int n = (int)this.getTimeToCompletion();
        int n2 = (n /= 1000) / 3600;
        int n3 = (n -= n2 * 3600) / 60;
        return String.valueOf(this.str(n2)) + ":" + this.str(n3) + ":" + this.str(n -= n3 * 60);
    }

    protected int preferredWidth() {
        int n = 0;
        if (this.show_label && (this.label_position == 0 || this.label_position == 1)) {
            n = this.label_width * this.getToolkit().getFontMetrics(this.getFont()).charWidth('N');
        }
        return n + 200;
    }

    protected int preferredHeight() {
        int n = 0;
        if (this.show_label && (this.label_position == 2 || this.label_position == 3)) {
            n = this.getToolkit().getFontMetrics(this.getFont()).getHeight();
        }
        return n + this.bar_height + this.label_inset + 2 * this.bar_vert_inset + 2 * this.bar_shadow;
    }

    public void layout() {
        int n;
        if (this.getPeer() == null) {
            return;
        }
        this.needs_layout = false;
        this.bar_area = this.getDrawingArea();
        if (this.show_label) {
            if (this.label_position == 2 || this.label_position == 3) {
                n = this.getToolkit().getFontMetrics(this.getFont()).getHeight() + this.label_inset;
                if (this.label_position == 2) {
                    this.bar_area.y += n;
                }
                this.bar_area.height -= n;
            } else if (this.label_position == 0 || this.label_position == 1) {
                n = this.label_inset + this.label_width * this.getToolkit().getFontMetrics(this.getFont()).charWidth('N');
                if (this.label_position == 0) {
                    this.bar_area.x += n;
                }
                this.bar_area.width -= n;
            }
        }
        this.chunk_width = 0.0;
        if (this.bar_count > 0 && this.bar_spacing > 0) {
            n = this.bar_horiz_inset + this.bar_shadow;
            this.chunk_width = (double)(this.bar_area.width - 2 * n - (this.bar_count - 1) * this.bar_spacing) / (double)this.bar_count;
            if (this.chunk_width < 1.0) {
                this.chunk_width = 0.0;
            }
        }
    }

    protected void drawShadow(Graphics graphics) {
        Shadow.draw(graphics, 3, this.bar_shadow, this.bar_area.x, this.bar_area.y, this.bar_area.width, this.bar_area.height, this.getBackground(), this.getForeground());
    }

    protected void drawBar(Graphics graphics) {
        int n;
        int n2 = this.bar_horiz_inset + this.bar_shadow;
        int n3 = this.bar_vert_inset + this.bar_shadow;
        this.bar_rect.reshape(this.bar_area.x + n2, this.bar_area.y + n3, this.bar_area.width - 2 * n2, this.bar_area.height - 2 * n3);
        this.bar_rect.width = (int)((double)this.bar_rect.width * ((double)this.getValuePercentage() / 100.0));
        if (this.chunk_width == 0.0) {
            graphics.fillRect(this.bar_rect.x, this.bar_rect.y, this.bar_rect.width, this.bar_rect.height);
            return;
        }
        int n4 = 0;
        int n5 = 0;
        int n6 = this.bar_rect.x;
        int[] nArray = new int[this.bar_count];
        int[] nArray2 = new int[this.bar_count];
        int n7 = 0;
        while (n7 < this.bar_count) {
            nArray[n7] = n6;
            nArray2[n7] = (int)this.chunk_width;
            if (n7 == this.bar_count - 1) {
                n4 = this.bar_rect.width + this.bar_rect.x - n6 - (int)this.chunk_width;
            }
            if (nArray[n7] + nArray2[n7] - this.bar_rect.x <= this.bar_rect.width) {
                ++n5;
            }
            ++n7;
            n6 += (int)this.chunk_width + this.bar_spacing;
        }
        if (n4 > 0) {
            n = 0;
            while (n < n5) {
                if (n < n4) {
                    int n8 = n;
                    nArray[n8] = nArray[n8] + n;
                    int n9 = n;
                    nArray2[n9] = nArray2[n9] + 1;
                } else {
                    int n10 = n;
                    nArray[n10] = nArray[n10] + n4;
                }
                ++n;
            }
        }
        n = 0;
        while (n < n5) {
            graphics.fillRect(nArray[n], this.bar_rect.y, nArray2[n], this.bar_rect.height);
            ++n;
        }
    }

    protected void drawLabel(Graphics graphics, String string) {
        Rectangle rectangle = this.getDrawingArea();
        int n = 4;
        switch (this.label_position) {
            case 0: {
                n = 5;
                rectangle.width = this.bar_area.x - this.label_inset - rectangle.x;
                break;
            }
            case 1: {
                n = 3;
                rectangle.x = this.bar_area.x + this.bar_area.width + this.label_inset;
                break;
            }
            case 2: {
                n = 7;
                rectangle.height = this.bar_area.y - this.label_inset - rectangle.y;
                break;
            }
            case 3: {
                n = 1;
                rectangle.y = this.bar_area.y + this.bar_area.height + this.label_inset;
                break;
            }
        }
        BWTUtil.draw(this, graphics, string, n, rectangle);
        if (this.label_position != 4) {
            return;
        }
        graphics = graphics.create();
        graphics.clipRect(this.bar_rect.x, this.bar_area.y, this.bar_rect.width, this.bar_area.height);
        graphics.setColor(this.getBackground());
        BWTUtil.draw(this, graphics, string, n, rectangle);
    }

    protected void paintComponent(Graphics graphics) {
        if (this.needs_layout) {
            this.layout();
        }
        this.drawShadow(graphics);
        graphics.setColor(this.bar_color);
        this.drawBar(graphics);
        if (this.show_label) {
            String string = this.label;
            if (string == null && this.auto_label) {
                string = this.getValuePercentage() + "%";
            }
            graphics.setColor(this.getForeground());
            this.drawLabel(graphics, string);
        }
    }
}

