/*
 * Decompiled with CFR 0.152.
 */
package sam.model.robot;

import sam.model.CatalogEntry;
import sam.model.Ea;
import sam.model.SamManager;
import sam.model.TableEntry;
import sam.model.robot.SCSIRobot;

public class ATL452Robot
extends SCSIRobot {
    private boolean doorOpen;

    public boolean hasMailbox() {
        return true;
    }

    public int mailboxCount() {
        int n = 0;
        try {
            TableEntry[] tableEntryArray = this.getCatalog().getEntries();
            int n2 = 0;
            while (n2 < tableEntryArray.length) {
                if (((CatalogEntry)tableEntryArray[n2]).isImportExport()) {
                    ++n;
                }
                ++n2;
            }
        }
        catch (NullPointerException nullPointerException) {}
        return n;
    }

    public boolean isDoorAccessable() {
        try {
            TableEntry[] tableEntryArray = this.getCatalog().getEntries();
            int n = 0;
            while (n < tableEntryArray.length) {
                CatalogEntry catalogEntry = (CatalogEntry)tableEntryArray[n];
                if (catalogEntry.isImportExport() && catalogEntry.isInUse() && !catalogEntry.isOccupied()) {
                    return false;
                }
                ++n;
            }
        }
        catch (NullPointerException nullPointerException) {}
        return true;
    }

    public boolean isDoorOpen() {
        return this.doorOpen;
    }

    public void closeDoor() {
        if (SamManager.dataSource.importMedia(this, false) == 0) {
            this.doorOpen = false;
        }
    }

    public void openDoor() {
        Ea ea = new Ea(0, 0, false);
        if (SamManager.dataSource.exportSlot(this, ea) == 0) {
            this.doorOpen = true;
        }
    }

    public void export(Ea ea) {
        if (this.doorOpen) {
            return;
        }
        this.moveToExport(ea);
    }

    public void importMedia() {
        if (this.doorOpen) {
            return;
        }
        this.moveFromImport();
    }

    public void moveFromImport() {
        int n = 0;
        try {
            TableEntry[] tableEntryArray = this.getCatalog().getEntries();
            int n2 = 0;
            while (n2 < tableEntryArray.length) {
                if (((CatalogEntry)tableEntryArray[n2]).isImportExport() && ((CatalogEntry)tableEntryArray[n2]).isInUse()) {
                    int n3 = n;
                    while (n3 < tableEntryArray[n2].getSlotNumber()) {
                        CatalogEntry catalogEntry = (CatalogEntry)this.getCatalog().getEntry(n3);
                        if (catalogEntry == null) {
                            this.moveSlot(((CatalogEntry)tableEntryArray[n2]).getEa(), catalogEntry.getEa());
                            n = ++n3;
                            break;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }

    public void moveToExport(Ea ea) {
        try {
            TableEntry[] tableEntryArray = this.getCatalog().getEntries();
            int n = 0;
            while (n < tableEntryArray.length) {
                if (((CatalogEntry)tableEntryArray[n]).isImportExport() && !((CatalogEntry)tableEntryArray[n]).isInUse()) {
                    this.moveSlot(ea, ((CatalogEntry)tableEntryArray[n]).getEa());
                    return;
                }
                ++n;
            }
            return;
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }

    public ATL452Robot(String string, String string2, int n, int n2, int n3, int n4, int n5, String string3, String string4) {
        super(string, string2, n, n2, n3, n4, n5, string3, string4);
    }
}

