/*
 * Decompiled with CFR 0.152.
 */
package sam.gui;

import java.awt.Color;
import java.awt.Graphics;
import java.util.Observable;
import sam.gui.ObjectIcon;
import sam.model.SamDevice;
import sam.resource.ResourceManager;

public class DeviceIcon
extends ObjectIcon {
    private SamDevice device;

    public static String getIconResource(SamDevice samDevice) {
        String string = ResourceManager.getDeviceIcon(samDevice.getEqId());
        if (string == null) {
            string = ResourceManager.getDeviceTypeIcon(samDevice.getTypeString());
        }
        return string;
    }

    public void paint(Graphics graphics) {
        if (this.device.needsOperatorAttention()) {
            this.drawAttention(graphics);
        }
        super.paint(graphics);
        switch (this.device.getState()) {
            case 4: {
                this.drawOff(graphics);
                return;
            }
            case 5: {
                this.drawDown(graphics);
                return;
            }
            case 3: {
                this.drawUnavailable(graphics);
                return;
            }
        }
    }

    public int getPaintedAttributes() {
        int n = super.getPaintedAttributes();
        n <<= 1;
        if (this.device.getState() == 4) {
            ++n;
        }
        n <<= 1;
        if (this.device.getState() == 5) {
            ++n;
        }
        n <<= 1;
        if (this.device.getState() == 3) {
            ++n;
        }
        n <<= 1;
        if (this.device.needsOperatorAttention()) {
            ++n;
        }
        return n;
    }

    public synchronized void drawAttention(Graphics graphics) {
        this.startFlash();
        if (this.flash) {
            graphics.setColor(Color.red);
            graphics.fillRect(0, 0, this.size.width, this.size.height);
        }
    }

    public void drawOff(Graphics graphics) {
        graphics.setXORMode(this.getBackground());
        this.drawImage(graphics);
        graphics.setPaintMode();
    }

    public void drawDown(Graphics graphics) {
        graphics.setXORMode(Color.black);
        this.drawImage(graphics);
        graphics.setPaintMode();
    }

    public void drawUnavailable(Graphics graphics) {
        graphics.setXORMode(Color.gray);
        this.drawImage(graphics);
        graphics.setPaintMode();
    }

    public void update(Observable observable, Object object) {
        super.update(observable, object);
        if (!this.device.needsOperatorAttention()) {
            this.stopFlash();
        }
    }

    DeviceIcon(SamDevice samDevice) {
        super(DeviceIcon.getIconResource(samDevice));
        this.device = samDevice;
        samDevice.addObserver(this);
    }
}

