/*
 * Decompiled with CFR 0.152.
 */
package org.apache.java.lang;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.java.io.SimpleFileFilter;

public class AdaptiveClassLoader
extends ClassLoader {
    private static int generationCounter = 0;
    private int generation;
    private Hashtable cache;
    private ClassLoader myParentClassLoader;
    private Vector repository;

    public AdaptiveClassLoader(Vector vector) throws IllegalArgumentException {
        this(vector, null);
    }

    public AdaptiveClassLoader(Vector vector, ClassLoader classLoader) throws IllegalArgumentException {
        this.myParentClassLoader = classLoader;
        this.cache = new Hashtable();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            File file;
            Object e = enumeration.nextElement();
            try {
                file = (File)e;
            }
            catch (ClassCastException classCastException) {
                throw new IllegalArgumentException("Object " + e + "is not a valid \"File\" instance");
            }
            File[] fileArray = SimpleFileFilter.fileOrFiles(file);
            if (fileArray == null) continue;
            int n = 0;
            while (n < fileArray.length) {
                file = fileArray[n];
                if (!file.exists()) {
                    throw new IllegalArgumentException("Repository " + file.getAbsolutePath() + " doesn't exist!");
                }
                if (!file.canRead()) {
                    throw new IllegalArgumentException("Do not have read access for file " + file.getAbsolutePath());
                }
                if (!file.isDirectory() && !this.isZipOrJarArchive(file)) {
                    throw new IllegalArgumentException(file.getAbsolutePath() + " is not a directory or zip/jar file" + " or if it's a zip/jar file then it is corrupted.");
                }
                ++n;
            }
        }
        this.repository = vector;
        this.generation = generationCounter++;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isZipOrJarArchive(File file) {
        boolean bl = true;
        ZipFile zipFile = null;
        zipFile = new ZipFile(file);
        Object var7_4 = null;
        if (zipFile == null) return bl;
        try {
            zipFile.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
        {
            catch (ZipException zipException) {
                bl = false;
                Object var7_5 = null;
                if (zipFile == null) return bl;
                try {
                    zipFile.close();
                    return bl;
                }
                catch (IOException iOException) {}
                return bl;
            }
            catch (IOException iOException) {
                bl = false;
                Object var7_6 = null;
                if (zipFile == null) return bl;
                try {
                    zipFile.close();
                    return bl;
                }
                catch (IOException iOException2) {}
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (zipFile == null) throw throwable;
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public synchronized boolean shouldReload(String string) {
        ClassCacheEntry classCacheEntry = (ClassCacheEntry)this.cache.get(string);
        if (classCacheEntry == null) {
            return false;
        }
        if (classCacheEntry.isSystemClass()) {
            return false;
        }
        boolean bl = classCacheEntry.origin.lastModified() != classCacheEntry.lastModified;
        return bl;
    }

    public synchronized boolean shouldReload() {
        Enumeration enumeration = this.cache.elements();
        while (enumeration.hasMoreElements()) {
            ClassCacheEntry classCacheEntry = (ClassCacheEntry)enumeration.nextElement();
            if (classCacheEntry.isSystemClass()) continue;
            long l = classCacheEntry.origin.lastModified();
            if (l == 0L) {
                return true;
            }
            if (l == classCacheEntry.lastModified) continue;
            return true;
        }
        return false;
    }

    public AdaptiveClassLoader reinstantiate() {
        return new AdaptiveClassLoader(this.repository, this.myParentClassLoader);
    }

    protected synchronized Class loadClass(String string, boolean bl) throws ClassNotFoundException {
        Class<?> clazz = null;
        ClassCacheEntry classCacheEntry = (ClassCacheEntry)this.cache.get(string);
        if (classCacheEntry != null) {
            clazz = classCacheEntry.loadedClass;
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        if (!this.securityAllowsClass(string)) {
            return this.loadSystemClass(string, bl);
        }
        try {
            clazz = this.loadSystemClass(string, bl);
            if (clazz != null) {
                if (bl) {
                    this.resolveClass(clazz);
                }
                return clazz;
            }
        }
        catch (Exception exception) {
            clazz = null;
        }
        Enumeration enumeration = this.repository.elements();
        ClassCacheEntry classCacheEntry2 = new ClassCacheEntry();
        while (enumeration.hasMoreElements()) {
            byte[] byArray = null;
            File file = (File)enumeration.nextElement();
            File[] fileArray = SimpleFileFilter.fileOrFiles(file);
            int n = 0;
            while (n < fileArray.length) {
                file = fileArray[n];
                try {
                    byArray = file.isDirectory() ? this.loadClassFromDirectory(file, string, classCacheEntry2) : this.loadClassFromZipfile(file, string, classCacheEntry2);
                }
                catch (IOException iOException) {
                    byArray = null;
                }
                ++n;
            }
            if (byArray == null) continue;
            classCacheEntry2.loadedClass = clazz = this.defineClass(string, byArray, 0, byArray.length);
            classCacheEntry2.lastModified = classCacheEntry2.origin.lastModified();
            this.cache.put(string, classCacheEntry2);
            if (bl) {
                this.resolveClass(clazz);
            }
            return clazz;
        }
        throw new ClassNotFoundException(string);
    }

    private Class loadSystemClass(String string, boolean bl) throws NoClassDefFoundError, ClassNotFoundException {
        if (this.myParentClassLoader != null) {
            return this.myParentClassLoader.loadClass(string);
        }
        Class<?> clazz = this.findSystemClass(string);
        ClassCacheEntry classCacheEntry = new ClassCacheEntry();
        classCacheEntry.origin = null;
        classCacheEntry.loadedClass = clazz;
        classCacheEntry.lastModified = Long.MAX_VALUE;
        this.cache.put(string, classCacheEntry);
        if (bl) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    private boolean securityAllowsClass(String string) {
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager == null) {
                return true;
            }
            int n = string.lastIndexOf(46);
            securityManager.checkPackageDefinition(n > -1 ? string.substring(0, n) : "");
            return true;
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassFromDirectory(File file, String string, ClassCacheEntry classCacheEntry) throws IOException {
        File file2;
        String string2 = string.replace('.', File.separatorChar) + ".class";
        if (!Character.isJavaIdentifierStart(string2.charAt(0))) {
            int n = 1;
            while (!Character.isJavaIdentifierStart(string2.charAt(n++))) {
            }
            string2 = string2.substring(n);
        }
        if ((file2 = new File(file, string2)).exists()) {
            byte[] byArray;
            classCacheEntry.origin = file2;
            FileInputStream fileInputStream = new FileInputStream(file2);
            try {
                byArray = this.loadBytesFromStream(fileInputStream, (int)file2.length());
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                ((InputStream)fileInputStream).close();
                throw throwable;
            }
            ((InputStream)fileInputStream).close();
            return byArray;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassFromZipfile(File file, String string, ClassCacheEntry classCacheEntry) throws IOException {
        ZipFile zipFile;
        block3: {
            byte[] byArray;
            String string2 = string.replace('.', '/') + ".class";
            zipFile = new ZipFile(file);
            try {
                ZipEntry zipEntry = zipFile.getEntry(string2);
                if (zipEntry == null) break block3;
                classCacheEntry.origin = file;
                byArray = this.loadBytesFromStream(zipFile.getInputStream(zipEntry), (int)zipEntry.getSize());
                Object var9_9 = null;
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                zipFile.close();
                throw throwable;
            }
            zipFile.close();
            return byArray;
        }
        byte[] byArray = null;
        Object var9_10 = null;
        zipFile.close();
        return byArray;
    }

    private byte[] loadBytesFromStream(InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        while (n > 0 && (n2 = inputStream.read(byArray, n3, n)) != -1) {
            n3 += n2;
            n -= n2;
        }
        return byArray;
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream = null;
        if (this.myParentClassLoader != null) {
            inputStream = this.myParentClassLoader.getResourceAsStream(string);
        }
        if (inputStream == null) {
            inputStream = ClassLoader.getSystemResourceAsStream(string);
        }
        if (inputStream == null) {
            Enumeration enumeration = this.repository.elements();
            while (enumeration.hasMoreElements()) {
                File file = (File)enumeration.nextElement();
                if (file.isDirectory()) {
                    inputStream = this.loadResourceFromDirectory(file, string);
                } else if (string.endsWith(".initArgs")) {
                    String string2 = file.getParent();
                    if (string2 != null) {
                        File file2 = new File(string2);
                        inputStream = this.loadResourceFromDirectory(file2, string);
                    }
                } else {
                    inputStream = this.loadResourceFromZipfile(file, string);
                }
                if (inputStream != null) break;
            }
        }
        return inputStream;
    }

    private InputStream loadResourceFromDirectory(File file, String string) {
        String string2 = string.replace('/', File.separatorChar);
        File file2 = new File(file, string2);
        if (file2.exists()) {
            try {
                return new FileInputStream(file2);
            }
            catch (FileNotFoundException fileNotFoundException) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private InputStream loadResourceFromZipfile(File var1_1, String var2_2) {
        block23: {
            block20: {
                block18: {
                    block19: {
                        var3_3 = null;
                        var4_4 = null;
                        try {
                            try {
                                var3_3 = new ZipFile(var1_1);
                                var5_5 = var3_3.getEntry(var2_2);
                                if (var5_5 != null) {
                                    var6_7 = var5_5.getSize();
                                    var4_4 = var3_3.getInputStream(var5_5);
                                    var8_10 = this.loadBytesFromStream(var4_4, (int)var6_7);
                                    var9_11 = new ByteArrayInputStream(var8_10);
                                    var11_12 = null;
                                    if (var4_4 == null) break block18;
                                    break block19;
                                }
                                var6_8 = null;
                                break block20;
                            }
                            catch (IOException var5_6) {
                                var6_9 = null;
                                var11_14 = null;
                                if (var4_4 != null) {
                                    try {
                                        var4_4.close();
                                    }
                                    catch (IOException var12_18) {
                                        // empty catch block
                                    }
                                }
                                if (var3_3 == null) return var6_9;
                                try {
                                    var3_3.close();
                                    return var6_9;
                                }
                                catch (IOException var12_18) {
                                    // empty catch block
                                }
                                return var6_9;
                            }
                        }
                        catch (Throwable var10_20) {
                            block22: {
                                var11_15 = null;
                                if (var4_4 != null) {
                                    ** try [egrp 2[TRYBLOCK] [5 : 104->112)] { 
lbl42:
                                    // 1 sources

                                    var4_4.close();
                                    break block22;
lbl44:
                                    // 1 sources

                                    catch (IOException var12_19) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (var3_3 == null) throw var10_20;
                            try {}
                            catch (IOException var12_19) {
                                throw var10_20;
                            }
                            var3_3.close();
                            throw var10_20;
                        }
                    }
                    ** try [egrp 2[TRYBLOCK] [5 : 104->112)] { 
lbl55:
                    // 1 sources

                    var4_4.close();
                    break block18;
lbl57:
                    // 1 sources

                    catch (IOException var12_16) {
                        // empty catch block
                    }
                }
                if (var3_3 == null) return var9_11;
                ** try [egrp 3[TRYBLOCK] [6 : 118->125)] { 
lbl62:
                // 1 sources

                var3_3.close();
                return var9_11;
lbl64:
                // 1 sources

                catch (IOException var12_16) {
                    // empty catch block
                }
                return var9_11;
            }
            var11_13 = null;
            if (var4_4 != null) {
                ** try [egrp 2[TRYBLOCK] [5 : 104->112)] { 
lbl71:
                // 1 sources

                var4_4.close();
                break block23;
lbl73:
                // 1 sources

                catch (IOException var12_17) {
                    // empty catch block
                }
            }
        }
        if (var3_3 == null) return var6_8;
        ** try [egrp 3[TRYBLOCK] [6 : 118->125)] { 
lbl78:
        // 1 sources

        var3_3.close();
        return var6_8;
lbl80:
        // 1 sources

        catch (IOException var12_17) {
            // empty catch block
        }
        return var6_8;
    }

    public URL getResource(String string) {
        if (string == null) {
            return null;
        }
        URL uRL = null;
        if (this.myParentClassLoader != null) {
            uRL = this.myParentClassLoader.getResource(string);
        }
        if (uRL == null) {
            uRL = ClassLoader.getSystemResource(string);
        }
        if (uRL != null) {
            return uRL;
        }
        Enumeration enumeration = this.repository.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            Object object2;
            File file = (File)enumeration.nextElement();
            if (file.isDirectory()) {
                object2 = string.replace('/', File.separatorChar);
                object = new File(file, (String)object2);
                if (!((File)object).exists()) continue;
                try {
                    return new URL("file", null, ((File)object).getAbsolutePath());
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    return null;
                }
            }
            try {
                object2 = new ZipFile(file.getAbsolutePath());
                object = ((ZipFile)object2).getEntry(string);
                if (object == null) continue;
                try {
                    return new URL("jar:file:" + file.getAbsolutePath() + "!/" + string);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                    return null;
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return null;
            }
        }
        return null;
    }

    public long lastModified(String string) throws ClassNotFoundException {
        ClassCacheEntry classCacheEntry = (ClassCacheEntry)this.cache.get(string);
        if (classCacheEntry == null) {
            throw new ClassNotFoundException("Could not find class: " + string);
        }
        return classCacheEntry.lastModified;
    }

    private static class ClassCacheEntry {
        Class loadedClass;
        File origin;
        long lastModified;

        private ClassCacheEntry() {
        }

        public boolean isSystemClass() {
            return this.origin == null;
        }
    }
}

