/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.discovery.console.presentation;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.SMRequestStatus;
import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.topology.SMUserDomainData;
import com.sun.symon.base.client.topology.SMUserDomainRequest;
import com.sun.symon.base.console.discovery.SMDiscoveryData;
import com.sun.symon.base.console.discovery.SMDiscoveryRequest;
import com.sun.symon.base.console.discovery.SMDiscoveryRequestStatus;
import com.sun.symon.base.console.discovery.SMDiscoveryResponse;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.utility.UcURL;
import com.sun.symon.tools.discovery.console.presentation.DiscoverConfirmDialog;
import com.sun.symon.tools.discovery.console.presentation.DiscoverConstants;
import com.sun.symon.tools.discovery.console.presentation.DiscoverErrorDialog;
import com.sun.symon.tools.discovery.console.presentation.DiscoverGUIException;
import com.sun.symon.tools.discovery.console.presentation.DiscoverRequest;
import com.sun.symon.tools.discovery.console.presentation.RequestEditDialog;
import com.sun.symon.tools.discovery.console.presentation.RequestTable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class DiscoverPanel
extends JPanel
implements ActionListener,
SMDiscoveryResponse,
AncestorListener {
    static final String defaultDomainKey = "base.console.ConsoleTopology:domain.defaultdomain";
    static final String homeDomainKey = "base.console.ConsoleTopology:domain.mngr.defaultdomain";
    private SMRawDataRequest reqHandle;
    private SMDiscoveryRequest discoverRequestHandle;
    private Vector requestList = new Vector();
    private Vector statusBuffer = null;
    private boolean statGetRequestData = false;
    private static String topologyAgentIpAddress;
    private String domain = "";
    private String domainL10N = "";
    private String domainUrl = "";
    static final String NO_ACCESS = "error status 6";
    private Font tableLabelFont = null;
    private Font titleFont = null;
    private Color tableLabelBackground = Color.white;
    private Color tableLabelForeground = Color.black;
    private Color titleBackground = this.getDefaultBackground();
    private Color titleForeground = this.getDefaultForeground();
    private JLabel errorLabel;
    private JPanel requestPanel;
    private JPanel detailPanel;
    private JTextArea detailTextArea;
    private JScrollPane textAreaScrollPane;
    private JLabel detailLabel;
    private JButton requestAddButton;
    private JButton requestModifyButton;
    private JButton requestDuplicateButton;
    private JButton requestDeleteButton;
    private JButton requestStartButton;
    private JButton requestStopButton;
    private JButton requestLogButton;
    JLabel domainNameDataLabel;
    private RequestTable dTable = null;
    private JFrame parentFrame = null;
    JTextField DomainTextArea = null;
    DiscoverConfirmDialog confirmDialog = null;
    DiscoverConfirmDialog logDialog = null;
    RequestEditDialog requestDialog = null;

    public DiscoverPanel() {
        this.setPreferredSize(new Dimension(600, 580));
    }

    public Color getDefaultBackground() {
        return this.getBackground();
    }

    public Color getDefaultForeground() {
        return this.getForeground();
    }

    public static String getTopologyAgentIpAddress() {
        return topologyAgentIpAddress;
    }

    public JFrame getParentFrame() {
        return this.parentFrame;
    }

    public String getDomain() {
        return this.domain;
    }

    public SMDiscoveryRequest getSMDiscoveryRequestHandle() {
        return this.discoverRequestHandle;
    }

    public void setDomain(String string) {
        this.domain = UcInternationalizer.translateKey((String)string);
    }

    public void setDomainUrl(String string) {
        this.domainUrl = string;
    }

    public void setRequestHandle(SMRawDataRequest sMRawDataRequest) {
        this.reqHandle = sMRawDataRequest;
    }

    protected SMRawDataRequest getRequestHandle() {
        return this.reqHandle;
    }

    public void setTitleBackground(Color color) {
        this.titleBackground = color;
    }

    public void setTitleForeground(Color color) {
        this.titleForeground = color;
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
    }

    public void setTableLabelBackground(Color color) {
        this.tableLabelBackground = color;
    }

    public void setTableLabelForeground(Color color) {
        this.tableLabelForeground = color;
    }

    public void setTableLabelFont(Font font) {
        this.tableLabelFont = font;
    }

    public String getTopologyHostIpAddress(SMRawDataRequest sMRawDataRequest) throws DiscoverGUIException {
        String string = null;
        UcURL ucURL = null;
        ucURL = new UcURL(this.domainUrl);
        String string2 = ucURL.getHost();
        try {
            InetAddress inetAddress = InetAddress.getByName(string2);
            string = inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            throw new DiscoverGUIException("UnknownHostException" + string2);
        }
        return string;
    }

    public void init() {
        Container container = this;
        while (container != null) {
            if (container.getParent() instanceof JFrame && container.getParent().isVisible()) {
                this.parentFrame = (JFrame)container.getParent();
                break;
            }
            container = container.getParent();
        }
        this.getDomainNamefromUrl();
        try {
            topologyAgentIpAddress = this.getTopologyHostIpAddress(this.reqHandle);
        }
        catch (DiscoverGUIException discoverGUIException) {
            discoverGUIException.print();
        }
        this.getRequestData();
        this.setLayout(new GridLayout(1, 0));
        this.requestPanel = this.buildRequestPanel();
        this.add(this.requestPanel);
        this.addAncestorListener(this);
    }

    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        if (this.logDialog != null) {
            this.logDialog.hide();
            this.logDialog = null;
        }
    }

    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    public void ancestorAdded(AncestorEvent ancestorEvent) {
    }

    void getDomainNamefromUrl() {
        block6: {
            if (this.domainUrl.equals("")) {
                this.domain = "";
                return;
            }
            try {
                SMUserDomainData[] sMUserDomainDataArray = this.loadDomains();
                if (this.domainUrl.endsWith("/")) {
                    this.domainUrl = this.domainUrl.substring(0, this.domainUrl.length() - 1);
                }
                if (sMUserDomainDataArray == null) break block6;
                int n = 0;
                while (n < sMUserDomainDataArray.length) {
                    if (this.domainUrl.equals(sMUserDomainDataArray[n].getDomainRootUrl())) {
                        String string = sMUserDomainDataArray[n].getDomainName();
                        this.domainL10N = UcInternationalizer.translateKey((String)string);
                        this.domain = string.compareTo(defaultDomainKey) == 0 ? "Default Domain" : (string.compareTo(homeDomainKey) == 0 ? "Home Domain" : UcInternationalizer.translateKey((String)string));
                        break;
                    }
                    ++n;
                }
            }
            catch (DiscoverGUIException discoverGUIException) {
                discoverGUIException.print();
            }
        }
    }

    private SMUserDomainData[] loadDomains() throws DiscoverGUIException {
        SMUserDomainRequest sMUserDomainRequest = new SMUserDomainRequest(this.reqHandle);
        if (sMUserDomainRequest == null) {
            return null;
        }
        SMUserDomainData[] sMUserDomainDataArray = null;
        try {
            sMUserDomainDataArray = sMUserDomainRequest.getAllConfiguredDomains();
        }
        catch (SMAPIException sMAPIException) {
            throw new DiscoverGUIException("Domain entries retrieval exception");
        }
        return sMUserDomainDataArray;
    }

    private JPanel buildRequestPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(10, 10));
        Border border = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        jPanel.setBorder(border);
        JPanel jPanel2 = new JPanel();
        JLabel jLabel = new JLabel(this.getI18NString("Domain_colon_"));
        jLabel.setFont(this.titleFont);
        jLabel.setForeground(this.titleForeground);
        this.domainNameDataLabel = new JLabel(this.domainL10N);
        this.domainNameDataLabel.setFont(this.titleFont);
        this.domainNameDataLabel.setForeground(this.titleForeground);
        jPanel2.setLayout(new BorderLayout(10, 10));
        jPanel2.add("West", jLabel);
        jPanel2.add("Center", this.domainNameDataLabel);
        JScrollPane jScrollPane = null;
        try {
            this.dTable = new RequestTable(this, DiscoverConstants.requestAttributes, DiscoverConstants.columnVisible);
            this.dTable.setRequestList(this.requestList);
            this.dTable.setLabelForeground(this.tableLabelForeground);
            this.dTable.setLabelBackground(this.tableLabelBackground);
            this.dTable.init();
            jScrollPane = new JScrollPane(this.dTable);
            jScrollPane.setPreferredSize(new Dimension(400, 200));
        }
        catch (DiscoverGUIException discoverGUIException) {
            discoverGUIException.print();
        }
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(7, 1, 0, 10));
        this.requestAddButton = new JButton(this.getI18NString("AddB"));
        this.requestModifyButton = new JButton(this.getI18NString("Modify"));
        this.requestDuplicateButton = new JButton(this.getI18NString("Duplicate"));
        this.requestDeleteButton = new JButton(this.getI18NString("Delete"));
        this.requestStartButton = new JButton(this.getI18NString("Start"));
        this.requestStopButton = new JButton(this.getI18NString("Stop"));
        this.requestLogButton = new JButton(this.getI18NString("Log"));
        this.requestAddButton.setMnemonic(this.getI18NString("AddB.mnemonic").charAt(0));
        this.requestModifyButton.setMnemonic(this.getI18NString("Modify.mnemonic").charAt(0));
        this.requestDuplicateButton.setMnemonic(this.getI18NString("Duplicate.mnemonic").charAt(0));
        this.requestDeleteButton.setMnemonic(this.getI18NString("Delete.mnemonic").charAt(0));
        this.requestStartButton.setMnemonic(this.getI18NString("Start.mnemonic").charAt(0));
        this.requestStopButton.setMnemonic(this.getI18NString("Stop.mnemonic").charAt(0));
        this.requestLogButton.setMnemonic(this.getI18NString("Log.mnemonic").charAt(0));
        this.requestAddButton.addActionListener(this);
        this.requestModifyButton.addActionListener(this);
        this.requestDuplicateButton.addActionListener(this);
        this.requestDeleteButton.addActionListener(this);
        this.requestStartButton.addActionListener(this);
        this.requestStopButton.addActionListener(this);
        this.requestLogButton.addActionListener(this);
        if (this.domain.equals("")) {
            this.requestAddButton.setEnabled(false);
        }
        this.requestModifyButton.setEnabled(false);
        this.requestDuplicateButton.setEnabled(false);
        this.requestDeleteButton.setEnabled(false);
        this.requestStartButton.setEnabled(false);
        this.requestStopButton.setEnabled(false);
        this.requestLogButton.setEnabled(false);
        jPanel3.add(this.requestAddButton);
        jPanel3.add(this.requestModifyButton);
        jPanel3.add(this.requestDuplicateButton);
        jPanel3.add(this.requestDeleteButton);
        jPanel3.add(this.requestStartButton);
        jPanel3.add(this.requestStopButton);
        jPanel3.add(this.requestLogButton);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(10, 10));
        jPanel5.add("North", jPanel2);
        jPanel5.add("Center", jScrollPane);
        jPanel5.add("East", jPanel4);
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(10, 10));
        this.detailLabel = new JLabel(this.getI18NString("Request_Details"));
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout(10, 10));
        jPanel7.add("West", this.detailLabel);
        this.detailTextArea = new JTextArea();
        this.detailTextArea.setEditable(false);
        this.detailTextArea.append(this.getI18NString("3newlines"));
        this.textAreaScrollPane = new JScrollPane(this.detailTextArea);
        jPanel6.add("North", jPanel7);
        jPanel6.add("Center", this.textAreaScrollPane);
        jPanel.add("North", jPanel5);
        jPanel.add("Center", jPanel6);
        return jPanel;
    }

    private void getRequestData() {
        this.discoverRequestHandle = new SMDiscoveryRequest(this.reqHandle);
        try {
            try {
                this.discoverRequestHandle.getRequest(null, "120", this, null);
                this.discoverRequestHandle.getRequestStatus(null, "120", this, null);
            }
            catch (SMAPIException sMAPIException) {
                throw new DiscoverGUIException("Exception :SMAPI Exception in getting request list instances");
            }
        }
        catch (DiscoverGUIException discoverGUIException) {
            discoverGUIException.print();
            if (this.errorLabel == null) {
                this.errorLabel = new JLabel(this.getI18NString("Discovery_Requests_Data_is_not_available"));
                this.add(this.errorLabel);
            }
            this.errorLabel.setVisible(true);
        }
    }

    public void informRowSelected(int n) {
        if (this.requestModifyButton == null) {
            return;
        }
        if (n >= 0 && n < this.requestList.size()) {
            String string = ((DiscoverRequest)this.requestList.elementAt(n)).getRequestStatus();
            if (string.equals("Running")) {
                this.requestModifyButton.setEnabled(false);
                this.requestDeleteButton.setEnabled(false);
                this.requestStartButton.setEnabled(false);
                this.requestStopButton.setEnabled(true);
            } else {
                this.requestModifyButton.setEnabled(true);
                this.requestDeleteButton.setEnabled(true);
                if (string.equals("Queued") || string.equals("Scheduled")) {
                    this.requestStartButton.setEnabled(false);
                } else {
                    this.requestStartButton.setEnabled(true);
                }
                this.requestStopButton.setEnabled(false);
            }
            this.requestDuplicateButton.setEnabled(true);
            this.requestLogButton.setEnabled(true);
        } else {
            this.requestModifyButton.setEnabled(false);
            this.requestDeleteButton.setEnabled(false);
            this.requestStartButton.setEnabled(false);
            this.requestStopButton.setEnabled(false);
            this.requestDuplicateButton.setEnabled(false);
            this.requestLogButton.setEnabled(false);
        }
        this.showDetails();
    }

    private void showDetails() {
        if (this.detailTextArea == null) {
            return;
        }
        int n = this.dTable.getSelectedRow();
        this.detailTextArea.setText("");
        if (n < 0 || n > this.requestList.size() - 1) {
            return;
        }
        String string = ((DiscoverRequest)this.requestList.elementAt(n)).getDiscoverTopologyMethod();
        boolean bl = ((DiscoverRequest)this.requestList.elementAt(n)).getMonitoring();
        String string2 = ((DiscoverRequest)this.requestList.elementAt(n)).getRepeatInterval();
        int n2 = 0;
        while (n2 < DiscoverConstants.requestAttributes.length) {
            block8: {
                String string3;
                String string4;
                block10: {
                    block11: {
                        block9: {
                            if (DiscoverConstants.columnVisible[n2] || (!string.equals("ping") ? DiscoverConstants.requestAttributes[n2].equals("EndIPAddress") || DiscoverConstants.requestAttributes[n2].equals("Netmask") : DiscoverConstants.requestAttributes[n2].equals("NumberOfHops"))) break block8;
                            if (bl) break block9;
                            if (!DiscoverConstants.requestAttributes[n2].equals("Frequency") && !DiscoverConstants.requestAttributes[n2].equals("DayOfWeek") && !DiscoverConstants.requestAttributes[n2].equals("DayOfMonth") && !DiscoverConstants.requestAttributes[n2].equals("Time")) break block10;
                            break block8;
                        }
                        if (!string2.equals("weekly")) break block11;
                        if (!DiscoverConstants.requestAttributes[n2].equals("DayOfMonth")) break block10;
                        break block8;
                    }
                    if (!string2.equals("monthly") ? DiscoverConstants.requestAttributes[n2].equals("DayOfWeek") || DiscoverConstants.requestAttributes[n2].equals("DayOfMonth") : DiscoverConstants.requestAttributes[n2].equals("DayOfWeek")) break block8;
                }
                if ((string4 = ((DiscoverRequest)this.requestList.elementAt(n)).getPropertyValue(DiscoverConstants.requestAttributes[n2])) == null) {
                    string4 = " ";
                }
                if ((string3 = DiscoverConstants.requestAttributes[n2]).equals("Status") || string3.equals("DiscoverTopologyMethod") || string3.equals("Frequency") || string3.equals("DayOfWeek") || string3.equals("Logging") || string3.equals("Scheduled")) {
                    string4 = this.getI18NString(string4);
                }
                this.detailTextArea.append(this.getI18NString(DiscoverConstants.requestAttributes[n2]) + " = " + string4 + this.getI18NString("newline"));
            }
            ++n2;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block32: {
            String string = this.domain;
            this.getDomainNamefromUrl();
            if (this.domain.equals("")) {
                this.showError(this.getI18NString("Following_domain_has_been_deleted_colon_") + string);
                this.updateDomain(null);
                return;
            }
            if (actionEvent.getSource() == this.requestAddButton) {
                if (this.requestDialog != null) {
                    return;
                }
                this.requestDialog = new RequestEditDialog(this, null, "add");
                if (this.requestDialog.init()) {
                    this.requestDialog.show();
                } else {
                    this.requestDialog.dispose();
                }
                return;
            }
            DiscoverRequest discoverRequest = null;
            int n = 0;
            while (n < this.requestList.size()) {
                if (this.dTable.isRowSelected(n)) {
                    discoverRequest = (DiscoverRequest)this.requestList.elementAt(n);
                }
                ++n;
            }
            if (discoverRequest == null) {
                this.showError(this.getI18NString("selectFirst"));
                return;
            }
            if (actionEvent.getSource() == this.requestModifyButton) {
                if (this.requestDialog != null) {
                    return;
                }
                this.requestDialog = new RequestEditDialog(this, discoverRequest, "edit");
                if (this.requestDialog.init()) {
                    this.requestDialog.show();
                } else {
                    this.requestDialog.dispose();
                }
                return;
            }
            if (actionEvent.getSource() == this.requestDuplicateButton) {
                if (this.requestDialog != null) {
                    return;
                }
                this.requestDialog = new RequestEditDialog(this, discoverRequest, "duplicate");
                if (this.requestDialog.init()) {
                    this.requestDialog.show();
                } else {
                    this.requestDialog.dispose();
                }
                return;
            }
            if (this.confirmDialog != null) {
                return;
            }
            if (actionEvent.getSource() == this.requestDeleteButton) {
                this.confirmDialog = new DiscoverConfirmDialog(this, discoverRequest, this.getI18NString("Do_you_want_to_delete_following_request"), "delete");
                this.confirmDialog.setYesText(this.getI18NString("Ok"));
                this.confirmDialog.showButtons(true, false, true);
            } else if (actionEvent.getSource() == this.requestStartButton) {
                try {
                    try {
                        boolean bl = this.discoverRequestHandle.startRequest(discoverRequest.getId());
                        if (bl) break block32;
                        boolean bl2 = true;
                        SMAPIException sMAPIException = this.discoverRequestHandle.getException();
                        if (sMAPIException != null && sMAPIException.getReasonCode() == 1) {
                            bl2 = false;
                            this.showError(this.getI18NString("startRequestFailedSec"));
                        }
                        if (bl2) {
                            this.showError(this.getI18NString("startRequestFailed"));
                        }
                    }
                    catch (SMAPIException sMAPIException) {
                        throw new DiscoverGUIException("Exception :SMAPI Exception in delete/start/stop operation");
                    }
                }
                catch (DiscoverGUIException discoverGUIException) {
                    discoverGUIException.print();
                }
            } else if (actionEvent.getSource() == this.requestStopButton) {
                this.confirmDialog = new DiscoverConfirmDialog(this, discoverRequest, this.getI18NString("Do_you_want_to_stop_following_request"), "stop");
                this.confirmDialog.setYesText(this.getI18NString("Ok"));
                this.confirmDialog.showButtons(true, false, true);
            } else if (actionEvent.getSource() == this.requestLogButton) {
                if (this.logDialog != null) {
                    this.logDialog.show();
                    return;
                }
                this.logDialog = new DiscoverConfirmDialog(this, discoverRequest, this.getRequestLog(discoverRequest), "log");
                this.logDialog.showButtons(true, false, true);
                this.logDialog.setYesText(this.getI18NString("Refresh"));
                this.logDialog.setCancelText(this.getI18NString("message.close"));
                this.logDialog.init();
                this.logDialog.show();
            }
        }
        if (this.confirmDialog != null) {
            this.confirmDialog.init();
            this.confirmDialog.show();
        }
    }

    public void closeRequestDialog() {
        this.requestDialog = null;
    }

    public void createConfirmDialog(DiscoverRequest discoverRequest, String string, String string2) {
        if (this.confirmDialog != null) {
            return;
        }
        this.confirmDialog = new DiscoverConfirmDialog(this, discoverRequest, string, string2);
        this.confirmDialog.init();
        this.confirmDialog.show();
    }

    public void closeConfirmDialog() {
        this.logDialog = null;
        this.confirmDialog = null;
    }

    public void getRequestResponse(SMRequestStatus sMRequestStatus, Vector vector, Object object) {
        this.processRequests(vector);
        this.updateTable(false);
    }

    public synchronized void updateTable() {
        this.updateTable(false);
    }

    public synchronized void updateTable(boolean bl) {
        if (this.dTable != null) {
            this.dTable.setRequestList(this.requestList, bl);
            if (this.requestList.size() == 0) {
                this.informRowSelected(-1);
                this.dTable.clearSelection();
            } else {
                this.informRowSelected(this.dTable.getSelectedRow());
            }
        }
    }

    public void processRequests(Vector vector) {
        Vector<DiscoverRequest> vector2 = new Vector<DiscoverRequest>();
        if (vector != null) {
            int n = vector.size();
            int n2 = 0;
            while (n2 < n) {
                SMDiscoveryData sMDiscoveryData = (SMDiscoveryData)vector.elementAt(n2);
                if (UcListUtil.AsciiToUnicode((String)sMDiscoveryData.getdomainName()).equals(this.domain)) {
                    int n3;
                    int n4;
                    DiscoverRequest discoverRequest = new DiscoverRequest(this, sMDiscoveryData);
                    if (this.statusBuffer != null) {
                        n4 = this.statusBuffer.size();
                        n3 = 0;
                        while (n3 < n4) {
                            if (discoverRequest.getId().equals(this.statusBuffer.elementAt(n3))) {
                                discoverRequest.setRequestStatus((String)this.statusBuffer.elementAt(n3 + 1));
                            }
                            n3 += 2;
                        }
                    }
                    n4 = this.requestList.size();
                    n3 = 0;
                    while (n3 < n4) {
                        if (((DiscoverRequest)this.requestList.elementAt(n3)).getId().equals(discoverRequest.getId())) {
                            discoverRequest.setRequestStatus(((DiscoverRequest)this.requestList.elementAt(n3)).getRequestStatus());
                        }
                        ++n3;
                    }
                    vector2.addElement(discoverRequest);
                }
                ++n2;
            }
        }
        this.requestList = vector2;
    }

    public void setRequestResponse(SMRequestStatus sMRequestStatus, Object object) {
    }

    public void getRequestStatusResponse(SMRequestStatus sMRequestStatus, Vector vector, Object object) {
        this.processRequestStatus(vector);
        this.updateTable(true);
    }

    public void processRequestStatus(Vector vector) {
        if (vector == null) {
            return;
        }
        this.statusBuffer = new Vector();
        int n = 0;
        while (n < vector.size()) {
            boolean bl = false;
            SMDiscoveryRequestStatus sMDiscoveryRequestStatus = (SMDiscoveryRequestStatus)vector.elementAt(n);
            int n2 = 0;
            while (n2 < this.requestList.size()) {
                if (((DiscoverRequest)this.requestList.elementAt(n2)).getId().equals(sMDiscoveryRequestStatus.getdiscoveryRequestId())) {
                    ((DiscoverRequest)this.requestList.elementAt(n2)).setRequestStatus(sMDiscoveryRequestStatus.getErrorText());
                    bl = true;
                    break;
                }
                ++n2;
            }
            if (!bl) {
                this.statusBuffer.addElement(sMDiscoveryRequestStatus.getdiscoveryRequestId());
                this.statusBuffer.addElement(sMDiscoveryRequestStatus.getErrorText());
            }
            ++n;
        }
    }

    public void doRequestOperation(String string, String string2, boolean bl) throws DiscoverGUIException {
        boolean bl2 = true;
        try {
            if (string2.equals("delete") && bl) {
                bl2 = this.discoverRequestHandle.deleteRequest(string);
                if (!bl2) {
                    boolean bl3 = true;
                    SMAPIException sMAPIException = this.discoverRequestHandle.getException();
                    if (sMAPIException != null && sMAPIException.getReasonCode() == 1) {
                        bl3 = false;
                        this.showError(this.getI18NString("deleteRequestFailedSec"));
                    }
                    if (bl3) {
                        this.showError(this.getI18NString("deleteRequestFailed"));
                    }
                }
            } else if (string2.equals("start") && bl) {
                bl2 = this.discoverRequestHandle.startRequest(string);
                if (!bl2) {
                    boolean bl4 = true;
                    SMAPIException sMAPIException = this.discoverRequestHandle.getException();
                    if (sMAPIException != null && sMAPIException.getReasonCode() == 1) {
                        bl4 = false;
                        this.showError(this.getI18NString("startRequestFailedSec"));
                    }
                    if (bl4) {
                        this.showError(this.getI18NString("startRequestFailed"));
                    }
                }
            } else if (string2.equals("stop") && bl && !(bl2 = this.discoverRequestHandle.stopRequest(string))) {
                boolean bl5 = true;
                SMAPIException sMAPIException = this.discoverRequestHandle.getException();
                if (sMAPIException != null && sMAPIException.getReasonCode() == 1) {
                    bl5 = false;
                    this.showError(this.getI18NString("stopRequestFailedSec"));
                }
                if (bl5) {
                    this.showError(this.getI18NString("stopRequestFailed"));
                }
            }
        }
        catch (SMAPIException sMAPIException) {
            throw new DiscoverGUIException("Exception :SMAPI Exception in delete/start/stop operation");
        }
        if ((string2.equals("add") || string2.equals("edit") || string2.equals("duplicate")) && this.requestDialog.confirmStart(bl)) {
            this.closeRequestDialog();
        }
    }

    public String getI18NString(String string) {
        String string2 = "";
        if (string == null || string.length() == 0) {
            return string2;
        }
        string2 = UcInternationalizer.translateKey((String)("com.sun.symon.tools.discovery.console.presentation.Discovery:" + string));
        return string2;
    }

    public void updateDomain(String string) {
        if (string == null || string.trim().length() == 0) {
            this.domainUrl = "";
            this.domain = "";
        } else {
            this.domainUrl = string;
            this.getDomainNamefromUrl();
        }
        if (this.domain.equals("")) {
            this.requestAddButton.setEnabled(false);
        } else {
            this.requestAddButton.setEnabled(true);
            try {
                topologyAgentIpAddress = this.getTopologyHostIpAddress(this.reqHandle);
            }
            catch (DiscoverGUIException discoverGUIException) {
                discoverGUIException.print();
            }
        }
        this.domainNameDataLabel.setText(this.domain);
        try {
            try {
                Vector vector = this.discoverRequestHandle.getRequestStatus(null);
                this.processRequestStatus(vector);
                Vector vector2 = this.discoverRequestHandle.getRequest(null);
                this.processRequests(vector2);
            }
            catch (SMAPIException sMAPIException) {
                throw new DiscoverGUIException("Exception :SMAPI Exception in getting request list instances");
            }
        }
        catch (DiscoverGUIException discoverGUIException) {
            discoverGUIException.print();
            if (this.errorLabel == null) {
                this.errorLabel = new JLabel(this.getI18NString("Discovery_Requests_Data_is_not_available"));
                this.add(this.errorLabel);
            }
            this.errorLabel.setVisible(true);
        }
        if (this.dTable != null) {
            this.dTable.setRequestList(this.requestList);
            if (this.requestList.size() == 0) {
                this.informRowSelected(-1);
                this.dTable.clearSelection();
            } else {
                this.informRowSelected(this.dTable.getSelectedRow());
            }
        }
    }

    public void showError(String string) {
        DiscoverErrorDialog discoverErrorDialog = new DiscoverErrorDialog(this, string);
        discoverErrorDialog.show();
    }

    public String getRequestLog(DiscoverRequest discoverRequest) {
        String string = "discovery/" + discoverRequest.getId() + ".log";
        SMResourceAccess sMResourceAccess = new SMResourceAccess(this.reqHandle);
        String string2 = this.getI18NString("Log_File_is_not_available");
        if (sMResourceAccess.fileExists("xfile:/" + string)) {
            string2 = sMResourceAccess.getConfigFile(string);
        }
        return string2;
    }
}

