/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.hierarchy;

import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.console.views.hierarchy.CvHierarchyData;
import com.sun.symon.base.console.views.hierarchy.CvHierarchyTree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class CvHierarchyTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected boolean selected;
    protected boolean cutPending;
    protected int guessedIconWidth = 24;
    protected int guessedIconHeight = 24;
    protected Font MyNormalFont = this.getFont();
    protected Font MyItalicFont = new Font("SansSerif", 2, 12);

    public CvHierarchyTreeCellRenderer(Font font) {
        if (font != null) {
            this.setFont(font);
        }
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            String string = this.getText();
            Icon icon = this.getIcon();
            if (string != null && icon != null) {
                Font font = this.getFont();
                FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
                int n = fontMetrics.stringWidth(string);
                int n2 = fontMetrics.getHeight();
                int n3 = icon.getIconWidth();
                int n4 = Math.max(this.guessedIconHeight, icon.getIconHeight());
                int n5 = n3 + this.getIconTextGap() + n;
                int n6 = Math.max(n4, n2);
                dimension = new Dimension(n5 + 8, n6);
                this.guessedIconWidth = Math.max(this.guessedIconWidth, n3);
                this.guessedIconHeight = Math.max(this.guessedIconHeight, n4);
            } else if (string != null && icon == null) {
                Font font = this.getFont();
                FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(font);
                int n = fontMetrics.stringWidth(string);
                int n7 = fontMetrics.getHeight();
                int n8 = this.guessedIconWidth + 4 + n;
                int n9 = Math.max(this.guessedIconHeight, n7);
                dimension = new Dimension(n8 + 8, n9);
            } else {
                dimension = new Dimension(dimension.width + 8, dimension.height);
            }
        }
        return dimension;
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
        this.setText(string);
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)object;
        Object object2 = defaultMutableTreeNode.getUserObject();
        this.cutPending = false;
        if (object2 == null) {
            this.setIcon(null);
            super.setFont(this.MyNormalFont);
        } else {
            CvHierarchyData cvHierarchyData = (CvHierarchyData)((Object)object2);
            this.setIcon(cvHierarchyData.getIconImage());
            if (cvHierarchyData.isEnabled()) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            CvHierarchyTree cvHierarchyTree = (CvHierarchyTree)jTree;
            if (cvHierarchyData.overIconFlag && cvHierarchyTree.isToolTipEnabled()) {
                SMAlarmStatusData sMAlarmStatusData = null;
                sMAlarmStatusData = cvHierarchyData.getAlarmStatusInfo();
                if (sMAlarmStatusData != null) {
                    this.setToolTipText(sMAlarmStatusData.getStatusInToolTip("\n"));
                } else {
                    this.setToolTipText("Awaiting status...");
                }
            } else {
                this.setToolTipText(null);
            }
            if (cvHierarchyData.getCutPending()) {
                this.cutPending = true;
            }
            if (cvHierarchyData.getIsSoftGroupLink()) {
                super.setFont(this.MyItalicFont);
            } else {
                super.setFont(this.MyNormalFont);
            }
        }
        this.selected = bl;
        return this;
    }

    public void paint(Graphics graphics) {
        boolean bl;
        Icon icon = this.getIcon();
        if (this.selected) {
            this.setForeground(Color.white);
            graphics.setColor(Color.blue.darker().darker());
        } else {
            Color color = this.getParent() != null ? this.getParent().getBackground() : this.getBackground();
            graphics.setColor(color);
            if (color.equals(Color.black)) {
                this.setForeground(Color.white);
            } else {
                this.setForeground(Color.black);
            }
        }
        int n = 0;
        int n2 = this.getHeight();
        boolean bl2 = bl = icon != null && this.getText() != null;
        if (bl && this.isEnabled()) {
            n = icon.getIconWidth();
            int n3 = n + this.getIconTextGap();
            graphics.fillRect(n3, 0, this.getWidth() + 1 - n3, n2 - 1);
        } else {
            graphics.fillRect(0, 0, this.getWidth() + 1, n2 + 1);
        }
        super.paint(graphics);
        if (this.cutPending) {
            Dimension dimension = this.getSize();
            graphics.setColor(Color.black);
            this.drawDashedLine(graphics, 0, dimension.height - 1, dimension.width - 1, dimension.height - 1, true);
            this.drawDashedLine(graphics, dimension.width - 1, dimension.height - 1, dimension.width - 1, 0, true);
            this.drawDashedLine(graphics, dimension.width - 1, 0, 0, 0, true);
            this.drawDashedLine(graphics, 0, 0, 0, dimension.height - 1, true);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void drawDashedLine(Graphics var1_1, int var2_2, int var3_3, int var4_4, int var5_5, boolean var6_6) {
        block13: {
            block12: {
                var7_7 = 4;
                var8_8 = var4_4 - var2_2;
                var9_9 = var5_5 - var3_3;
                if (var8_8 != 0) break block12;
                if (var9_9 <= 0) ** GOTO lbl25
                while (var9_9 > 0) {
                    var10_10 = var9_9;
                    if (var10_10 > var7_7) {
                        var10_10 = var7_7;
                    }
                    if (var6_6) {
                        var1_1.drawLine(var2_2, var3_3, var2_2, var3_3 + var10_10);
                    }
                    var9_9 -= var10_10;
                    var3_3 += var10_10;
                    v0 = var6_6 = var6_6 == false;
                }
                break block13;
lbl-1000:
                // 1 sources

                {
                    var10_11 = var9_9;
                    if (var10_11 < -var7_7) {
                        var10_11 = -var7_7;
                    }
                    if (var6_6) {
                        var1_1.drawLine(var2_2, var3_3, var2_2, var3_3 + var10_11);
                    }
                    var9_9 -= var10_11;
                    var3_3 += var10_11;
                    v1 = var6_6 = var6_6 == false;
lbl25:
                    // 2 sources

                    ** while (var9_9 < 0)
                }
lbl26:
                // 1 sources

                break block13;
            }
            if (var8_8 <= 0) ** GOTO lbl48
            while (var8_8 > 0) {
                var10_12 = var8_8;
                if (var10_12 > var7_7) {
                    var10_12 = var7_7;
                }
                if (var6_6) {
                    var1_1.drawLine(var2_2, var3_3, var2_2 + var10_12, var3_3);
                }
                var8_8 -= var10_12;
                var2_2 += var10_12;
                v2 = var6_6 = var6_6 == false;
            }
            break block13;
lbl-1000:
            // 1 sources

            {
                var10_13 = var8_8;
                if (var10_13 < -var7_7) {
                    var10_13 = -var7_7;
                }
                if (var6_6) {
                    var1_1.drawLine(var2_2, var3_3, var2_2 + var10_13, var3_3);
                }
                var8_8 -= var10_13;
                var2_2 += var10_13;
                v3 = var6_6 = var6_6 == false;
lbl48:
                // 2 sources

                ** while (var8_8 < 0)
            }
        }
    }

    public void setFont(Font font) {
        this.MyNormalFont = font;
        this.MyItalicFont = new Font(font.getName(), 2, font.getSize());
    }
}

