/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.graph;

import com.sun.symon.base.console.tools.editor.CtMarginPanel;
import com.sun.symon.base.console.views.graph.CvFontEditor;
import com.sun.symon.base.console.views.graph.CvOrientationEditor;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CvLabelEditor
extends JPanel {
    private CvFontEditor fontEditor = new CvFontEditor();
    private CvOrientationEditor orientation = new CvOrientationEditor();
    private JLabel siteLabel = new JLabel();
    private String siteKey;
    private boolean showLabel = true;
    private String i18nPlacement = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:i18nPlacement");
    String delimit = "^";

    public CvLabelEditor() {
        this.setLayout(new BorderLayout());
        this.add("Center", this.fontEditor);
        this.add("South", this.allLeft());
    }

    private JPanel allLeft() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add("North", this.makeSitePanel());
        jPanel.add("Center", this.makeOrientAndBorder());
        return jPanel;
    }

    public void setShowLabel(boolean bl) {
        this.showLabel = bl;
    }

    public String getConfiguration() {
        String string = this.fontEditor.getFontConfiguration();
        String string2 = this.orientation.getOrientation();
        String string3 = null;
        String string4 = "0";
        return this.showLabel + this.delimit + string + this.delimit + this.siteKey + this.delimit + string2 + this.delimit + string3 + this.delimit + string4;
    }

    public CvFontEditor getFontEditor() {
        return this.fontEditor;
    }

    String getXConfiguration() {
        return "XLabel" + this.delimit + this.getConfiguration();
    }

    String getYConfiguration() {
        return "YLabel" + this.delimit + this.getConfiguration();
    }

    public JPanel makeOrientAndBorder() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 2, 2));
        jPanel.add(this.orientation);
        return jPanel;
    }

    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    public JPanel makeSitePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(new JLabel(this.i18nPlacement + ":  "));
        jPanel.add(this.siteLabel);
        CtMarginPanel ctMarginPanel = new CtMarginPanel(new Insets(10, 2, 5, 2));
        ctMarginPanel.setLayout(new BorderLayout());
        ctMarginPanel.add("West", jPanel);
        return ctMarginPanel;
    }

    public void setFontSelect(CvFontEditor cvFontEditor) {
        this.fontEditor = cvFontEditor;
    }

    public void setLabelFont(Font font) {
        this.fontEditor.setSelectFont(font);
    }

    public void setLabelOrientation(int n) {
        this.orientation.setOrientation(n);
    }

    String getLabelSite(int n) {
        if (n == 1) {
            return "east";
        }
        if (n == 2) {
            return "west";
        }
        if (n == 16) {
            return "north";
        }
        if (n == 32) {
            return "south";
        }
        if (n == 17) {
            return "northeast";
        }
        if (n == 18) {
            return "northwest";
        }
        if (n == 33) {
            return "southeast";
        }
        return "southwest";
    }

    public void setLabelSite(int n) {
        this.siteKey = this.getLabelSite(n);
        this.siteLabel.setText(UcInternationalizer.translateKey((String)("base.console.views.graph.Graph:position." + this.siteKey)));
    }

    public void setLabelText(String string) {
        this.fontEditor.setSampleText(string);
    }

    public String getLabelText() {
        return this.fontEditor.getSampleText();
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("Hi Jeff, another primitive?");
        jFrame.getContentPane().add("Center", new CvLabelEditor());
        jFrame.pack();
        jFrame.show();
    }
}

