/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.graph;

import com.sun.symon.base.console.views.graph.CvGraphBorderFormat;
import com.sun.symon.base.console.views.graph.CvGraphDirectionFormat;
import com.sun.symon.base.console.views.graph.CvGraphFooterFormat;
import com.sun.symon.base.console.views.graph.CvGraphHeaderFormat;
import com.sun.symon.base.console.views.graph.CvGraphInvalidInputException;
import com.sun.symon.base.console.views.graph.CvGraphLegendFormat;
import com.sun.symon.base.console.views.graph.CvGraphLineFormat;
import com.sun.symon.base.console.views.graph.CvGraphStyleFormat;
import com.sun.symon.base.console.views.graph.CvGraphXAxisFormat;
import com.sun.symon.base.console.views.graph.CvGraphXLabelFormat;
import com.sun.symon.base.console.views.graph.CvGraphYAxisFormat;
import com.sun.symon.base.console.views.graph.CvGraphYLabelFormat;
import com.sun.symon.base.utility.UcDDL;
import java.util.Vector;

public class CvGraphFormat {
    public static final String KEYWORD_AXIS = "Axis";
    public static final String KEYWORD_X_AXIS = "XAxis";
    public static final String KEYWORD_Y_AXIS = "YAxis";
    public static final String KEYWORD_STYLE = "Style";
    public static final String KEYWORD_LEGEND = "Legend";
    public static final String KEYWORD_LINE = "Line";
    public static final String KEYWORD_BORDER = "Border";
    public static final String KEYWORD_HEADER = "Header";
    public static final String KEYWORD_FOOTER = "Footer";
    public static final String KEYWORD_GRID = "Grid";
    public static final String KEYWORD_XLABEL = "XLabel";
    public static final String KEYWORD_YLABEL = "YLabel";
    public static final String KEYWORD_DIRECTIONS = "Directions";
    public static final String KEYWORD_OTHERS = "Others";
    public static final String DIRECTION_HORIZONTAL = "horizontal";
    public static final String DIRECTION_VERTICAL = "vertical";
    public static final String ORIENTATION_DEG0 = "horizontal";
    public static final String ORIENTATION_DEG90 = "verticalflip";
    public static final String ORIENTATION_DEG180 = "upsidedown";
    public static final String ORIENTATION_DEG270 = "vertical";
    public static final String POSITION_SOUTH = "south";
    public static final String POSITION_SOUTH_WEST = "southwest";
    public static final String POSITION_SOUTH_EAST = "southeast";
    public static final String POSITION_WEST = "west";
    public static final String POSITION_EAST = "east";
    public static final String POSITION_NORTH = "north";
    public static final String POSITION_NORTH_WEST = "northwest";
    public static final String POSITION_NORTH_EAST = "northeast";
    public static final String FONT_STYLE_PLAIN = "plain";
    public static final String FONT_STYLE_BOLD = "bold";
    public static final String FONT_STYLE_ITALIC = "italic";
    public static final String FONT_STYLE_BOLDITALIC = "bolditalic";
    public static final String FONT_NAME_SERIF = "Serif";
    public static final String FONT_NAME_SANSSERIF = "SansSerif";
    public static final String FONT_NAME_MONOSAPCED = "Monospaced";
    public static final String BORDER_STYLE_NONE = "none";
    public static final String BORDER_STYLE_ETCHED_IN = "etchedin";
    public static final String BORDER_STYLE_ETCHED_OUT = "etchedout";
    public static final String BORDER_STYLE_IN = "in";
    public static final String BORDER_STYLE_OUT = "out";
    public static final String BORDER_STYLE_PLAIN = "plain";
    public static final String BORDER_STYLE_FRAME_IN = "framein";
    public static final String BORDER_STYLE_FRAME_OUT = "frameout";
    private boolean liveData = true;
    private boolean showAxes = true;
    private boolean showGrids = false;
    public static final String FIELD_DELIMITER = "^";
    public static final String OBJECT_DELIMITER = "|";
    private CvGraphStyleFormat styleFormat = new CvGraphStyleFormat();
    private CvGraphXAxisFormat xAxisFormat = new CvGraphXAxisFormat();
    private CvGraphYAxisFormat yAxisFormat = new CvGraphYAxisFormat();
    private CvGraphLegendFormat legendFormat = new CvGraphLegendFormat();
    private CvGraphXLabelFormat xLabelFormat = new CvGraphXLabelFormat();
    private CvGraphYLabelFormat yLabelFormat = new CvGraphYLabelFormat();
    private CvGraphHeaderFormat headerFormat = new CvGraphHeaderFormat();
    private CvGraphFooterFormat footerFormat = new CvGraphFooterFormat();
    private CvGraphDirectionFormat directionFormat = new CvGraphDirectionFormat();
    private CvGraphBorderFormat borderFormat = new CvGraphBorderFormat();
    private Vector lineFormats = new Vector();

    public boolean getDataState() {
        return this.liveData;
    }

    public String getDataStateString() {
        if (this.liveData) {
            return "true";
        }
        return "false";
    }

    public void setDataState(boolean bl) {
        this.liveData = bl;
    }

    public boolean getShowGraphAxes() {
        return this.showAxes;
    }

    public String getShowAxesString() {
        if (this.showAxes) {
            return "true";
        }
        return "false";
    }

    public void setShowGraphAxes(boolean bl) {
        this.showAxes = bl;
    }

    public boolean getShowGraphGrids() {
        return this.showGrids;
    }

    public String getShowGridsString() {
        if (this.showGrids) {
            return "true";
        }
        return "false";
    }

    public void setShowGraphGrids(boolean bl) {
        this.showGrids = bl;
    }

    public static String[] splitString(String string, String string2) {
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n != -1) {
            int n2 = string.indexOf(string2, n);
            if (n2 == -1) {
                vector.addElement(string.substring(n));
                n = -1;
                continue;
            }
            vector.addElement(string.substring(n, n2));
            n = n2 + 1;
        }
        String[] stringArray = new String[vector.size()];
        int n3 = 0;
        while (n3 < vector.size()) {
            stringArray[n3] = (String)vector.elementAt(n3);
            ++n3;
        }
        return stringArray;
    }

    public void addLine(CvGraphLineFormat cvGraphLineFormat) {
        if (cvGraphLineFormat != null) {
            this.lineFormats.addElement(cvGraphLineFormat);
        }
    }

    public void removeAllLines() {
        if (this.lineFormats != null) {
            this.lineFormats.removeAllElements();
        }
    }

    public String getConfiguration() {
        String string = "Others^" + this.getDataStateString() + FIELD_DELIMITER + this.getShowAxesString() + FIELD_DELIMITER + this.getShowGridsString();
        string = string + OBJECT_DELIMITER + this.directionFormat.getConfiguration();
        string = string + OBJECT_DELIMITER + this.styleFormat.getConfiguration();
        string = string + OBJECT_DELIMITER + this.xAxisFormat.getConfiguration();
        string = string + OBJECT_DELIMITER + this.yAxisFormat.getConfiguration();
        string = string + OBJECT_DELIMITER + this.legendFormat.getConfiguration();
        string = string + OBJECT_DELIMITER + this.borderFormat.getConfiguration();
        string = string + OBJECT_DELIMITER + this.headerFormat.getConfiguration();
        string = string + OBJECT_DELIMITER + this.footerFormat.getConfiguration();
        string = string + OBJECT_DELIMITER + this.xLabelFormat.getConfiguration();
        string = string + OBJECT_DELIMITER + this.yLabelFormat.getConfiguration();
        return string;
    }

    public CvGraphDirectionFormat getDirectionFormat() {
        return this.directionFormat;
    }

    public CvGraphXLabelFormat getXLabelFormat() {
        return this.xLabelFormat;
    }

    public CvGraphYLabelFormat getYLabelFormat() {
        return this.yLabelFormat;
    }

    public CvGraphLegendFormat getLegendFormat() {
        return this.legendFormat;
    }

    public CvGraphBorderFormat getBorderFormat() {
        return this.borderFormat;
    }

    public CvGraphHeaderFormat getHeaderFormat() {
        return this.headerFormat;
    }

    public CvGraphFooterFormat getFooterFormat() {
        return this.footerFormat;
    }

    public CvGraphStyleFormat getStyleFormat() {
        return this.styleFormat;
    }

    public CvGraphLineFormat getLineFormat(int n) {
        return n >= 0 && n < this.lineFormats.size() ? (CvGraphLineFormat)this.lineFormats.elementAt(n) : null;
    }

    public int getNumLines() {
        return this.lineFormats.size();
    }

    public static int getBorderTypeNumber(String string) {
        int n = 0;
        if (string.equals(BORDER_STYLE_IN)) {
            n = 4;
        } else if (string.equals(BORDER_STYLE_OUT)) {
            n = 5;
        } else if (string.equals(BORDER_STYLE_NONE)) {
            n = 0;
        } else if (string.equals(BORDER_STYLE_ETCHED_IN)) {
            n = 2;
        } else if (string.equals(BORDER_STYLE_ETCHED_OUT)) {
            n = 3;
        } else if (string.equals("plain")) {
            n = 1;
        }
        return n;
    }

    public static int getDirectionNumber(String string) {
        if (string.equals("horizontal")) {
            return 0;
        }
        return 1;
    }

    public static int getFontStyleNumber(String string) {
        if (string.equals(FONT_STYLE_BOLD)) {
            return 1;
        }
        if (string.equals(FONT_STYLE_ITALIC)) {
            return 2;
        }
        if (string.equals(FONT_STYLE_BOLDITALIC)) {
            return 3;
        }
        return 0;
    }

    public static int getOrientationNumber(String string) {
        if (string.equals("horizontal")) {
            return 0;
        }
        if (string.equals(ORIENTATION_DEG90)) {
            return 1;
        }
        if (string.equals(ORIENTATION_DEG180)) {
            return 2;
        }
        if (string.equals("vertical")) {
            return 3;
        }
        return 0;
    }

    public static int getPositionNumber(String string) {
        if (string.equals(POSITION_NORTH)) {
            return 16;
        }
        if (string.equals(POSITION_NORTH_WEST)) {
            return 18;
        }
        if (string.equals(POSITION_NORTH_EAST)) {
            return 17;
        }
        if (string.equals(POSITION_WEST)) {
            return 2;
        }
        if (string.equals(POSITION_EAST)) {
            return 1;
        }
        if (string.equals(POSITION_SOUTH)) {
            return 32;
        }
        if (string.equals(POSITION_SOUTH_WEST)) {
            return 34;
        }
        if (string.equals(POSITION_SOUTH_EAST)) {
            return 33;
        }
        return 32;
    }

    public CvGraphXAxisFormat getXAxisFormat() {
        return this.xAxisFormat;
    }

    public CvGraphYAxisFormat getYAxisFormat() {
        return this.yAxisFormat;
    }

    public void setConfiguration(String string) throws CvGraphInvalidInputException {
        if (string == null || string.length() == 0) {
            return;
        }
        String[] stringArray = CvGraphFormat.splitString(string, OBJECT_DELIMITER);
        if (stringArray.length == 0) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            String[] stringArray2 = CvGraphFormat.splitString(string2, FIELD_DELIMITER);
            if (stringArray2.length > 0) {
                if (stringArray2[0].equals(KEYWORD_DIRECTIONS)) {
                    this.directionFormat.setConfiguration(string2);
                } else if (stringArray2[0].equals(KEYWORD_STYLE)) {
                    this.styleFormat.setConfiguration(string2);
                } else if (stringArray2[0].equals(KEYWORD_LEGEND)) {
                    this.legendFormat.setConfiguration(string2);
                } else if (stringArray2[0].equals(KEYWORD_X_AXIS)) {
                    this.xAxisFormat.setConfiguration(string2);
                } else if (stringArray2[0].equals(KEYWORD_Y_AXIS)) {
                    this.yAxisFormat.setConfiguration(string2);
                } else if (stringArray2[0].equals(KEYWORD_BORDER)) {
                    this.borderFormat.setConfiguration(string2);
                } else if (stringArray2[0].equals(KEYWORD_HEADER)) {
                    this.headerFormat.setConfiguration(string2);
                } else if (stringArray2[0].equals(KEYWORD_FOOTER)) {
                    this.footerFormat.setConfiguration(string2);
                } else if (stringArray2[0].equals(KEYWORD_XLABEL)) {
                    this.xLabelFormat.setConfiguration(string2);
                } else if (stringArray2[0].equals(KEYWORD_YLABEL)) {
                    this.yLabelFormat.setConfiguration(string2);
                } else if (stringArray2[0].equals(KEYWORD_OTHERS)) {
                    this.resetOtherFormats(stringArray2);
                }
            }
            ++n;
        }
    }

    private void resetOtherFormats(String[] stringArray) {
        if (stringArray == null) {
            return;
        }
        if (stringArray.length != 4) {
            UcDDL.logDebugMessage((String)"invalid number of other formats");
            return;
        }
        this.liveData = Boolean.valueOf(stringArray[1]);
        this.showAxes = Boolean.valueOf(stringArray[2]);
        this.showGrids = Boolean.valueOf(stringArray[3]);
    }

    public void setBorderFormat(CvGraphBorderFormat cvGraphBorderFormat) {
        this.borderFormat = cvGraphBorderFormat != null ? cvGraphBorderFormat : new CvGraphBorderFormat();
    }

    public void setXAxisFormat(CvGraphXAxisFormat cvGraphXAxisFormat) {
        this.xAxisFormat = cvGraphXAxisFormat != null ? cvGraphXAxisFormat : new CvGraphXAxisFormat();
    }

    public void setYAxisFormat(CvGraphYAxisFormat cvGraphYAxisFormat) {
        this.yAxisFormat = cvGraphYAxisFormat != null ? cvGraphYAxisFormat : new CvGraphYAxisFormat();
    }

    public boolean fontStyleIsValid(String string) {
        return string.equals("plain") || string.equals(FONT_STYLE_BOLD) || string.equals(FONT_STYLE_ITALIC) || string.equals(FONT_STYLE_BOLDITALIC);
    }

    public boolean borderTypeIsValid(String string) {
        return string.equals(BORDER_STYLE_NONE) || string.equals(BORDER_STYLE_ETCHED_IN) || string.equals(BORDER_STYLE_ETCHED_OUT) || string.equals(BORDER_STYLE_IN) || string.equals(BORDER_STYLE_OUT) || string.equals("plain") || string.equals(BORDER_STYLE_FRAME_IN) || string.equals(BORDER_STYLE_FRAME_OUT);
    }

    public boolean orientationIsValid(String string) {
        return string.equals("horizontal") || string.equals(ORIENTATION_DEG90) || string.equals(ORIENTATION_DEG180) || string.equals("vertical");
    }

    public boolean directionIsValid(String string) {
        return string.equals("horizontal") || !string.equals("vertical");
    }

    public boolean positionIsValid(String string) {
        return string.equals(POSITION_NORTH) || string.equals(POSITION_NORTH_WEST) || string.equals(POSITION_NORTH_EAST) || string.equals(POSITION_WEST) || string.equals(POSITION_EAST) || string.equals(POSITION_SOUTH) || string.equals(POSITION_SOUTH_WEST) || string.equals(POSITION_SOUTH_EAST);
    }
}

