/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import com.sun.symon.base.console.tools.editor.CtDateTimeChangedListener;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class CtDateTimePanel
extends JPanel {
    private JComboBox monthCmB;
    private JComboBox dateCmB;
    private JComboBox yearCmB;
    private JComboBox hourCmB;
    private JComboBox minuteCmB;
    private JLabel weekDayLbl;
    Calendar calendar;
    private DateFormatSymbols symbols;
    private Vector listenersVec = new Vector();

    public CtDateTimePanel(Calendar calendar) {
        this.createGUI();
        this.symbols = new DateFormatSymbols();
        this.initData();
        this.setCurrentTime(calendar);
        this.installListeners();
    }

    public CtDateTimePanel() {
        this((Calendar)null);
    }

    public String getTimexFormatString() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(Locale.ENGLISH);
        int n = this.calendar.get(2);
        String string = dateFormatSymbols.getMonths()[n - 0] + " " + this.calendar.get(5) + " " + this.calendar.get(1);
        String string2 = "" + this.calendar.get(11) + ":" + this.calendar.get(12);
        return string + " " + string2;
    }

    public Calendar getCurrentTime() {
        return this.calendar;
    }

    public void setCurrentTime(Calendar calendar) {
        this.calendar = calendar;
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        int n = this.calendar.get(5);
        int n2 = this.calendar.get(1);
        int n3 = this.calendar.get(2);
        int n4 = this.calendar.get(11);
        int n5 = this.calendar.get(12);
        this.monthCmB.setSelectedIndex(n3);
        this.dateCmB.setSelectedIndex(n - 1);
        Calendar calendar2 = Calendar.getInstance();
        int n6 = calendar2.get(1);
        int n7 = n2 < n6 ? n2 : n6;
        int n8 = n7 + 20 > n2 ? n7 + 20 : n2;
        this.yearCmB.removeAllItems();
        int n9 = 0;
        int n10 = n7;
        while (n10 < n8) {
            this.yearCmB.addItem("" + n10);
            if (n10 == n2) {
                n9 = n10 - n7;
            }
            ++n10;
        }
        this.yearCmB.setSelectedIndex(n9);
        this.hourCmB.setSelectedIndex(n4);
        this.minuteCmB.setSelectedIndex(n5);
    }

    void installListeners() {
        ItemListener itemListener = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    int n;
                    String string = (String)CtDateTimePanel.this.yearCmB.getSelectedItem();
                    try {
                        n = new Integer(string);
                        CtDateTimePanel.this.calendar.set(1, n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        return;
                    }
                    CtDateTimePanel.this.calendar.set(2, CtDateTimePanel.this.monthCmB.getSelectedIndex() + 0);
                    CtDateTimePanel.this.calendar.set(5, 1);
                    n = CtDateTimePanel.this.calendar.getActualMaximum(5);
                    int n2 = CtDateTimePanel.this.dateCmB.getSelectedIndex() + 1;
                    if (n < n2) {
                        UcDialog.showError((Object)UcInternationalizer.translateKey((String)("com.sun.symon.base.console.tools.editor.Schedule:errorDate(" + n + ")")));
                        CtDateTimePanel.this.dateCmB.setSelectedIndex(n - 1);
                    }
                    CtDateTimePanel.this.calendar.set(5, CtDateTimePanel.this.dateCmB.getSelectedIndex() + 1);
                    int n3 = CtDateTimePanel.this.calendar.get(7);
                    CtDateTimePanel.this.weekDayLbl.setText("(" + CtDateTimePanel.this.symbols.getWeekdays()[n3] + ")");
                    CtDateTimePanel.this.fireDateTimeChanged();
                }
            }
        };
        ItemListener itemListener2 = new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    CtDateTimePanel.this.calendar.set(11, CtDateTimePanel.this.hourCmB.getSelectedIndex());
                    CtDateTimePanel.this.calendar.set(12, CtDateTimePanel.this.minuteCmB.getSelectedIndex());
                    CtDateTimePanel.this.fireDateTimeChanged();
                }
            }
        };
        this.monthCmB.addItemListener(itemListener);
        this.dateCmB.addItemListener(itemListener);
        this.yearCmB.addItemListener(itemListener);
        this.hourCmB.addItemListener(itemListener2);
        this.minuteCmB.addItemListener(itemListener2);
    }

    public void addDateTimeChangedListener(CtDateTimeChangedListener ctDateTimeChangedListener) {
        this.listenersVec.add(ctDateTimeChangedListener);
    }

    public void removeDateTimeChangedListener(CtDateTimeChangedListener ctDateTimeChangedListener) {
        this.listenersVec.remove(ctDateTimeChangedListener);
    }

    void fireDateTimeChanged() {
        if (!this.listenersVec.isEmpty()) {
            Calendar calendar = this.getCurrentTime();
            int n = this.listenersVec.size();
            int n2 = 0;
            while (n2 < n) {
                CtDateTimeChangedListener ctDateTimeChangedListener = (CtDateTimeChangedListener)this.listenersVec.elementAt(n2);
                ctDateTimeChangedListener.dateTimeChanged(calendar);
                ++n2;
            }
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.monthCmB.setEnabled(bl);
        this.dateCmB.setEnabled(bl);
        this.yearCmB.setEnabled(bl);
        this.hourCmB.setEnabled(bl);
        this.minuteCmB.setEnabled(bl);
    }

    void createGUI() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.monthCmB = new JComboBox();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 5, 5);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 3;
        this.add((Component)this.monthCmB, gridBagConstraints);
        this.dateCmB = new JComboBox();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        this.add((Component)this.dateCmB, gridBagConstraints);
        this.yearCmB = new JComboBox();
        gridBagConstraints.gridx = 4;
        this.add((Component)this.yearCmB, gridBagConstraints);
        gridBagConstraints.gridx = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        this.weekDayLbl = new JLabel("        ");
        this.add((Component)this.weekDayLbl, gridBagConstraints);
        this.hourCmB = new JComboBox();
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        this.add((Component)this.hourCmB, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.add((Component)new JLabel(":"), gridBagConstraints);
        this.minuteCmB = new JComboBox();
        gridBagConstraints.gridx = 2;
        this.add((Component)this.minuteCmB, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 2;
        this.add((Component)new JLabel(UcInternationalizer.translateKey((String)"com.sun.symon.base.console.tools.editor.Schedule:hourMinute")), gridBagConstraints);
    }

    void initData() {
        String[] stringArray = this.symbols.getMonths();
        String[] stringArray2 = null;
        if (stringArray[12].trim().equals("")) {
            stringArray2 = new String[12];
            System.arraycopy(stringArray, 0, stringArray2, 0, 12);
        } else {
            stringArray2 = stringArray;
        }
        this.monthCmB.setModel(new DefaultComboBoxModel<String>(stringArray2));
        stringArray = new String[31];
        int n = 0;
        while (n < 31) {
            stringArray[n] = "" + (n + 1);
            ++n;
        }
        this.dateCmB.setModel(new DefaultComboBoxModel<String>(stringArray));
        stringArray = new String[24];
        int n2 = 0;
        while (n2 < 24) {
            stringArray[n2] = "" + n2;
            if (n2 < 10) {
                stringArray[n2] = "0" + stringArray[n2];
            }
            ++n2;
        }
        this.hourCmB.setModel(new DefaultComboBoxModel<String>(stringArray));
        stringArray = new String[60];
        int n3 = 0;
        while (n3 < 60) {
            stringArray[n3] = "" + n3;
            if (n3 < 10) {
                stringArray[n3] = "0" + stringArray[n3];
            }
            ++n3;
        }
        this.minuteCmB.setModel(new DefaultComboBoxModel<String>(stringArray));
    }
}

