/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import com.sun.symon.base.console.tools.editor.CtActionField;
import com.sun.symon.base.console.tools.editor.CtAttributeEditor;
import com.sun.symon.base.console.tools.editor.CtFocusChangeEvent;
import com.sun.symon.base.console.tools.editor.CtFocusChangeListener;
import com.sun.symon.base.console.tools.editor.CtFocusTraversable;
import com.sun.symon.base.console.tools.editor.CtResetEvent;
import com.sun.symon.base.console.tools.editor.CtResetListener;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JCheckBox;

public class CtActionBoolean
extends JCheckBox
implements CtFocusTraversable,
KeyListener,
FocusListener,
CtResetListener {
    private String checkedText;
    private String uncheckedText;
    private String current;
    private String original;
    private boolean lastEditable = false;
    private boolean changed = false;
    private boolean hasFocus = false;
    private CtAttributeEditor editor;
    private CtActionField actionField;
    private Vector focusListener = new Vector();
    private boolean selected;
    private boolean firstTime = true;

    public CtActionBoolean(CtAttributeEditor ctAttributeEditor, CtActionField ctActionField) {
        this.checkedText = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:edit.boolean.yes");
        this.uncheckedText = UcInternationalizer.translateKey((String)"base.console.ConsoleGeneric:edit.boolean.no");
        this._CtActionBoolean(ctAttributeEditor, ctActionField);
    }

    public CtActionBoolean(CtAttributeEditor ctAttributeEditor, CtActionField ctActionField, String string, String string2) {
        this.checkedText = UcInternationalizer.translateKey((String)string);
        this.uncheckedText = UcInternationalizer.translateKey((String)string2);
        this._CtActionBoolean(ctAttributeEditor, ctActionField);
    }

    public void _CtActionBoolean(CtAttributeEditor ctAttributeEditor, CtActionField ctActionField) {
        this.editor = ctAttributeEditor;
        this.actionField = ctActionField;
        this.addKeyListener(this);
        this.addFocusListener(this);
        this.setHorizontalAlignment(2);
        this.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CtActionBoolean.this.setText(CtActionBoolean.this.isSelected() ? CtActionBoolean.this.checkedText : CtActionBoolean.this.uncheckedText);
                if (CtActionBoolean.this.firstTime) {
                    CtActionBoolean.this.setForeground(CtActionBoolean.this.editor.getAttValueForeground());
                    CtActionBoolean.this.firstTime = false;
                    return;
                }
                CtActionBoolean.this.setForeground(CtActionBoolean.this.editor.getEditedForeground());
                CtActionBoolean.this.editor.notifyEdited();
                CtActionBoolean.this.actionField.updateSaveData(true);
                CtActionBoolean.this.changed = true;
            }
        });
        if (this.actionField.isRequestFocusEnabled()) {
            ctAttributeEditor.addCtResetListener(this);
        }
    }

    public void setSelected(boolean bl) {
        super.setSelected(bl);
        if (this.firstTime) {
            this.setText(this.isSelected() ? this.checkedText : this.uncheckedText);
            this.setForeground(this.editor.getAttValueForeground());
            this.firstTime = false;
        }
    }

    public void attributeReset(CtResetEvent ctResetEvent) {
        this.setSelected(this.actionField.getInitialManualValue());
        this.reset(ctResetEvent);
    }

    public void reset(CtResetEvent ctResetEvent) {
        this.setForeground(this.editor.getAttValueForeground());
        this.changed = false;
        this.repaint();
    }

    public synchronized void addCtFocusChangeListener(CtFocusChangeListener ctFocusChangeListener) {
        if (!this.focusListener.contains(ctFocusChangeListener)) {
            this.focusListener.addElement(ctFocusChangeListener);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.requestFocus();
        this.notifyFocusChange();
        this.hasFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.changed) {
            this.setForeground(this.editor.getEditedForeground());
        } else {
            this.setForeground(this.editor.getAttValueForeground());
        }
        this.hasFocus = false;
        this.repaint();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isOpaque() {
        return true;
    }

    public boolean isRequestFocusEnabled() {
        return true;
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
        Character c = new Character('\n');
        if (c.equals(new Character(keyEvent.getKeyChar()))) {
            if (this.lastEditable) {
                this.editor.currentPanel.firstGrabFocus();
            } else {
                this.transferFocus();
            }
        }
    }

    public void notifyFocusChange() {
        Vector vector;
        CtFocusChangeEvent ctFocusChangeEvent = new CtFocusChangeEvent(this);
        CtActionBoolean ctActionBoolean = this;
        synchronized (ctActionBoolean) {
            vector = (Vector)this.focusListener.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            CtFocusChangeListener ctFocusChangeListener = (CtFocusChangeListener)vector.elementAt(n);
            ctFocusChangeListener.attributeFocusChanged(ctFocusChangeEvent);
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        super.paint(graphics);
        if (this.hasFocus) {
            graphics.setColor(this.editor.getFocusedBorderColor());
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

