/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.manager;

import com.sun.symon.base.client.attribute.SMAttributeDataException;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.console.manager.CmConsoleSession;
import com.sun.symon.base.console.tools.editor.CtAttributeEditor;
import com.sun.symon.base.console.tools.editor.CtEditedEvent;
import com.sun.symon.base.console.tools.editor.CtEditedListener;
import com.sun.symon.base.console.tools.editor.CtEditorISDException;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcURL;
import javax.swing.SwingUtilities;

public class CmAttributeEditor
implements CtEditedListener,
AwxServiceManager,
Runnable {
    private AwxServiceProvider SvcProvider = null;
    private CtAttributeEditor Editor = null;
    private boolean CloseOnSuccess = false;

    public void attributeEdited(CtEditedEvent ctEditedEvent) {
        String[] stringArray = new String[]{""};
        this.SvcProvider.triggerService("edited");
        this.SvcProvider.triggerService("message", stringArray);
    }

    public void editApplyPressed() {
        if (this.Editor == null) {
            return;
        }
        this.CloseOnSuccess = false;
        Thread thread = new Thread((Runnable)this, "attribute-save");
        thread.start();
    }

    public void editCancelPressed() {
        this.SvcProvider.triggerService("destroyWindow");
    }

    public void editOkPressed() {
        if (this.Editor == null) {
            return;
        }
        this.CloseOnSuccess = true;
        Thread thread = new Thread((Runnable)this, "attribute-save");
        thread.start();
    }

    public void editResetPressed() {
        this.Editor.resetAttributes();
        String[] stringArray = new String[]{""};
        this.SvcProvider.triggerService("reset");
        this.SvcProvider.triggerService("message", stringArray);
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        this.SvcProvider = awxServiceProvider;
    }

    public void run() {
        String[] stringArray = new String[]{"base.console.ConsoleMessages:attedit.work"};
        this.SvcProvider.triggerService("message", stringArray);
        this.SvcProvider.triggerService("busyStart");
        boolean bl = this.saveData();
        this.SvcProvider.triggerService("busyEnd");
        if (!bl) {
            return;
        }
        if (this.CloseOnSuccess) {
            this.SvcProvider.triggerService("destroyWindow");
        } else {
            String[] stringArray2 = new String[]{"base.console.ConsoleMessages:attedit.success"};
            this.SvcProvider.triggerService("reset");
            this.SvcProvider.triggerService("message", stringArray2);
        }
    }

    private boolean saveData() {
        try {
            this.Editor.saveAttributes();
        }
        catch (CtEditorISDException ctEditorISDException) {
            String string = UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:attedit.invalid");
            String[] stringArray = new String[]{string + ctEditorISDException.getMessage()};
            this.SvcProvider.triggerService("messageBell", stringArray);
            return false;
        }
        catch (SMAttributeDataException sMAttributeDataException) {
            Object object;
            final String[] stringArray = new String[1];
            String string = sMAttributeDataException.getKey();
            stringArray[0] = string == null ? (sMAttributeDataException.getReasonCode() == 1 ? (CmConsoleSession.isInRemoteServerContext((object = new UcURL(this.Editor.getEditObject())).getHost(), object.getPort()) ? UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:attedit.noaccess") + " " + UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:console.remoteServer") : "base.console.ConsoleMessages:attedit.noaccess") : "base.console.ConsoleMessages:attedit.failed") : (sMAttributeDataException.getReasonCode() == 1 ? (CmConsoleSession.isInRemoteServerContext((object = new UcURL(this.Editor.getEditObject())).getHost(), object.getPort()) ? UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:attedit.noaccessfor") + " " + UcInternationalizer.translateKey((String)string) + " " + UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:console.remoteServer") : UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:attedit.noaccessfor") + " " + UcInternationalizer.translateKey((String)string)) : (sMAttributeDataException.getReasonCode() == 5 ? UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:attedit.badvaluefor") + " " + UcInternationalizer.translateKey((String)string) : UcInternationalizer.translateKey((String)"base.console.ConsoleMessages:attedit.failedfor") + " " + UcInternationalizer.translateKey((String)string)));
            object = new Runnable(){

                public void run() {
                    CmAttributeEditor.this.SvcProvider.triggerService("messageBell", stringArray);
                }
            };
            SwingUtilities.invokeLater((Runnable)object);
            return false;
        }
        return true;
    }

    public void setEditorBean(Object object) {
        try {
            this.Editor = (CtAttributeEditor)object;
        }
        catch (Exception exception) {
            UcDDL.logErrorMessage((String)"CmModuleEditor: invalid editorInstance");
            this.Editor = null;
        }
    }

    public void reset() {
        this.Editor.addCtEditedListener(this);
        if (this.Editor.getStatus()) {
            this.SvcProvider.triggerService("destroyWindow");
        }
    }
}

