/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping.aggregate;

import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.client.task.SMTaskRequestLogDetail;
import com.sun.symon.base.client.task.SMTaskRequestLogEvent;
import com.sun.symon.base.client.task.SMTaskRequestLogFactory;
import com.sun.symon.base.client.task.SMTaskRequestLogManager;
import com.sun.symon.base.client.task.SMTaskRequestLogOperation;
import com.sun.symon.base.console.grouping.CgUtility;
import com.sun.symon.base.utility.UcCommon;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.AbstractList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;

class CgModuleLogFactory
implements SMTaskRequestLogFactory {
    private int focusRow_ = -1;
    private int focusColumn_ = -1;
    private static final int FIRST_COL = 0;
    private static final int ACTION_COL = 1;
    private static final int SCHEDULE_COL = 2;
    private static final int SECURITY_COL = 3;
    private SMTaskRequestLogManager manager_;
    private SMTaskRequestLogDetail[] agents_;
    private Hashtable requestInfo_;
    private JTable table_ = new JTable();
    private Vector tableRows_;
    private String[] colNames_ = new String[]{this.localize("log.domainObj"), this.localize("log.moduleAction"), this.localize("log.moduleSchedule"), this.localize("log.moduleSecurity")};
    static /* synthetic */ Class class$java$lang$Object;

    CgModuleLogFactory() {
    }

    public void setManager(SMTaskRequestLogManager sMTaskRequestLogManager) {
        this.manager_ = sMTaskRequestLogManager;
    }

    public void setData(SMTaskRequestLogDetail[] sMTaskRequestLogDetailArray) {
        this.agents_ = sMTaskRequestLogDetailArray;
        this.table_.getTableHeader().setReorderingAllowed(false);
        this.table_.setCellSelectionEnabled(true);
        this.table_.setModel(new TableModel());
        this.table_.setDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = CgModuleLogFactory.class$("java.lang.Object")) : class$java$lang$Object, new OperationCellRenderer());
        this.table_.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                CgModuleLogFactory.this.cellSelectionChanged();
            }
        });
        this.table_.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                CgModuleLogFactory.this.cellSelectionChanged();
            }
        });
        this.toTable();
    }

    private void cellSelectionChanged() {
        int n = this.table_.getSelectedRow();
        int n2 = this.table_.getSelectedColumn();
        if (n < 0 || n2 < 0) {
            return;
        }
        if (this.focusRow_ == n && this.focusColumn_ == n2) {
            return;
        }
        this.focusRow_ = n;
        this.focusColumn_ = n2;
        SMTaskRequestLogDetail sMTaskRequestLogDetail = this.agents_[this.focusRow_];
        if (sMTaskRequestLogDetail == null) {
            return;
        }
        String string = sMTaskRequestLogDetail.getCellMsg(this.focusColumn_);
        if (string == null) {
            string = "";
        }
        this.manager_.showStatusDetail(string);
    }

    private void toTable() {
        SMTaskRequestLogDetail sMTaskRequestLogDetail;
        this.tableRows_ = new Vector();
        int n = 0;
        while (n < this.agents_.length) {
            sMTaskRequestLogDetail = this.agents_[n];
            this.tableRows_.add(this.toRow(sMTaskRequestLogDetail));
            ++n;
        }
        sMTaskRequestLogDetail = new Vector();
        int n2 = 0;
        while (n2 < this.colNames_.length) {
            sMTaskRequestLogDetail.add(this.colNames_[n2]);
            ++n2;
        }
        TableModel tableModel = (TableModel)this.table_.getModel();
        tableModel.setDataVector(this.tableRows_, (Vector<?>)sMTaskRequestLogDetail);
    }

    private Vector toRow(SMTaskRequestLogDetail sMTaskRequestLogDetail) {
        String[] stringArray = new String[this.colNames_.length];
        String[] stringArray2 = new String[this.colNames_.length];
        this.getStatusAndMsgs(sMTaskRequestLogDetail, stringArray, stringArray2);
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < this.colNames_.length) {
            vector.add(stringArray[n]);
            ++n;
        }
        sMTaskRequestLogDetail.setCellDetailMsgs(stringArray2);
        return vector;
    }

    private void getStatusAndMsgs(SMTaskRequestLogDetail sMTaskRequestLogDetail, String[] stringArray, String[] stringArray2) {
        String string;
        StringBuffer stringBuffer;
        Vector vector = sMTaskRequestLogDetail.getOperations();
        Vector vector2 = new Vector();
        Vector[] vectorArray = new Vector[this.colNames_.length];
        StringBuffer[] stringBufferArray = new StringBuffer[this.colNames_.length];
        int n = 0;
        while (n < this.colNames_.length) {
            vectorArray[n] = new Vector();
            stringBufferArray[n] = new StringBuffer();
            ++n;
        }
        int n2 = 0;
        while (n2 < vector.size()) {
            String string2;
            stringBuffer = (SMTaskRequestLogOperation)vector.get(n2);
            String string3 = stringBuffer.getCommand();
            string = stringBuffer.getUserData();
            Hashtable hashtable = stringBuffer.getResult();
            vector2.add(hashtable.get("status"));
            if (string3.equals("set")) {
                if (string.startsWith("Security")) {
                    vectorArray[3].add(hashtable.get("status"));
                    string2 = this.createCellDetailMsg((SMTaskRequestLogOperation)stringBuffer);
                    if (!string2.equals("")) {
                        if (!stringBufferArray[3].toString().equals("")) {
                            stringBufferArray[3].append("<br><br>");
                        }
                        stringBufferArray[3].append(string2);
                    }
                } else if (string.startsWith("Schedule")) {
                    vectorArray[2].add(hashtable.get("status"));
                    string2 = this.createCellDetailMsg((SMTaskRequestLogOperation)stringBuffer);
                    if (!string2.equals("")) {
                        if (!stringBufferArray[2].toString().equals("")) {
                            stringBufferArray[2].append("<br><br>");
                        }
                        stringBufferArray[2].append(string2);
                    }
                }
            } else {
                vectorArray[1].add(hashtable.get("status"));
                string2 = stringBuffer.getCommand().equals("load") ? this.createCellDetailMsg2((SMTaskRequestLogOperation)stringBuffer) : this.createCellDetailMsg((SMTaskRequestLogOperation)stringBuffer);
                if (!string2.equals("")) {
                    if (!stringBufferArray[1].toString().equals("")) {
                        stringBufferArray[1].append("<br><br>");
                    }
                    stringBufferArray[1].append(string2);
                }
            }
            ++n2;
        }
        stringBuffer = new StringBuffer();
        int n3 = 1;
        while (n3 < this.colNames_.length) {
            stringArray[n3] = this.sumStatus(vectorArray[n3]);
            stringArray2[n3] = stringBufferArray[n3].toString();
            if (stringBuffer.length() != 0 && !stringArray2[n3].equals("")) {
                stringBuffer.append("<br><br>");
            }
            stringBuffer.append(stringArray2[n3]);
            ++n3;
        }
        string = this.sumStatus(vector2);
        stringArray[0] = string + ":" + sMTaskRequestLogDetail.getName() + ":" + sMTaskRequestLogDetail.getPort();
        stringArray2[0] = stringBuffer.toString();
    }

    public void updateScreenByOperation(SMTaskRequestLogEvent sMTaskRequestLogEvent) {
        Object object;
        String string;
        Object object2 = null;
        String string2 = null;
        String string3 = sMTaskRequestLogEvent.getHost();
        String string4 = String.valueOf(sMTaskRequestLogEvent.getPort());
        String string5 = String.valueOf(sMTaskRequestLogEvent.getIndex());
        String string6 = String.valueOf(sMTaskRequestLogEvent.getStartTime());
        String string7 = String.valueOf(sMTaskRequestLogEvent.getStopTime());
        int n = sMTaskRequestLogEvent.getStatus();
        switch (n) {
            case 0: {
                string = "unknown";
                break;
            }
            case 1: {
                string = "OK";
                break;
            }
            case 2: {
                string = "failure";
                string2 = sMTaskRequestLogEvent.getErrorMessage();
                break;
            }
            default: {
                string = "invalidStatus";
            }
        }
        int n2 = -1;
        int n3 = 0;
        while (n3 < this.agents_.length) {
            object = this.agents_[n3];
            if (object.getName().equals(string3) && object.getPort().equals(string4)) {
                n2 = n3;
                object2 = object;
                break;
            }
            ++n3;
        }
        if (n2 == -1) {
            return;
        }
        object = object2.getOperations();
        Iterator iterator = ((AbstractList)object).iterator();
        while (iterator.hasNext()) {
            SMTaskRequestLogOperation sMTaskRequestLogOperation = (SMTaskRequestLogOperation)iterator.next();
            if (!sMTaskRequestLogOperation.getIndex().equals(string5)) continue;
            Hashtable hashtable = sMTaskRequestLogOperation.getResult();
            String string8 = sMTaskRequestLogOperation.getUserData();
            hashtable.put("host", object2.getName());
            hashtable.put("index", string5);
            hashtable.put("status", string);
            hashtable.put("startTime", string6);
            hashtable.put("stopTime", string7);
            int n4 = sMTaskRequestLogOperation.getCommand().equals("set") ? (string8.startsWith("Security") ? 3 : 2) : 1;
            String[] stringArray = new String[this.colNames_.length];
            String[] stringArray2 = new String[this.colNames_.length];
            this.getStatusAndMsgs((SMTaskRequestLogDetail)object2, stringArray, stringArray2);
            object2.setStatus(stringArray[0]);
            object2.setCellDetailMsgs(stringArray2);
            TableModel tableModel = (TableModel)this.table_.getModel();
            tableModel.setValueAt(stringArray[n4], n2, n4);
            tableModel.setValueAt(object2.getStatus(), n2, 0);
            break;
        }
    }

    private String sumStatus(Vector vector) {
        String string = null;
        String string2 = null;
        String string3 = null;
        if (vector.isEmpty()) {
            return "unknown";
        }
        int n = 0;
        while (n < vector.size()) {
            String string4 = (String)vector.get(n);
            if (string4 == null) {
                string3 = "unknown";
            } else {
                if (string4.equals("failure")) {
                    string2 = string4;
                    break;
                }
                if (string4.equals("unknown") || string4 == null) {
                    string3 = string4;
                } else if (string4.equals("OK")) {
                    string = string4;
                }
            }
            ++n;
        }
        String string5 = string2 != null ? string2 : (string3 != null ? string3 : "OK");
        return string5;
    }

    private String createCellDetailMsg(SMTaskRequestLogOperation sMTaskRequestLogOperation) {
        Hashtable hashtable = sMTaskRequestLogOperation.getResult();
        if (hashtable.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = (String)hashtable.get("message");
        String string2 = (String)hashtable.get("startTime");
        String string3 = (String)hashtable.get("stopTime");
        String string4 = (String)hashtable.get("status");
        String string5 = (String)hashtable.get("index");
        String string6 = sMTaskRequestLogOperation.getCommand();
        String string7 = sMTaskRequestLogOperation.getOperand();
        String string8 = sMTaskRequestLogOperation.getValue();
        String string9 = this.localize("log.operand");
        String string10 = this.localize("log.value");
        float f = Long.valueOf(string3) - Long.valueOf(string2);
        String string11 = CgUtility.formatDuration(f);
        stringBuffer.append("<b>" + this.localize("log.operation") + ": </b> ");
        stringBuffer.append(Integer.valueOf(string5) + 1);
        stringBuffer.append("<br><b>" + this.localize("log.result") + ": </b> ");
        if (string4.equals("unknown")) {
            string4 = "";
        } else if (string4.equals("OK")) {
            stringBuffer.append("<font color=#008000>");
            string4 = this.localize("standard.succeeded");
        } else {
            stringBuffer.append("<font color=#FF0000>");
            string4 = this.localize("standard.failed");
        }
        stringBuffer.append(string == null ? string4 : UcInternationalizer.translateKey((String)string, (boolean)false));
        stringBuffer.append("</font>");
        stringBuffer.append("<br><b>" + this.localize("log.command") + ": </b> ");
        stringBuffer.append(string6);
        if (!string6.equals("set")) {
            string9 = this.localize("log.module");
            string10 = this.localize("log.schedule");
        }
        stringBuffer.append("<br><b>" + string9 + ": </b> ");
        stringBuffer.append(string7);
        if (!string8.equals("") && string8 != null) {
            stringBuffer.append("<br><b>" + string10 + ": </b> ");
            stringBuffer.append(string8);
        }
        if (!string4.equals("")) {
            stringBuffer.append("<br><b>" + this.localize("log.duration") + ": </b>" + string11);
        }
        return stringBuffer.toString();
    }

    private String createCellDetailMsg2(SMTaskRequestLogOperation sMTaskRequestLogOperation) {
        Hashtable hashtable = sMTaskRequestLogOperation.getResult();
        if (hashtable.isEmpty()) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = (String)hashtable.get("message");
        String string2 = (String)hashtable.get("startTime");
        String string3 = (String)hashtable.get("stopTime");
        String string4 = (String)hashtable.get("status");
        String string5 = (String)hashtable.get("index");
        String string6 = sMTaskRequestLogOperation.getCommand();
        String string7 = sMTaskRequestLogOperation.getOperand();
        String string8 = sMTaskRequestLogOperation.getValue();
        String string9 = sMTaskRequestLogOperation.getUserData();
        float f = Long.valueOf(string3) - Long.valueOf(string2);
        String string10 = CgUtility.formatDuration(f);
        stringBuffer.append("<b>" + this.localize("log.operation") + ": </b> ");
        stringBuffer.append(Integer.valueOf(string5) + 1);
        stringBuffer.append("<br><b>" + this.localize("log.result") + ": </b> ");
        if (string4.equals("unknown")) {
            string4 = "";
        } else if (string4.equals("OK")) {
            stringBuffer.append("<font color=#008000>");
            string4 = this.localize("standard.succeeded");
        } else {
            stringBuffer.append("<font color=#FF0000>");
            string4 = this.localize("standard.failed");
        }
        stringBuffer.append(string == null ? string4 : UcInternationalizer.translateKey((String)string, (boolean)false));
        stringBuffer.append("</font>");
        stringBuffer.append("<br><b>" + this.localize("log.command") + ": </b> ");
        stringBuffer.append(string6);
        stringBuffer.append("<br><b>" + this.localize("log.module") + ": </b> ");
        stringBuffer.append(string7);
        stringBuffer.append("<br><b>" + this.localize("log.parameters") + ": </b> ");
        if (string9.startsWith("instanceName =")) {
            string9 = "description =" + string9.substring("instanceName =".length() + 1);
        }
        stringBuffer.append(string9);
        if (!string8.equals("") && string8 != null) {
            stringBuffer.append("<br><b>" + this.localize("log.loadTime") + ": </b> ");
            stringBuffer.append(string8);
        }
        if (!string4.equals("")) {
            stringBuffer.append("<br><b>" + this.localize("log.duration") + ": </b>" + string10);
        }
        return stringBuffer.toString();
    }

    public Component getComponent() {
        return this.table_;
    }

    public void cleanup() {
        if (this.agents_ == null || this.agents_.length == 0) {
            return;
        }
        TableModel tableModel = (TableModel)this.table_.getModel();
        tableModel.removeAllRows();
    }

    private String localize(String string) {
        String string2 = CgUtility.getI18nMsg(string);
        if (string2.startsWith("base.") && string2.endsWith(".defaultdomain")) {
            string2 = UcInternationalizer.translateKey((String)("com.sun.symon." + string), (boolean)false);
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class OperationCellRenderer
    extends DefaultTableCellRenderer {
        private Border focusBorder_;
        private Border noFocusBorder_;
        private ImageIcon okIcon_;
        private ImageIcon failIcon_;
        private int focusRow_ = -1;
        private int focusColumn_ = -1;

        public OperationCellRenderer() {
            if (SMConsoleContext.getInstance().getAPIHandle() == null) {
                this.okIcon_ = new ImageIcon("\\log\\OK-CheckMark-16x16.gif");
                this.failIcon_ = new ImageIcon("\\log\\view-log-error.gif");
            } else {
                SMResourceAccess sMResourceAccess = new SMResourceAccess(SMConsoleContext.getInstance().getAPIHandle());
                this.okIcon_ = new ImageIcon(sMResourceAccess.getImage("stdimages/OK-CheckMark-16x16.gif"));
                this.failIcon_ = new ImageIcon(sMResourceAccess.getImage("stdimages/view-log-error.gif"));
            }
            this.setOpaque(true);
            this.setFont(new Font("dialog", 0, 12));
            this.focusBorder_ = BorderFactory.createLineBorder(new Color(102, 102, 153), 1);
            this.noFocusBorder_ = new EmptyBorder(1, 2, 1, 2);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (n2 > 0) {
                this.setHorizontalAlignment(0);
                this.setText(null);
                if (object.toString().equals("OK")) {
                    this.setIcon(this.okIcon_);
                } else if (object.toString().equals("failure")) {
                    this.setIcon(this.failIcon_);
                } else {
                    this.setIcon(null);
                }
            } else {
                this.setHorizontalAlignment(2);
                String string = object.toString();
                int n3 = string.indexOf(":");
                if (n3 != -1) {
                    String string2 = string.substring(0, n3);
                    String string3 = string.substring(n3 + 1);
                    if (string2.equals("OK")) {
                        this.setIcon(this.okIcon_);
                    } else if (string2.equals("failure")) {
                        this.setIcon(this.failIcon_);
                    } else {
                        this.setIcon(null);
                        string3 = "     " + string3;
                    }
                    this.setText(string3);
                } else {
                    this.setText("     " + object.toString());
                    this.setIcon(null);
                }
            }
            if (bl2) {
                this.focusRow_ = n;
                this.focusColumn_ = n2;
                this.setBorder(this.focusBorder_);
            } else {
                this.setBorder(this.noFocusBorder_);
            }
            if ((bl || bl2) && n == this.focusRow_ && this.focusColumn_ == n2) {
                this.setForeground(jTable.getSelectionForeground());
                this.setBackground(jTable.getSelectionBackground());
            } else {
                this.setBackground(UcCommon.getLightGrayColor());
                this.setForeground(jTable.getForeground());
            }
            return this;
        }
    }

    class TableModel
    extends DefaultTableModel {
        public static final String SUCCESS = "OK";
        public static final String FAILURE = "failure";
        public static final String UNKNOWN = "unknown";

        TableModel() {
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void removeAllRows() {
            int n = this.dataVector.size();
            this.dataVector.removeAllElements();
            this.fireTableRowsDeleted(0, n);
        }
    }
}

