/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.grouping;

import com.sun.symon.base.client.console.SMScheduler;
import com.sun.symon.base.client.task.SMTaskRequestData;
import com.sun.symon.base.console.grouping.CgUtility;
import com.sun.symon.base.console.manager.CmConsoleSession;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class CgScheduler
extends JDialog {
    private final int[] repeats_ = new int[]{0, 2, 3, 4, 6, 7, 8};
    private boolean cancel_ = false;
    SMScheduler schedulerPanel_;
    JPanel buttonPanel_ = new JPanel();
    FlowLayout buttonFlowLayout_ = new FlowLayout();
    BorderLayout mainBorderLayout_ = new BorderLayout();
    JPanel buttonInnerPanel_ = new JPanel();
    JButton helpButton_ = new JButton();
    JButton cancelButton_ = new JButton();
    GridLayout buttonInnerGridLayout_ = new GridLayout();
    JButton okButton_ = new JButton();

    public static boolean showScheduler(Frame frame, SMTaskRequestData sMTaskRequestData) {
        CgScheduler cgScheduler = new CgScheduler(frame, sMTaskRequestData);
        ((Component)cgScheduler).setVisible(true);
        if (cgScheduler.isCancelled()) {
            return false;
        }
        SMTaskRequestData sMTaskRequestData2 = cgScheduler.getScheduleData();
        sMTaskRequestData.setStartDate(sMTaskRequestData2.getStartDate());
        sMTaskRequestData.setPeriod(sMTaskRequestData2.getPeriod());
        sMTaskRequestData.setPeriodUnits(sMTaskRequestData2.getPeriodUnits());
        return true;
    }

    public static boolean hasTimePassed(Date date) {
        long l = 86400000L;
        if (new Date().getTime() > date.getTime() + l) {
            CgUtility.showErrorMessage("schedule.startTimePassed");
            return true;
        }
        return false;
    }

    CgScheduler() {
        this((Frame)null, (SMTaskRequestData)null);
    }

    CgScheduler(Frame frame, SMTaskRequestData sMTaskRequestData) {
        super(frame, true);
        this.schedulerPanel_ = sMTaskRequestData != null ? new SMScheduler(false, true, false, sMTaskRequestData.getStartDate() != null) : new SMScheduler(false, true, false, false);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.schedulerPanel_.setSchedulerUnitType(1);
        this.schedulerPanel_.setSchedulerIntervalListMult(this.repeats_);
        this.setScheduleData(sMTaskRequestData);
        this.getRootPane().setDefaultButton(this.okButton_);
        this.cancelButton_.registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgScheduler.this.cancelButton__actionPerformed(actionEvent);
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        this.localize();
        this.pack();
        ((Component)this).setSize(572, 340);
        this.schedulerPanel_.setSchedulerInitialFocus();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this).setLocation((int)(dimension.getWidth() - (double)this.getWidth()) / 2, (int)(dimension.getHeight() - (double)this.getHeight()) / 2);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CgScheduler.this.dispose();
            }
        });
    }

    public boolean isCancelled() {
        return this.cancel_;
    }

    private void setScheduleData(SMTaskRequestData sMTaskRequestData) {
        boolean bl = false;
        if (sMTaskRequestData == null) {
            return;
        }
        Date date = sMTaskRequestData.getStartDate();
        if (date != null) {
            bl = true;
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            this.schedulerPanel_.setSchedulerStartHour(calendar.get(11));
            this.schedulerPanel_.setSchedulerStartMinute(calendar.get(12) / 5 * 5);
        } else {
            date = new Date();
        }
        this.schedulerPanel_.setSchedulerStartDate(date);
        int n = (int)sMTaskRequestData.getPeriod();
        this.schedulerPanel_.setSchedulerIntervalMult(n == 0 ? null : String.valueOf(n));
        switch (sMTaskRequestData.getPeriodUnits()) {
            case 3: {
                int n2 = n == 1 ? 6 : 2;
                this.schedulerPanel_.setSchedulerIntervalMultUnit(n2);
                break;
            }
            case 4: {
                int n3 = n == 1 ? 7 : 3;
                this.schedulerPanel_.setSchedulerIntervalMultUnit(n3);
                break;
            }
            case 5: {
                int n4 = n == 1 ? 8 : 4;
                this.schedulerPanel_.setSchedulerIntervalMultUnit(n4);
                break;
            }
            default: {
                this.schedulerPanel_.setSchedulerIntervalMultUnit(0);
            }
        }
        if (bl) {
            this.schedulerPanel_.updateCalendar();
        }
    }

    public SMTaskRequestData getScheduleData() {
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM d, yyyy");
        Date date = this.schedulerPanel_.getSchedulerStartDate();
        if (date == null) {
            CgUtility.showErrorMessage("schedule.invalidStartDate");
            return null;
        }
        String string = simpleDateFormat.format(date);
        String string2 = " " + this.schedulerPanel_.getSchedulerStartHour() + ":" + this.schedulerPanel_.getSchedulerStartMinute() + ":" + "00";
        if (string2.indexOf("--") >= 0) {
            CgUtility.showErrorMessage("schedule.startTimeRequired");
            return null;
        }
        simpleDateFormat = new SimpleDateFormat("MMMM d, yyyy HH:mm:ss");
        simpleDateFormat.setLenient(false);
        Date date2 = simpleDateFormat.parse(string + string2, new ParsePosition(0));
        if (CgScheduler.hasTimePassed(date2)) {
            return null;
        }
        boolean bl = false;
        int n = 0;
        int n2 = 0;
        switch (this.schedulerPanel_.getSchedulerIntervalMultUnit()) {
            case 0: {
                n2 = 0;
                n = 0;
                break;
            }
            case 2: {
                n2 = 3;
                bl = true;
                break;
            }
            case 3: {
                n2 = 4;
                bl = true;
                break;
            }
            case 4: {
                n2 = 5;
                bl = true;
                break;
            }
            case 6: {
                n2 = 3;
                n = 1;
                break;
            }
            case 7: {
                n2 = 4;
                n = 1;
                break;
            }
            case 8: {
                n2 = 5;
                n = 1;
            }
        }
        if (bl && (n = this.schedulerPanel_.getSchedulerIntervalMult()) < 1) {
            CgUtility.showErrorMessage("schedule.invalidRepeatInterval");
            return null;
        }
        SMTaskRequestData sMTaskRequestData = new SMTaskRequestData();
        sMTaskRequestData.setPeriod((long)n);
        sMTaskRequestData.setStartDate(date2);
        sMTaskRequestData.setPeriodUnits(n2);
        sMTaskRequestData.setScheduled(true);
        return sMTaskRequestData;
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.mainBorderLayout_);
        this.buttonPanel_.setLayout(this.buttonFlowLayout_);
        this.buttonFlowLayout_.setAlignment(2);
        this.schedulerPanel_.setBorder(BorderFactory.createEmptyBorder(10, 10, 0, 10));
        this.schedulerPanel_.setMinimumSize(new Dimension(600, 218));
        this.schedulerPanel_.setPreferredSize(new Dimension(600, 219));
        this.buttonPanel_.setBorder(BorderFactory.createEmptyBorder(5, 10, 10, 10));
        this.helpButton_.setText("help");
        this.helpButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgScheduler.this.helpButton__actionPerformed(actionEvent);
            }
        });
        this.cancelButton_.setText("cancel");
        this.cancelButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgScheduler.this.cancelButton__actionPerformed(actionEvent);
            }
        });
        this.buttonInnerPanel_.setLayout(this.buttonInnerGridLayout_);
        this.buttonInnerGridLayout_.setColumns(3);
        this.buttonInnerGridLayout_.setHgap(5);
        this.okButton_.setText("ok");
        this.okButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CgScheduler.this.okButton__actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)this.buttonPanel_, "South");
        this.buttonPanel_.add((Component)this.buttonInnerPanel_, null);
        this.buttonInnerPanel_.add((Component)this.okButton_, null);
        this.buttonInnerPanel_.add((Component)this.cancelButton_, null);
        this.buttonInnerPanel_.add((Component)this.helpButton_, null);
        this.getContentPane().add((Component)this.schedulerPanel_, "Center");
    }

    private void localize() {
        this.setTitle(CgUtility.getI18nMsg("task.scheduler"));
        this.okButton_.setText(CgUtility.getI18nMsg("message.ok"));
        this.cancelButton_.setText(CgUtility.getI18nMsg("message.cancel"));
        this.helpButton_.setText(CgUtility.getI18nMsg("standard.help"));
        this.helpButton_.setMnemonic(CgUtility.getMnemonic("standard.help.mnemonic"));
    }

    void okButton__actionPerformed(ActionEvent actionEvent) {
        if (this.getScheduleData() == null) {
            return;
        }
        this.dispose();
    }

    void cancelButton__actionPerformed(ActionEvent actionEvent) {
        this.cancel_ = true;
        this.dispose();
    }

    void helpButton__actionPerformed(ActionEvent actionEvent) {
        CmConsoleSession.getInstance().launchHelp("grouping-request-scheduler-help");
    }
}

