/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.awx;

import com.sun.symon.base.console.awx.AwxSplitPane;
import com.sun.symon.base.console.awx.AwxTreeCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;

public class AwxTreeSelector
extends JSplitPane
implements ComponentListener {
    private JTree TheTree = null;
    private Color BranchColour = null;
    private Color LeafColour = null;
    private Color BranchSelectColour = null;
    private Color LeafSelectColour = null;
    private Font BranchFont = null;
    private Font LeafFont = null;
    private Color SelectBackground = null;
    private Dimension LastSize = null;
    private boolean RetainRatio = false;
    private boolean CanSquishLeft = false;
    private boolean CanSquishRight = false;
    private int PendingDividerLocation = -1;
    private double PendingRelDividerLocation = -1.0;
    private int count = 0;
    private boolean firstShown = false;
    private boolean propSet = false;
    private boolean locSet = false;

    AwxTreeSelector(TreeSelectionListener treeSelectionListener, DefaultMutableTreeNode defaultMutableTreeNode) {
        super(1);
        JScrollPane jScrollPane = new JScrollPane();
        this.setLeftComponent(jScrollPane);
        if (this.CanSquishLeft) {
            AwxSplitPane.allowSquish(this, jScrollPane);
        }
        this.TheTree = new JTree(defaultMutableTreeNode);
        this.TheTree.setCellRenderer(new AwxTreeCellRenderer(this));
        this.TheTree.addTreeSelectionListener(treeSelectionListener);
        jScrollPane.getViewport().add(this.TheTree);
        ToolTipManager.sharedInstance().registerComponent(this.TheTree);
        this.addComponentListener(this);
    }

    public Color getDisplayColour(boolean bl, boolean bl2) {
        Color color = null;
        color = bl ? (bl2 ? this.BranchSelectColour : this.BranchColour) : (bl2 ? this.LeafSelectColour : this.LeafColour);
        if (color == null) {
            color = bl2 ? this.getBackground() : this.getForeground();
        }
        return color;
    }

    public Font getDisplayFont(boolean bl) {
        Font font = null;
        font = bl ? this.BranchFont : this.LeafFont;
        if (font == null) {
            font = this.getFont();
        }
        return font;
    }

    public Color getSelectBackground() {
        return this.SelectBackground;
    }

    public JTree getTheTree() {
        return this.TheTree;
    }

    public boolean isOpaque() {
        return false;
    }

    public void setAllowLeftCompact(boolean bl) {
        this.CanSquishLeft = bl;
        Component component = this.getLeftComponent();
        if (this.CanSquishLeft && component != null) {
            AwxSplitPane.allowSquish(this, component);
        }
    }

    public void setAllowRightCompact(boolean bl) {
        this.CanSquishRight = bl;
        Component component = this.getRightComponent();
        if (this.CanSquishRight && component != null) {
            AwxSplitPane.allowSquish(this, component);
        }
    }

    public void setBranchColour(Color color) {
        this.BranchColour = color;
    }

    public void setBranchFont(Font font) {
        this.BranchFont = font;
    }

    public void setBranchSelectColour(Color color) {
        this.BranchSelectColour = color;
    }

    public void setLeafColour(Color color) {
        this.LeafColour = color;
    }

    public void setLeafFont(Font font) {
        this.LeafFont = font;
    }

    public void setLeafSelectColour(Color color) {
        this.LeafSelectColour = color;
    }

    public void setPendingDividerLocation(int n) {
        this.PendingDividerLocation = n;
        this.locSet = true;
    }

    public void setPendingRelDividerLocation(double d) {
        this.PendingRelDividerLocation = d;
        this.propSet = true;
    }

    public void setRetainRatio(boolean bl) {
        this.RetainRatio = bl;
    }

    public void setRightComponent(Component component) {
        if (this.CanSquishRight) {
            AwxSplitPane.allowSquish(this, component);
        }
        int n = this.getDividerLocation();
        super.setRightComponent(component);
        this.setDividerLocation(n);
    }

    public void setSelectBackground(Color color) {
        this.SelectBackground = color;
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        ++this.count;
        if (this.count == 2) {
            if (this.locSet) {
                this.setDividerLocation(this.PendingDividerLocation);
            } else if (this.propSet) {
                this.setDividerLocation(this.PendingRelDividerLocation);
            }
        }
        if (this.LastSize != null && this.RetainRatio) {
            double d = (double)this.getDividerLocation() / (double)(this.LastSize.width - this.getDividerSize());
            if (d < 0.0) {
                d = 0.0;
            }
            if (d > 1.0) {
                d = 1.0;
            }
            this.setDividerLocation(d);
        }
        this.LastSize = this.getSize();
        if (this.LastSize.width <= this.getDividerSize()) {
            this.LastSize = null;
        }
        this.setDividerSize(8);
    }

    public void componentShown(ComponentEvent componentEvent) {
    }
}

