/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.alarms;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.console.alarms.AlarmPanel;
import com.sun.symon.base.console.alarms.CaDataObject;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcListUtil;

class CaFixDataObject
extends CaDataObject {
    public CaFixDataObject(AlarmPanel alarmPanel) throws SMAPIException {
        super(alarmPanel);
        this.fillInMessage();
    }

    public void fillInMessage() throws SMAPIException {
        try {
            this.message = this.request.getSuggestedFixes(this.getUrl());
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showSMAPIexception((String)this.alarmPanel.translate("getFixException"), (SMAPIException)sMAPIException);
            throw sMAPIException;
        }
        this.setDate();
        this.setUser();
        this.setText();
    }

    public boolean addMessage(String string) {
        try {
            this.request.setSuggestedFixes(this.getUrl(), UcListUtil.UnicodeToAscii((String)string));
            this.fillInMessage();
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showSMAPIexception((String)this.alarmPanel.translate("setAlarmFixException"), (SMAPIException)sMAPIException);
            return false;
        }
        return true;
    }

    public boolean removeMessage(int n) {
        try {
            if (n >= this.getCount()) {
                return false;
            }
            this.request.removeSuggestedFix(this.message[n].getMessageId());
            this.fillInMessage();
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showSMAPIexception((String)this.alarmPanel.translate("setAlarmFixException"), (SMAPIException)sMAPIException);
            return false;
        }
        return true;
    }

    public boolean changeMessage(int n, String string) {
        try {
            if (n >= this.getCount()) {
                return false;
            }
            this.request.changeSuggestedFix(this.message[n].getMessageId(), UcListUtil.UnicodeToAscii((String)string));
            this.fillInMessage();
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showSMAPIexception((String)this.alarmPanel.translate("setAlarmFixException"), (SMAPIException)sMAPIException);
            return false;
        }
        return true;
    }

    public boolean isEditable(int n) {
        if (n > this.user.size() - 1 || n < 0) {
            return false;
        }
        return !((String)this.user.get(n)).trim().equals("");
    }
}

