/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.alarms;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.SMRawDataRequest;
import com.sun.symon.base.client.alarm.SMAlarmPageAsyncRequest;
import com.sun.symon.base.client.topology.SMTopologyRequest;
import com.sun.symon.base.console.alarms.AckListener;
import com.sun.symon.base.console.alarms.AlarmData;
import com.sun.symon.base.console.alarms.AlarmPanel;
import com.sun.symon.base.console.alarms.AlarmTable;
import com.sun.symon.base.console.alarms.AlarmTableModel;
import com.sun.symon.base.console.alarms.DeleteAllListener;
import com.sun.symon.base.console.alarms.DeleteListener;
import com.sun.symon.base.console.alarms.FixListener;
import com.sun.symon.base.console.alarms.ModifyListener;
import com.sun.symon.base.console.alarms.NoteListener;
import com.sun.symon.base.console.alarms.RunListener;
import com.sun.symon.base.console.alarms.View;
import com.sun.symon.base.console.alarms.ViewListener;
import com.sun.symon.base.console.awx.AwxServiceManager;
import com.sun.symon.base.console.awx.AwxServiceProvider;
import com.sun.symon.base.utility.UcAgentURL;
import com.sun.symon.base.utility.UcButton;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class AlarmPanel
extends JPanel
implements AwxServiceManager {
    static final Cursor waitCursor = Cursor.getPredefinedCursor(3);
    static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    private AlarmPanel alarmPanel;
    private AlarmTable alarmTable;
    private View view = new View();
    private Frame frame;
    private String alarmUrl;
    private String agentHost;
    private String agentPort;
    private String domainUrl = null;
    private String contextUrl = null;
    private String objectUrl = null;
    private String hostPort = null;
    private String alarmSeverity = null;
    private String exceptionMessage = null;
    private String exception1 = null;
    private String exception2 = null;
    private String requestId = "1";
    private String dateTime;
    private String rule;
    private String start;
    private String end;
    private String ack;
    private String by;
    private JButton ackButton;
    private JButton runButton;
    private JButton refreshButton;
    private JButton optionsButton;
    private JButton firstButton;
    private JButton previousButton;
    private JButton nextButton;
    private JButton lastButton;
    private JPanel startPanel;
    private JPanel endLabelPanel;
    private JPanel endPanel;
    private JPanel ackLabelPanel;
    private JPanel ackPanel;
    private JPanel ruleLabelPanel;
    private JPanel rulePanel;
    private JPanel createTimePanel = new JPanel();
    private JPanel tablePanel;
    private JPanel refreshPanel = null;
    private JPanel totalPanel = null;
    private JPanel morePanel;
    private JLabel refreshValue;
    private JLabel totalValue;
    private JLabel pageValue;
    private JLabel status = null;
    private JLabel startLabel;
    private JLabel endLabel;
    private JLabel ackLabel;
    private JLabel ruleLabel;
    private JLabel ruleId;
    private JComboBox currentBox;
    private JPanel currentBoxSlot;
    private JPopupMenu optionMenu = new JPopupMenu();
    private JScrollPane scrollPane;
    private boolean active = true;
    private boolean firstTime = true;
    private boolean skipRetry = false;
    private boolean clear = false;
    private int currentPage = 1;
    private int lastPage = 1;
    private int totalAlarms = 0;
    private AlarmTableModel tableModel;
    private SMTopologyRequest topRequest = null;
    private SMRawDataRequest rawRequest = null;
    private SMAlarmPageAsyncRequest request = null;
    private CurrentPageListener currentPageListener = null;
    private JMenuItem modify;
    private AgentThread agentThread;
    private AckListener oAckListener_;
    private RunListener oRunListener_;
    private DeleteListener oDeleteListener_;
    private DeleteAllListener oDeleteAllListener_;
    private NoteListener oNoteListener_;
    private FixListener oFixListener_;
    private ViewListener oViewListener_;
    private ModifyListener oModifyListener_;

    Window getAlarmWindow(Component component) {
        Window window = null;
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Window)) continue;
            window = (Window)component;
            break;
        }
        return window;
    }

    Frame getAlarmFrame(Component component) {
        Frame frame = null;
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Frame)) continue;
            frame = (Frame)component;
            break;
        }
        return frame;
    }

    void setClear(boolean bl) {
        this.clear = bl;
    }

    boolean getClear() {
        return this.clear;
    }

    String getRequestId() {
        return this.requestId;
    }

    View getView() {
        return this.view;
    }

    void setView(View view) {
        this.view = view;
    }

    void setPagePanel(boolean bl) {
        this.firstButton.setEnabled(bl);
        this.previousButton.setEnabled(bl);
        this.nextButton.setEnabled(bl);
        this.lastButton.setEnabled(bl);
        this.currentBox.setEnabled(bl);
    }

    int getCurrentPage() {
        return this.currentPage;
    }

    void setCurrentPage(int n) {
        this.currentPage = n;
    }

    int getLastPage() {
        return this.lastPage;
    }

    void setLastPage(int n) {
        this.lastPage = n;
    }

    int getTotalAlarms() {
        return this.totalAlarms;
    }

    void setTotalAlarms(int n) {
        this.totalAlarms = n;
        if (this.totalPanel != null) {
            this.totalPanel.remove(this.totalValue);
            this.getParent().validate();
            this.totalValue = new JLabel(Integer.toString(this.totalAlarms));
            this.totalValue.setFont(this.totalValue.getFont().deriveFont(0));
            this.totalValue.setForeground(Color.black);
            this.totalPanel.add(this.totalValue);
            this.getParent().validate();
        }
        Vector<String> vector = new Vector<String>();
        int n2 = 1;
        while (n2 <= this.lastPage) {
            vector.addElement(Integer.toString(n2));
            ++n2;
        }
        this.currentPageListener.setNewListener();
        this.currentBox = new JComboBox(vector);
        this.currentBox.setPreferredSize(new Dimension(75, 25));
        this.currentBox.setEditable(true);
        this.currentPageListener = new CurrentPageListener();
        this.currentBox.addActionListener(this.currentPageListener);
        this.currentBoxSlot.removeAll();
        this.currentBoxSlot.add(this.currentBox);
        this.currentPageListener.setNewListener(false);
        this.currentBox.setSelectedIndex(0);
    }

    void setRefreshTime() {
        this.refreshPanel.remove(this.refreshValue);
        this.getParent().validate();
        this.refreshValue = this.getCurrentTime();
        this.refreshPanel.add(this.refreshValue);
        this.getParent().validate();
    }

    JLabel getCurrentTime() {
        JLabel jLabel = new JLabel(UcInternationalizer.getFormatedShortDate((Date)new Date()));
        jLabel.setFont(jLabel.getFont().deriveFont(0));
        jLabel.setForeground(Color.black);
        return jLabel;
    }

    AlarmTable getAlarmTable() {
        return this.alarmTable;
    }

    public JLabel getWindowStatusField() {
        return this.status;
    }

    public void setWindowStatusField(Object object) {
        this.status = (JLabel)object;
    }

    public String getDomainUrl() {
        return this.domainUrl;
    }

    public void setDomainUrl(String string) {
        this.domainUrl = string;
    }

    public String getContextUrl() {
        return this.contextUrl;
    }

    public void setContextUrl(String string) {
        this.contextUrl = string;
    }

    public void setObjectUrl(String string) {
        this.objectUrl = string;
    }

    SMAlarmPageAsyncRequest getRequestHandle() {
        return this.request;
    }

    SMRawDataRequest getRawRequestHandle() {
        return this.rawRequest;
    }

    public void setRawDataRequestHandle(SMRawDataRequest sMRawDataRequest) {
        if (this.skipRetry) {
            this.skipRetry = false;
            return;
        }
        this.rawRequest = sMRawDataRequest;
        this.topRequest = new SMTopologyRequest(sMRawDataRequest);
    }

    String getAgentHost() {
        return this.agentHost;
    }

    public void setAgentHost(String string) {
        this.agentHost = new String(string);
        if (this.agentHost.compareTo("") == 0 || this.agentHost == null) {
            UcDialog.showOk((String)this.translate("invalidHostAddress"));
        }
    }

    String getAgentPort() {
        return this.agentPort;
    }

    public void setAgentPort(String string) {
        this.agentPort = new String(string);
        if (this.agentPort.compareTo("") == 0 || this.agentPort == null) {
            UcDialog.showOk((String)this.translate("invalidAgentPort"));
        }
    }

    String getAlarmUrl() {
        return this.alarmUrl;
    }

    public void setRunButtonEnabled(boolean bl) {
        this.runButton.setEnabled(bl);
    }

    void createUrl() {
        UcAgentURL ucAgentURL;
        UcAgentURL ucAgentURL2 = new UcAgentURL(this.contextUrl);
        String string = "snmp://" + ucAgentURL2.getHost() + ":" + ucAgentURL2.getPort() + "/mod/" + ucAgentURL2.getModuleSpec() + "/entityViewTable" + "/entityViewEntry/entityStatus" + ucAgentURL2.getFragment() + "/";
        this.alarmUrl = this.objectUrl != null ? ((ucAgentURL = new UcAgentURL(this.objectUrl)).getModuleSpec().equals("") ? new String("{snmp://" + this.agentHost + ":" + this.agentPort + "/}" + " {" + string + "}") : new String("{snmp://" + this.agentHost + ":" + this.agentPort + "/mod/" + ucAgentURL.getModuleSpec() + "/}" + " {" + string + "}")) : new String("{snmp://" + this.agentHost + ":" + this.agentPort + "/}" + " {" + string + "}");
    }

    public String translate(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.base.console.alarms.AlarmBundle:" + string));
    }

    public void init() {
        try {
            this.hostPort = this.topRequest.getEventMngrFromContext(this.contextUrl);
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showSMAPIexception((String)this.translate("hostPortException"), (SMAPIException)sMAPIException);
        }
        if (this.hostPort == null || this.hostPort.length() == 0) {
            this.hostPort = null;
            this.skipRetry = true;
            UcDialog.showOk((String)this.translate("nullHostPortWarning"));
        }
        try {
            this.request = new SMAlarmPageAsyncRequest(this.rawRequest, this.hostPort);
        }
        catch (SMAPIException sMAPIException) {
            UcDialog.showSMAPIexception((String)this.translate("requestHandleException"), (SMAPIException)sMAPIException);
            this.request = null;
        }
        if (this.request == null) {
            return;
        }
        this.createUrl();
        this.alarmPanel = this;
        this.frame = this.getAlarmFrame(this);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.tableModel = new AlarmTableModel(this);
        Insets insets = new Insets(6, 6, 6, 6);
        this.ackButton = new UcButton((Icon)AlarmTableModel.ackImage, this.translate("acknowledgeTip"));
        this.oAckListener_ = new AckListener(this);
        this.ackButton.addActionListener(this.oAckListener_);
        this.runButton = new UcButton((Icon)AlarmTableModel.runImage, this.translate("runTip"));
        this.oRunListener_ = new RunListener(this);
        this.runButton.addActionListener(this.oRunListener_);
        this.runButton.setEnabled(false);
        this.refreshButton = new UcButton((Icon)AlarmTableModel.refreshOnImage, this.translate("refreshTip"));
        this.optionsButton = new UcButton((Icon)AlarmTableModel.optionsImage, this.translate("optionsTip"));
        JMenuItem jMenuItem = new JMenuItem(this.translate("view"));
        JMenuItem jMenuItem2 = new JMenuItem(this.translate("delete"));
        JMenuItem jMenuItem3 = new JMenuItem(this.translate("deleteAll"));
        this.modify = new JMenuItem(this.translate("modify"));
        this.modify.setEnabled(false);
        JMenuItem jMenuItem4 = new JMenuItem(this.translate("note"));
        JMenuItem jMenuItem5 = new JMenuItem(this.translate("viewFix"));
        jMenuItem.setMnemonic(this.translate("view.mnemonic").charAt(0));
        jMenuItem2.setMnemonic(this.translate("delete.mnemonic").charAt(0));
        jMenuItem3.setMnemonic(this.translate("deleteAll.mnemonic").charAt(0));
        jMenuItem4.setMnemonic(this.translate("note.mnemonic").charAt(0));
        this.modify.setMnemonic(this.translate("modify.mnemonic").charAt(0));
        jMenuItem5.setMnemonic(this.translate("viewFix.mnemonic").charAt(0));
        this.optionMenu.add(jMenuItem);
        this.optionMenu.add(jMenuItem2);
        this.optionMenu.add(jMenuItem3);
        this.optionMenu.add(this.modify);
        this.optionMenu.add(jMenuItem4);
        this.optionMenu.add(jMenuItem5);
        this.optionsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JButton jButton = (JButton)actionEvent.getSource();
                Dimension dimension = jButton.getSize();
                AlarmPanel.this.optionMenu.show(jButton, 0, (int)dimension.getHeight());
            }
        });
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(this.ackButton);
        jToolBar.add(this.runButton);
        jToolBar.add(this.refreshButton);
        jToolBar.addSeparator();
        jToolBar.add(this.optionsButton);
        gridBagConstraints.insets = new Insets(14, 11, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        this.add((Component)jToolBar, gridBagConstraints);
        this.refreshPanel = new JPanel(new FlowLayout(0, 3, 0));
        this.refreshPanel.add(new JLabel(this.translate("lastRefresh")));
        this.refreshValue = this.getCurrentTime();
        this.refreshPanel.add(this.refreshValue);
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        gridBagConstraints.gridwidth = 0;
        this.add((Component)this.refreshPanel, gridBagConstraints);
        this.tablePanel = new JPanel(new GridBagLayout());
        this.tablePanel.setBackground(Color.white);
        JPanel jPanel = new JPanel(new FlowLayout(0, 6, 0));
        jPanel.setBackground(Color.white);
        jPanel.add(new JLabel(this.translate("current")));
        this.currentBox = new JComboBox();
        this.currentBox.setPreferredSize(new Dimension(75, 25));
        this.currentBox.setEditable(true);
        this.currentBoxSlot = new JPanel();
        this.currentBoxSlot.setBackground(Color.white);
        this.currentBoxSlot.add(this.currentBox);
        jPanel.add(this.currentBoxSlot);
        jPanel.add(new JLabel(" "));
        this.firstButton = new UcButton((Icon)AlarmTableModel.firstImage, this.translate("firstToolTip"));
        this.firstButton.setActionCommand("first");
        this.firstButton.setMargin(new Insets(2, 3, 2, 3));
        class PageListener
        implements ActionListener {
            private final /* synthetic */ AlarmPanel this$0;

            PageListener(AlarmPanel alarmPanel) {
                this.this$0 = alarmPanel;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (string.compareTo("first") == 0) {
                    AlarmPanel.access$202(this.this$0, 1);
                } else if (string.compareTo("previous") == 0) {
                    AlarmPanel.access$206(this.this$0);
                } else if (string.compareTo("next") == 0) {
                    AlarmPanel.access$204(this.this$0);
                } else {
                    AlarmPanel.access$202(this.this$0, AlarmPanel.access$500(this.this$0));
                }
                if (AlarmPanel.access$200(this.this$0) < 1) {
                    UcDialog.showOk((String)this.this$0.translate("thisIsFirst"));
                    AlarmPanel.access$202(this.this$0, 1);
                    return;
                }
                if (AlarmPanel.access$200(this.this$0) > AlarmPanel.access$500(this.this$0)) {
                    UcDialog.showOk((String)this.this$0.translate("thisIsLast"));
                    AlarmPanel.access$202(this.this$0, AlarmPanel.access$500(this.this$0));
                    return;
                }
                AlarmPanel.access$000(this.this$0).setSelectedIndex(AlarmPanel.access$200(this.this$0) - 1);
            }
        }
        this.firstButton.addActionListener(new PageListener(this));
        jPanel.add(this.firstButton);
        this.previousButton = new UcButton((Icon)AlarmTableModel.prevImage, this.translate("previousToolTip"));
        this.previousButton.setMargin(new Insets(2, 3, 2, 3));
        this.previousButton.addActionListener(new PageListener(this));
        this.previousButton.setActionCommand("previous");
        jPanel.add(this.previousButton);
        this.nextButton = new UcButton((Icon)AlarmTableModel.nextImage, this.translate("nextToolTip"));
        this.nextButton.setMargin(new Insets(2, 3, 2, 3));
        this.nextButton.setActionCommand("next");
        this.nextButton.addActionListener(new PageListener(this));
        jPanel.add(this.nextButton);
        this.lastButton = new UcButton((Icon)AlarmTableModel.lastImage, this.translate("lastToolTip"));
        this.lastButton.setMargin(new Insets(2, 3, 2, 3));
        this.lastButton.setToolTipText(this.translate("lastToolTip"));
        this.lastButton.setActionCommand("last");
        this.lastButton.addActionListener(new PageListener(this));
        jPanel.add(this.lastButton);
        gridBagConstraints.insets = new Insets(11, 5, 0, 0);
        gridBagConstraints.gridwidth = 0;
        this.tablePanel.add((Component)jPanel, gridBagConstraints);
        this.totalPanel = new JPanel(new FlowLayout(0, 3, 0));
        this.totalPanel.setBackground(Color.white);
        this.totalPanel.add(new JLabel(this.translate("totalAlarms")));
        this.totalValue = new JLabel(Integer.toString(this.totalAlarms));
        this.totalValue.setFont(this.totalValue.getFont().deriveFont(0));
        this.totalValue.setForeground(Color.black);
        this.totalPanel.add(this.totalValue);
        gridBagConstraints.insets = new Insets(7, 8, 0, 0);
        gridBagConstraints.gridwidth = 0;
        this.tablePanel.add((Component)this.totalPanel, gridBagConstraints);
        this.alarmTable = new AlarmTable(this.tableModel);
        this.alarmTable.setAlarmPanel(this);
        this.alarmTable.init();
        this.alarmTable.selectAlarms();
        this.currentPageListener = new CurrentPageListener();
        this.currentBox.addActionListener(this.currentPageListener);
        this.oDeleteListener_ = new DeleteListener(this);
        jMenuItem2.addActionListener(this.oDeleteListener_);
        this.oDeleteAllListener_ = new DeleteAllListener(this);
        jMenuItem3.addActionListener(this.oDeleteAllListener_);
        this.oNoteListener_ = new NoteListener(this, this.frame);
        jMenuItem4.addActionListener(this.oNoteListener_);
        this.oFixListener_ = new FixListener(this, this.frame);
        jMenuItem5.addActionListener(this.oFixListener_);
        this.scrollPane = new JScrollPane(this.alarmTable, 20, 30);
        this.scrollPane.setBorder(new EtchedBorder());
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(1, 11, 11, 11);
        this.tablePanel.add((Component)this.scrollPane, gridBagConstraints);
        this.tablePanel.setBorder(new EtchedBorder());
        gridBagConstraints.insets = new Insets(0, 11, 0, 11);
        this.add((Component)this.tablePanel, gridBagConstraints);
        this.oViewListener_ = new ViewListener(this, this.frame);
        jMenuItem.addActionListener(this.oViewListener_);
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AlarmPanel.this.setClear(true);
                AlarmPanel.this.alarmTable.selectAlarms();
                if (AlarmPanel.this.agentThread.isTimeout()) {
                    AlarmPanel.this.agentThread = new AgentThread(AlarmPanel.this.rawRequest, AlarmPanel.this.agentHost, AlarmPanel.this.agentPort);
                }
            }
        });
        JSeparator jSeparator = new JSeparator();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        this.morePanel = new JPanel(new GridBagLayout());
        this.morePanel.setBorder(new TitledBorder(new EtchedBorder(), this.translate("alarmInfo")));
        this.endLabel = new JLabel(this.translate("alarmEnded"));
        this.ackLabel = new JLabel(this.translate("alarmAcked"));
        this.ruleLabel = new JLabel(this.translate("rule"));
        this.by = new String(" " + this.translate("by") + " ");
        this.endLabelPanel = new JPanel(new FlowLayout(2, 0, 0));
        this.endLabelPanel.add(this.endLabel);
        this.endPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.ackLabelPanel = new JPanel(new FlowLayout(2, 0, 0));
        this.ackLabelPanel.add(this.ackLabel);
        this.ackPanel = new JPanel(new FlowLayout(0, 0, 0));
        this.ruleLabelPanel = new JPanel(new FlowLayout(2, 0, 0));
        this.ruleLabelPanel.add(this.ruleLabel);
        this.rulePanel = new JPanel(new FlowLayout(0, 0, 0));
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 1;
        this.morePanel.add((Component)this.endLabelPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 3, 0, 12);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        this.morePanel.add((Component)this.endPanel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(3, 12, 0, 0);
        gridBagConstraints.anchor = 12;
        gridBagConstraints.gridwidth = 1;
        this.morePanel.add((Component)this.ackLabelPanel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(3, 3, 0, 12);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        this.morePanel.add((Component)this.ackPanel, gridBagConstraints);
        gridBagConstraints.insets = new Insets(7, 9, 8, 8);
        this.add((Component)this.morePanel, gridBagConstraints);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
            }
        });
        this.getAccessibleContext().setAccessibleDescription(UcInternationalizer.translateKey((String)"com.sun.symon.base.console.AccessibleDescriptions:alarmsTab.description"));
        this.agentThread = new AgentThread(this.rawRequest, this.agentHost, this.agentPort);
    }

    void updateMore(AlarmData alarmData) {
        this.endPanel.removeAll();
        this.ackPanel.removeAll();
        this.rulePanel.removeAll();
        this.getParent().validate();
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 1, Locale.getDefault());
        dateFormat.setTimeZone(TimeZone.getDefault());
        if (alarmData.endTime != 0L) {
            this.endPanel.add(new JLabel(dateFormat.format(new Date(alarmData.endTime))));
            this.endLabel.setEnabled(true);
        }
        if (alarmData.getAckTime() > 0L) {
            String string = dateFormat.format(new Date(alarmData.getAckTime()));
            String string2 = this.by.concat(alarmData.getAckUser());
            this.ackPanel.add(new JLabel(string.concat(string2)));
            this.ackLabel.setEnabled(true);
        } else if (alarmData.getAckTime() == -1L) {
            this.ackPanel.add(new JLabel(this.translate("pending")));
            this.ackLabel.setEnabled(true);
        }
        if (alarmData.ruleId != null && alarmData.ruleId.length() > 0) {
            this.ruleId = new JLabel(alarmData.ruleId);
            this.rulePanel.add(this.ruleId);
            this.ruleLabel.setEnabled(true);
        }
        this.getParent().validate();
    }

    boolean isActive() {
        return this.active;
    }

    void setWait(boolean bl) {
        Window window = this.getAlarmWindow(this);
        Frame frame = this.getAlarmFrame(this);
        this.active = bl;
        Cursor cursor = bl ? waitCursor : defaultCursor;
        this.setCursor(cursor);
        frame.setCursor(cursor);
        window.setCursor(cursor);
    }

    public void registerServiceProvider(AwxServiceProvider awxServiceProvider) {
        AwxServiceProvider awxServiceProvider2 = null;
        awxServiceProvider2 = awxServiceProvider;
    }

    public void cleanUp() {
        try {
            if (this.request != null) {
                this.request.closeConnection(this.requestId);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.request = null;
        this.rawRequest = null;
        this.oAckListener_.cleanUp();
        this.oRunListener_.cleanUp();
        this.oDeleteListener_.cleanUp();
        this.oDeleteAllListener_.cleanUp();
        this.oNoteListener_.cleanUp();
        this.oFixListener_.cleanUp();
        this.oViewListener_.cleanUp();
        if (this.oModifyListener_ != null) {
            this.oModifyListener_.cleanUp();
        }
        this.alarmPanel = null;
    }

    private void enableModifyAction() {
        if (!this.modify.isEnabled()) {
            this.modify.setEnabled(true);
            this.oModifyListener_ = new ModifyListener(this, this.frame);
            this.modify.addActionListener(this.oModifyListener_);
        }
    }

    public void clearFootMessage() {
        this.endPanel.removeAll();
        this.ackPanel.removeAll();
        this.rulePanel.removeAll();
    }

    static /* synthetic */ int access$206(AlarmPanel alarmPanel) {
        return --alarmPanel.currentPage;
    }

    static /* synthetic */ int access$204(AlarmPanel alarmPanel) {
        return ++alarmPanel.currentPage;
    }

    static /* synthetic */ int access$500(AlarmPanel alarmPanel) {
        return alarmPanel.lastPage;
    }

    class AgentThread
    extends Thread {
        SMRawDataRequest req_;
        String host_;
        int port_;
        boolean timeout_ = false;

        AgentThread(SMRawDataRequest sMRawDataRequest, String string, String string2) {
            this.req_ = sMRawDataRequest;
            this.host_ = string;
            this.port_ = Integer.parseInt(string2);
            this.start();
        }

        public void run() {
            try {
                String string = AlarmPanel.this.rawRequest.getAgentVersion(this.host_, this.port_, "overall");
                if (!string.startsWith("2")) {
                    AlarmPanel.this.enableModifyAction();
                }
            }
            catch (SMAPIException sMAPIException) {
                this.timeout_ = true;
                return;
            }
        }

        public boolean isTimeout() {
            return this.timeout_;
        }
    }

    class CurrentPageListener
    implements ActionListener {
        boolean newCurrentPageListener = true;

        CurrentPageListener() {
        }

        public void setNewListener() {
            this.newCurrentPageListener = true;
        }

        public void setNewListener(boolean bl) {
            this.newCurrentPageListener = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.newCurrentPageListener) {
                this.newCurrentPageListener = false;
                return;
            }
            int n = AlarmPanel.this.currentBox.getSelectedIndex();
            if (n == -1 || AlarmPanel.this.totalAlarms == 0) {
                return;
            }
            AlarmPanel.this.currentPage = n + 1;
            AlarmPanel.this.alarmTable.getPageOfAlarms(AlarmPanel.this.currentPage);
        }
    }
}

