/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.apps.dr.console.presentation;

import com.sun.symon.apps.dr.console.presentation.DrException;
import com.sun.symon.apps.dr.console.presentation.SymonDrTable;
import com.sun.symon.base.utility.UcListUtil;
import java.awt.Font;
import java.awt.FontMetrics;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class DrJFCTableModel
extends AbstractTableModel {
    String[][] tableData;
    String[] columnNames;
    boolean[] columnVisible;
    int[] columnPosition;
    private int rowCount = 0;
    private int columnCount = 0;
    SymonDrTable parent;

    public DrJFCTableModel(SymonDrTable symonDrTable, String[] stringArray, boolean[] blArray, int[] nArray) throws DrException {
        this.parent = symonDrTable;
        if (stringArray.length != blArray.length || stringArray.length != nArray.length) {
            throw new DrException("the members in each of the arrays should be same");
        }
        this.columnNames = stringArray;
        this.columnVisible = blArray;
        this.columnPosition = nArray;
    }

    public DrJFCTableModel() {
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public String getColumnName(int n) {
        return this.parent.getI18NString(this.columnNames[n]);
    }

    public String getInternalColumnName(int n) {
        return this.columnNames[n];
    }

    public boolean isColumnVisible(int n) {
        return this.columnVisible[n];
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public int getColumnWidth(Font font, int n) {
        FontMetrics fontMetrics = this.parent.getFontMetrics(font);
        int n2 = fontMetrics.stringWidth(this.getColumnName(n));
        int n3 = 0;
        while (n3 < this.rowCount) {
            int n4 = fontMetrics.stringWidth(this.getStringAt(n3, n));
            if (n4 > n2) {
                n2 = n4;
            }
            ++n3;
        }
        if (n2 == 0) {
            return 75;
        }
        return n2 + 10;
    }

    public Object getValueAt(int n, int n2) {
        if (n2 < 0 || n2 >= this.columnCount) {
            return null;
        }
        if (n < 0 || n >= this.rowCount) {
            return null;
        }
        if (this.columnNames[n2].equals("Information")) {
            Vector vector = new Vector();
            UcListUtil.decomposeList((String)this.tableData[n][n2], vector);
            if (vector == null || vector.size() == 0) {
                return this.tableData[n][n2];
            }
            return vector.elementAt(0).toString();
        }
        return this.tableData[n][n2];
    }

    public String getStringAt(int n, int n2) {
        if (n < 0 || n >= this.rowCount || n2 < 0 || n2 >= this.columnCount) {
            return null;
        }
        return this.tableData[n][n2];
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setTableData(String[][] stringArray) throws DrException {
        if (stringArray == null) {
            throw new DrException("Null Data");
        }
        if (stringArray.length == 0) {
            throw new DrException("No rows in the data");
        }
        if (this.columnNames.length != stringArray[0].length) {
            throw new DrException("Columns Number in the data does not match with the number of column in the table");
        }
        this.tableData = stringArray;
        this.rowCount = stringArray.length;
        this.columnCount = stringArray[0].length;
    }

    void setValueAt(int n, int n2, String string) {
        this.tableData[n][n2] = string;
    }
}

