/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.discovery.console.presentation;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.client.console.SMScheduler;
import com.sun.symon.base.utility.UcDialog;
import com.sun.symon.base.utility.UcInternationalizer;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.base.utility.UcURL;
import com.sun.symon.tools.discovery.console.presentation.DiscoverConfirmDialog;
import com.sun.symon.tools.discovery.console.presentation.DiscoverGUIException;
import com.sun.symon.tools.discovery.console.presentation.DiscoverPanel;
import com.sun.symon.tools.discovery.console.presentation.DiscoverRequest;
import com.sun.symon.tools.discovery.console.presentation.IntegerTextField;
import com.sun.symon.tools.discovery.console.presentation.IpAddressTextField;
import com.sun.symon.tools.discovery.console.presentation.NameTextField;
import com.sun.symon.tools.discovery.console.presentation.RequestFilterPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class RequestEditDialog
extends JDialog
implements ItemListener {
    public static final int TIMEOUT_MAXIMUM = 3600;
    public static final int RETRIES_MAXIMUM = 15;
    String operation = null;
    DiscoverRequest request = null;
    SMScheduler sched;
    JScrollPane monitorPanel;
    JScrollPane discoverPanel;
    JScrollPane prefPanel;
    JScrollPane filterPanel;
    RequestFilterPanel requestFilterPanel;
    JPanel buttonPanel;
    JPanel discoverNamePanel;
    JPanel discoverTopologyPanel;
    JPanel discoverPortPanel;
    JPanel discoverFilterPanel;
    JLabel discoverNameLabel;
    NameTextField discoverNameTextField;
    IntegerTextField symonPortTextField;
    JCheckBox defaultPortCheckBox;
    DiscoverPanel parent;
    JTextArea messageText;
    JButton okbut;
    JButton cancelbut;
    JCheckBox loggingCheckBox;
    JCheckBox enableSched;
    JLabel startTimeLabel;
    JTextField startTimeTextField;
    JLabel scheduleLabel;
    JComboBox scheduleComboBox;
    private boolean editSched = false;
    private JLabel dTopMethLabel;
    private JComboBox dTopMethComboBox;
    private JLabel dTopStartIpLabel;
    private JLabel dTopStartIpTextLabel;
    private IpAddressTextField dTopStartIpTextField;
    private JLabel dTopEndIpLabel;
    private IpAddressTextField dTopEndIpTextField;
    private JLabel dTopNetmaskLabel;
    private IpAddressTextField dTopNetmaskTextField;
    private JLabel dTopNumHopsLabel;
    private IntegerTextField dTopNumHopsTextField;
    private JLabel snmpCommunityLabel;
    private NameTextField snmpCommunityTextField;
    private JLabel pingTimeoutLabel;
    private IntegerTextField pingTimeoutTextField;
    private JLabel pingRetriesLabel;
    private IntegerTextField pingRetriesTextField;
    private JLabel snmpTimeoutLabel;
    private IntegerTextField snmpTimeoutTextField;
    private JLabel snmpRetriesLabel;
    private IntegerTextField snmpRetriesTextField;
    private JLabel maxHostsLabel;
    private IntegerTextField maxHostsTextField;
    private JLabel maxHostDiscoverLabel;
    private IntegerTextField maxHostDiscoverTextField;
    private DiscoverRequest originalRequest = null;
    private DiscoverConfirmDialog confirmDialog = null;

    String tran(String string) {
        return UcInternationalizer.translateKey((String)("com.sun.symon.tools.discovery.console.presentation.Discovery:" + string));
    }

    public RequestEditDialog(DiscoverPanel discoverPanel, DiscoverRequest discoverRequest, String string) {
        super(discoverPanel.getParentFrame());
        this.parent = discoverPanel;
        this.operation = string;
        this.setModal(true);
        if (this.operation.equals("add")) {
            this.setTitle(this.parent.getI18NString("New_Discover_Request"));
            this.request = new DiscoverRequest(this.parent, this.parent.getDomain());
        } else if (this.operation.equals("duplicate")) {
            this.setTitle(this.parent.getI18NString("New_Discover_Request"));
            this.request = new DiscoverRequest(this.parent, discoverRequest);
        } else if (this.operation.equals("edit")) {
            this.originalRequest = new DiscoverRequest(this.parent, discoverRequest);
            this.originalRequest.setId(discoverRequest.getId());
            this.request = discoverRequest;
            this.setTitle(MessageFormat.format(this.parent.getI18NString("Edit_Discover_Request_Id_"), new String(discoverRequest.getId())));
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                RequestEditDialog.this.parent.closeRequestDialog();
            }
        });
    }

    public boolean init() {
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.monitorPanel = new JScrollPane(this.buildMonitorPanel());
        this.discoverPanel = new JScrollPane(this.buildDiscoverPanel());
        this.prefPanel = new JScrollPane(this.buildPrefPanel());
        this.okbut = new JButton(this.parent.getI18NString("OK"));
        this.cancelbut = new JButton(this.parent.getI18NString("Close"));
        this.cancelbut.setMnemonic(this.parent.getI18NString("Close.mnemonic").charAt(0));
        try {
            this.requestFilterPanel = new RequestFilterPanel(this.parent, this.request);
        }
        catch (SMAPIException sMAPIException) {
            JOptionPane.showMessageDialog(this.parent, sMAPIException.getMessage(), null, 2);
            return false;
        }
        this.filterPanel = new JScrollPane(this.requestFilterPanel);
        this.buttonPanel = this.buildButtonPanel();
        this.discoverPanel.getAccessibleContext().setAccessibleDescription(this.parent.getI18NString("Discover"));
        this.prefPanel.getAccessibleContext().setAccessibleDescription(this.parent.getI18NString("Preferences"));
        this.filterPanel.getAccessibleContext().setAccessibleDescription(this.parent.getI18NString("Filters"));
        this.monitorPanel.getAccessibleContext().setAccessibleDescription(this.parent.getI18NString("Scheduling"));
        jTabbedPane.addTab(this.parent.getI18NString("Discover"), null, this.discoverPanel);
        jTabbedPane.addTab(this.parent.getI18NString("Preferences"), null, this.prefPanel);
        jTabbedPane.addTab(this.parent.getI18NString("Filters"), null, this.filterPanel);
        jTabbedPane.addTab(this.parent.getI18NString("Scheduling"), null, this.monitorPanel);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(20, 20));
        jPanel.add("South", this.buttonPanel);
        jPanel.add("Center", jTabbedPane);
        this.getContentPane().add(jPanel);
        this.getRootPane().setDefaultButton(this.okbut);
        this.setLocationRelativeTo(this.parent);
        this.pack();
        this.sched.setSchedulerInitialFocus();
        return true;
    }

    private JPanel buildMonitorPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMMM d, yyyy");
        int[] nArray = new int[]{5, 6, 7, 8};
        this.editSched = this.request.getMonitoring();
        this.sched = new SMScheduler(false, false, false, this.editSched);
        this.sched.setSchedulerIntervalList(nArray);
        String string = this.request.getRepeatInterval();
        if (string.compareTo("hourly") == 0) {
            this.sched.setSchedulerIntervalUnit(5);
        } else if (string.compareTo("daily") == 0) {
            this.sched.setSchedulerIntervalUnit(6);
        } else if (string.compareTo("weekly") == 0) {
            this.sched.setSchedulerIntervalUnit(7);
        } else if (string.compareTo("monthly") == 0) {
            this.sched.setSchedulerIntervalUnit(8);
        } else {
            this.sched.setSchedulerIntervalUnit(0);
        }
        if (this.editSched) {
            this.sched.setSchedulerStartDate(new Date(this.request.getTimeval()));
            string = this.request.getStartingTime();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
            this.sched.setSchedulerStartHour(stringTokenizer.nextToken());
            this.sched.setSchedulerStartMinute(stringTokenizer.nextToken());
            this.sched.updateCalendar();
        } else {
            this.sched.enableAll(false);
        }
        this.enableSched = new JCheckBox(this.parent.getI18NString("scheduleRequest"));
        this.enableSched.setMnemonic(this.parent.getI18NString("scheduleRequest.mnemonic").charAt(0));
        this.enableSched.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                RequestEditDialog.this.sched.enableAll(itemEvent.getStateChange() == 1);
                RequestEditDialog.this.sched.setSchedulerInitialFocus();
            }
        });
        this.enableSched.setSelected(this.editSched);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        jPanel.add((Component)this.enableSched, gridBagConstraints);
        gridBagConstraints.insets = new Insets(12, 12, 300, 12);
        jPanel.add((Component)this.sched, gridBagConstraints);
        return jPanel;
    }

    private JPanel buildDiscoverPanel() {
        JPanel jPanel = new JPanel();
        this.discoverNamePanel = new JPanel();
        this.discoverNamePanel.setLayout(new GridLayout(1, 2, 20, 20));
        this.discoverNameLabel = new JLabel(this.parent.getI18NString("Request_Namecolon"));
        this.discoverNameLabel.setHorizontalAlignment(4);
        this.discoverNameTextField = new NameTextField("", this.parent);
        this.discoverNameTextField.setText(this.request.getName());
        this.discoverNameTextField.setName("Request Name");
        this.discoverNameLabel.setDisplayedMnemonic(this.parent.getI18NString("Request_Namecolon.mnemonic").charAt(0));
        this.discoverNameLabel.setLabelFor(this.discoverNameTextField);
        this.discoverNamePanel.add(this.discoverNameLabel);
        this.discoverNamePanel.add(this.discoverNameTextField);
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.parent.getI18NString("Description"));
        this.discoverNamePanel.setBorder(titledBorder);
        this.discoverTopologyPanel = this.buildDiscoverTopologyPanel();
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(this.parent.getI18NString("Method"));
        this.discoverTopologyPanel.setBorder(titledBorder2);
        this.discoverPortPanel = this.buildDiscoverPortPanel();
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder(this.parent.getI18NString("Ports"));
        this.discoverPortPanel.setBorder(titledBorder3);
        this.showTopologyDiscoveryOptions(this.request.getDiscoverTopologyMethod());
        jPanel.setLayout(new BorderLayout(20, 20));
        jPanel.add("North", this.discoverNamePanel);
        jPanel.add("Center", this.discoverTopologyPanel);
        jPanel.add("South", this.discoverPortPanel);
        JPanel jPanel2 = new JPanel();
        Border border = BorderFactory.createEmptyBorder(25, 25, 25, 25);
        jPanel2.setBorder(border);
        jPanel2.setLayout(new BorderLayout(20, 20));
        jPanel2.add("North", jPanel);
        return jPanel2;
    }

    private JPanel buildPrefPanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 2, 20, 20));
        jPanel3.setLayout(new GridLayout(3, 2, 20, 20));
        jPanel4.setLayout(new GridLayout(2, 2, 20, 20));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(this.parent.getI18NString("Logging"));
        jPanel.setBorder(titledBorder);
        TitledBorder titledBorder2 = BorderFactory.createTitledBorder(this.parent.getI18NString("PING"));
        jPanel2.setBorder(titledBorder2);
        TitledBorder titledBorder3 = BorderFactory.createTitledBorder(this.parent.getI18NString("SNMP"));
        jPanel3.setBorder(titledBorder3);
        TitledBorder titledBorder4 = BorderFactory.createTitledBorder(this.parent.getI18NString("General"));
        jPanel4.setBorder(titledBorder4);
        this.loggingCheckBox = new JCheckBox(this.parent.getI18NString("Log_discover_request_progress?"));
        this.loggingCheckBox.setSelected(this.request.getLogging());
        this.loggingCheckBox.setMnemonic(this.parent.getI18NString("Log_discover_request_progress?.mnemonic").charAt(0));
        this.pingTimeoutLabel = new JLabel(this.parent.getI18NString("Timeout(sec.)colon"));
        this.pingTimeoutLabel.setHorizontalAlignment(4);
        this.pingTimeoutTextField = new IntegerTextField(this.request.getPingTimeout(), 5);
        this.pingTimeoutLabel.setDisplayedMnemonic(this.parent.getI18NString("Timeout(sec.)colon.mnemonic").charAt(0));
        this.pingTimeoutLabel.setLabelFor(this.pingTimeoutTextField);
        this.pingRetriesLabel = new JLabel(this.parent.getI18NString("Retriescolon"));
        this.pingRetriesLabel.setHorizontalAlignment(4);
        this.pingRetriesTextField = new IntegerTextField(this.request.getPingRetries(), 5);
        this.pingRetriesLabel.setDisplayedMnemonic(this.parent.getI18NString("Retriescolon.mnemonic").charAt(0));
        this.pingRetriesLabel.setLabelFor(this.pingRetriesTextField);
        this.snmpTimeoutLabel = new JLabel(this.parent.getI18NString("Timeout(sec.)colon"));
        this.snmpTimeoutLabel.setHorizontalAlignment(4);
        this.snmpTimeoutTextField = new IntegerTextField(this.request.getSnmpTimeout(), 5);
        this.snmpTimeoutLabel.setDisplayedMnemonic(this.parent.getI18NString("Timeout(sec.)colon.mnemonic").charAt(0));
        this.snmpTimeoutLabel.setLabelFor(this.snmpTimeoutTextField);
        this.snmpRetriesLabel = new JLabel(this.parent.getI18NString("Retriescolon"));
        this.snmpRetriesLabel.setHorizontalAlignment(4);
        this.snmpRetriesTextField = new IntegerTextField(this.request.getSnmpRetries(), 5);
        this.snmpRetriesLabel.setDisplayedMnemonic(this.parent.getI18NString("Retriescolon.mnemonic").charAt(0));
        this.snmpRetriesLabel.setLabelFor(this.snmpRetriesTextField);
        this.maxHostsLabel = new JLabel(this.parent.getI18NString("Maximum_Hostscolon"));
        this.maxHostsLabel.setHorizontalAlignment(4);
        this.maxHostsTextField = new IntegerTextField(this.request.getMaxHosts(), 9);
        this.maxHostsLabel.setDisplayedMnemonic(this.parent.getI18NString("Maximum_Hostscolon.mnemonic").charAt(0));
        this.maxHostsLabel.setLabelFor(this.maxHostsTextField);
        this.maxHostDiscoverLabel = new JLabel(this.parent.getI18NString("Maximum_Time(sec.)colon"));
        this.maxHostDiscoverLabel.setHorizontalAlignment(4);
        this.maxHostDiscoverTextField = new IntegerTextField(this.request.getMaxDiscoveryTime(), 9);
        this.maxHostDiscoverLabel.setDisplayedMnemonic(this.parent.getI18NString("Maximum_Time(sec.)colon.mnemonic").charAt(0));
        this.maxHostDiscoverLabel.setLabelFor(this.maxHostDiscoverTextField);
        this.snmpCommunityLabel = new JLabel(this.parent.getI18NString("Community_Stringcolon"));
        this.snmpCommunityLabel.setHorizontalAlignment(4);
        this.snmpCommunityTextField = new NameTextField(this.request.getCommunityString(), this.parent);
        this.snmpCommunityTextField.setName("Community String");
        this.snmpCommunityLabel.setDisplayedMnemonic(this.parent.getI18NString("Community_Stringcolon.mnemonic").charAt(0));
        this.snmpCommunityLabel.setLabelFor(this.snmpCommunityTextField);
        jPanel.add(this.loggingCheckBox);
        jPanel2.add(this.pingTimeoutLabel);
        jPanel2.add(this.pingTimeoutTextField);
        jPanel2.add(this.pingRetriesLabel);
        jPanel2.add(this.pingRetriesTextField);
        jPanel3.add(this.snmpTimeoutLabel);
        jPanel3.add(this.snmpTimeoutTextField);
        jPanel3.add(this.snmpRetriesLabel);
        jPanel3.add(this.snmpRetriesTextField);
        jPanel3.add(this.snmpCommunityLabel);
        jPanel3.add(this.snmpCommunityTextField);
        jPanel4.add(this.maxHostsLabel);
        jPanel4.add(this.maxHostsTextField);
        jPanel4.add(this.maxHostDiscoverLabel);
        jPanel4.add(this.maxHostDiscoverTextField);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout(20, 20));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout(20, 20));
        jPanel5.add("North", jPanel);
        jPanel5.add("South", jPanel2);
        jPanel6.add("North", jPanel3);
        jPanel6.add("South", jPanel4);
        JPanel jPanel7 = new JPanel();
        Border border = BorderFactory.createEmptyBorder(25, 25, 25, 25);
        jPanel7.setBorder(border);
        jPanel7.setLayout(new BorderLayout(20, 20));
        jPanel7.add("North", jPanel5);
        jPanel7.add("South", jPanel6);
        return jPanel7;
    }

    private JPanel buildDiscoverTopologyPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(4, 2, 20, 20));
        String[] stringArray = new String[]{this.parent.getI18NString("Ping"), this.parent.getI18NString("Routing_Table")};
        this.dTopMethLabel = new JLabel(this.parent.getI18NString("Discover_Usingcolon"));
        this.dTopMethLabel.setHorizontalAlignment(4);
        this.dTopMethComboBox = new JComboBox<String>(stringArray);
        this.dTopMethLabel.setDisplayedMnemonic(this.parent.getI18NString("Discover_Usingcolon.mnemonic").charAt(0));
        this.dTopMethLabel.setLabelFor(this.dTopMethComboBox);
        if (this.request.getDiscoverTopologyMethod().equals("ping")) {
            this.dTopMethComboBox.setSelectedIndex(0);
        } else if (this.request.getDiscoverTopologyMethod().equals("RoutingTable")) {
            this.dTopMethComboBox.setSelectedIndex(1);
        }
        this.dTopMethComboBox.addItemListener(this);
        this.dTopStartIpLabel = new JLabel(this.parent.getI18NString("Start_IP_Addresscolon"));
        this.dTopStartIpLabel.setHorizontalAlignment(4);
        this.dTopStartIpTextLabel = new JLabel(DiscoverPanel.getTopologyAgentIpAddress());
        this.dTopStartIpTextField = new IpAddressTextField(this.request.getStartIPAddress());
        this.dTopStartIpLabel.setDisplayedMnemonic(this.parent.getI18NString("Start_IP_Addresscolon.mnemonic").charAt(0));
        this.dTopStartIpLabel.setLabelFor(this.dTopStartIpTextField);
        this.dTopEndIpLabel = new JLabel(this.parent.getI18NString("End_IP_Addresscolon"));
        this.dTopEndIpLabel.setHorizontalAlignment(4);
        this.dTopEndIpTextField = new IpAddressTextField(this.request.getEndIPAddress());
        this.dTopEndIpLabel.setDisplayedMnemonic(this.parent.getI18NString("End_IP_Addresscolon.mnemonic").charAt(0));
        this.dTopEndIpLabel.setLabelFor(this.dTopEndIpTextField);
        this.dTopNetmaskLabel = new JLabel(this.parent.getI18NString("Netmaskcolon"));
        this.dTopNetmaskLabel.setHorizontalAlignment(4);
        this.dTopNetmaskTextField = new IpAddressTextField(this.request.getNetmask());
        this.dTopNetmaskLabel.setDisplayedMnemonic(this.parent.getI18NString("Netmaskcolon.mnemonic").charAt(0));
        this.dTopNetmaskLabel.setLabelFor(this.dTopNetmaskTextField);
        this.dTopNumHopsLabel = new JLabel(this.parent.getI18NString("Number_of_Hopscolon"));
        this.dTopNumHopsLabel.setHorizontalAlignment(4);
        this.dTopNumHopsTextField = new IntegerTextField(this.request.getNumberOfHops(), 3);
        this.dTopNumHopsLabel.setDisplayedMnemonic(this.parent.getI18NString("Number_of_Hopscolon.mnemonic").charAt(0));
        this.dTopNumHopsLabel.setLabelFor(this.dTopNumHopsTextField);
        jPanel.add(this.dTopMethLabel);
        jPanel.add(this.dTopMethComboBox);
        jPanel.add(this.dTopStartIpLabel);
        return jPanel;
    }

    private JPanel buildDiscoverPortPanel() {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        jPanel.setLayout(new GridLayout(2, 1, 20, 20));
        jPanel2.setLayout(new BorderLayout(20, 20));
        jPanel3.setLayout(new GridLayout(1, 2, 20, 20));
        this.defaultPortCheckBox = new JCheckBox(this.parent.getI18NString("Use_Default_Port(161)"));
        this.defaultPortCheckBox.setSelected(this.request.getUseDefaultPort());
        this.defaultPortCheckBox.setHorizontalAlignment(0);
        this.defaultPortCheckBox.setMnemonic(this.parent.getI18NString("Use_Default_Port(161).mnemonic").charAt(0));
        JLabel jLabel = new JLabel(this.parent.getI18NString("Symon_Portcolon"));
        jLabel.setHorizontalAlignment(4);
        this.symonPortTextField = new IntegerTextField(this.request.getSymonPort(), 8);
        jLabel.setDisplayedMnemonic(this.parent.getI18NString("Symon_Portcolon.mnemonic").charAt(0));
        jLabel.setLabelFor(this.symonPortTextField);
        jPanel2.add("Center", this.defaultPortCheckBox);
        jPanel3.add(jLabel);
        jPanel3.add(this.symonPortTextField);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        return jPanel;
    }

    private JPanel buildButtonPanel() {
        JPanel jPanel = new JPanel();
        this.okbut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RequestEditDialog.this.OKPressed();
            }
        });
        this.cancelbut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RequestEditDialog.this.CancelPressed();
            }
        });
        jPanel.add(this.okbut);
        jPanel.add(this.cancelbut);
        return jPanel;
    }

    public void showTopologyDiscoveryOptions(String string) {
        if (string.equals("ping")) {
            this.discoverTopologyPanel.add(this.dTopStartIpTextField);
            this.discoverTopologyPanel.add(this.dTopEndIpLabel);
            this.discoverTopologyPanel.add(this.dTopEndIpTextField);
            this.discoverTopologyPanel.add(this.dTopNetmaskLabel);
            this.discoverTopologyPanel.add(this.dTopNetmaskTextField);
            this.discoverTopologyPanel.remove(this.dTopStartIpTextLabel);
            this.discoverTopologyPanel.remove(this.dTopNumHopsLabel);
            this.discoverTopologyPanel.remove(this.dTopNumHopsTextField);
        } else {
            this.discoverTopologyPanel.remove(this.dTopEndIpLabel);
            this.discoverTopologyPanel.remove(this.dTopEndIpTextField);
            this.discoverTopologyPanel.remove(this.dTopNetmaskLabel);
            this.discoverTopologyPanel.remove(this.dTopNetmaskTextField);
            this.discoverTopologyPanel.add(this.dTopStartIpTextField);
            this.discoverTopologyPanel.add(this.dTopNumHopsLabel);
            this.discoverTopologyPanel.add(this.dTopNumHopsTextField);
        }
        this.discoverTopologyPanel.validate();
        this.discoverTopologyPanel.repaint();
    }

    private boolean readMonitorPanel() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        this.request.setMonitoring(this.enableSched.isSelected());
        if (!this.enableSched.isSelected()) {
            return true;
        }
        String string = this.sched.getSchedulerStartDateString();
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(this.sched.getSchedulerStartDateFormat());
        Date date = simpleDateFormat2.parse(string, new ParsePosition(0));
        if (date == null) {
            UcDialog.showError((Object)this.tran("invalidDate"));
            return false;
        }
        String string2 = this.sched.getSchedulerStartTime();
        date = simpleDateFormat.parse(string2, new ParsePosition(0));
        if (date == null) {
            UcDialog.showError((Object)this.tran("invalidTime"));
            return false;
        }
        String string3 = string + " " + string2;
        SimpleDateFormat simpleDateFormat3 = new SimpleDateFormat(this.sched.getSchedulerStartDateFormat() + " HH:mm");
        simpleDateFormat3.setLenient(false);
        Date date2 = simpleDateFormat3.parse(string3, new ParsePosition(0));
        if (date2 == null) {
            UcDialog.showError((Object)this.tran("invalidDate"));
            return false;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date2);
        switch (this.sched.getSchedulerIntervalUnit()) {
            case 5: {
                this.request.setRepeatInterval("hourly");
                break;
            }
            case 6: {
                this.request.setRepeatInterval("daily");
                break;
            }
            case 7: {
                this.request.setRepeatInterval("weekly");
                break;
            }
            case 8: {
                int n;
                int n2 = calendar.get(5);
                if (n2 > 28 && (n = UcDialog.showOkCancel((String)this.tran("monthRepeatWarning"))) == 1) {
                    return false;
                }
                this.request.setRepeatInterval("monthly");
            }
        }
        this.request.setTimeval(date2.getTime());
        this.request.setStartingTime(string2);
        this.request.setDayOfWeek(calendar.get(7));
        this.request.setDayOfMonth(calendar.get(5));
        return true;
    }

    private void readDiscoverPanel() {
        this.request.setName(this.discoverNameTextField.getText());
        this.readDiscoverTopologyPanel();
        this.readDiscoverPortPanel();
    }

    private void readPrefPanel() {
        this.request.setLogging(this.loggingCheckBox.isSelected());
        this.request.setPingTimeout(this.pingTimeoutTextField.getText());
        this.request.setPingRetries(this.pingRetriesTextField.getText());
        this.request.setSnmpTimeout(this.snmpTimeoutTextField.getText());
        this.request.setSnmpRetries(this.snmpRetriesTextField.getText());
        this.request.setCommunityString(this.snmpCommunityTextField.getText());
        this.request.setMaxHosts(this.maxHostsTextField.getText());
        this.request.setMaxDiscoveryTime(this.maxHostDiscoverTextField.getText());
    }

    private void readDiscoverTopologyPanel() {
        String string = "0.0.0.0";
        switch (this.dTopMethComboBox.getSelectedIndex()) {
            case 0: {
                this.request.setDiscoverTopologyMethod("ping");
                string = this.dTopStartIpTextField.getText();
                break;
            }
            case 1: {
                this.request.setDiscoverTopologyMethod("RoutingTable");
                string = this.dTopStartIpTextField.getText();
            }
        }
        this.request.setStartIPAddress(string);
        this.request.setDiscoveryHostIPAddress(string);
        this.request.setEndIPAddress(this.dTopEndIpTextField.getText());
        this.request.setNetmask(this.dTopNetmaskTextField.getText());
        this.request.setNumberOfHops(this.dTopNumHopsTextField.getText());
    }

    private void readDiscoverPortPanel() {
        this.request.setUseDefaultPort(this.defaultPortCheckBox.isSelected());
        this.request.setSymonPort(this.symonPortTextField.getText());
    }

    public void setFont(Font font) {
        this.messageText.setFont(font);
    }

    public void setTextBackground(Color color) {
        this.messageText.setBackground(color);
    }

    public void setTextForeground(Color color) {
        this.messageText.setForeground(color);
    }

    public boolean CheckZero(IntegerTextField integerTextField) {
        if (integerTextField.getText().length() == 0) {
            return true;
        }
        return Integer.parseInt(integerTextField.getText()) == 0;
    }

    public boolean exceedsMaximum(IntegerTextField integerTextField, int n) {
        if (integerTextField.getText().length() == 0) {
            return false;
        }
        return Integer.parseInt(integerTextField.getText()) > n;
    }

    public boolean CheckData() {
        if (this.discoverNameTextField.getText() == null || this.discoverNameTextField.getText().length() == 0) {
            this.parent.showError(this.parent.getI18NString("Error_in_Request_Name"));
            return false;
        }
        if (this.dTopMethComboBox.getSelectedIndex() == 0) {
            if (!UcURL.validateIpAddress((String)this.dTopStartIpTextField.getText())) {
                this.parent.showError(this.parent.getI18NString("Error_in_Start_IP_Address"));
                return false;
            }
            if (this.dTopEndIpTextField.getText().length() != 0 && !UcURL.validateIpAddress((String)this.dTopEndIpTextField.getText())) {
                this.parent.showError(this.parent.getI18NString("Error_in_End_IP_Address"));
                return false;
            }
            if (!UcURL.validateIpAddress((String)this.dTopNetmaskTextField.getText())) {
                this.parent.showError(this.parent.getI18NString("Error_in_Netmask"));
                return false;
            }
            if (this.dTopEndIpTextField.getText().length() != 0 && !RequestEditDialog.compareIpAddress(this.dTopStartIpTextField.getText(), this.dTopEndIpTextField.getText())) {
                this.parent.showError(this.parent.getI18NString("End_Ip_Addresss_gt_Start_Ip_Address"));
                return false;
            }
        } else if (this.dTopNumHopsTextField.getText() == null || this.dTopNumHopsTextField.getText().length() == 0) {
            this.parent.showError(this.parent.getI18NString("Error_in_Hops"));
            return false;
        }
        if (!this.defaultPortCheckBox.isSelected() && this.symonPortTextField.getText().equals("")) {
            this.parent.showError(this.parent.getI18NString("You_must_atleast_select_default_port_or_specify_symon_port_number"));
            return false;
        }
        if (this.CheckZero(this.symonPortTextField) && !this.symonPortTextField.getText().equals("")) {
            this.parent.showError(this.parent.getI18NString("Symon_Port_Number_cannot_be_zero"));
            return false;
        }
        if (this.CheckZero(this.pingTimeoutTextField)) {
            this.parent.showError(this.parent.getI18NString("Error_in_PING_Timeout"));
            return false;
        }
        if (this.exceedsMaximum(this.pingTimeoutTextField, 3600)) {
            this.parent.showError(this.parent.getI18NString("PING_Timeout_Exceeds_Max"));
            return false;
        }
        if (this.CheckZero(this.pingRetriesTextField)) {
            this.parent.showError(this.parent.getI18NString("Error_in_PING_Retries"));
            return false;
        }
        if (this.exceedsMaximum(this.pingRetriesTextField, 15)) {
            this.parent.showError(this.parent.getI18NString("PING_Retries_Exceeds_Max"));
            return false;
        }
        if (this.CheckZero(this.snmpTimeoutTextField)) {
            this.parent.showError(this.parent.getI18NString("Error_in_SNMP_Timeout"));
            return false;
        }
        if (this.exceedsMaximum(this.snmpTimeoutTextField, 3600)) {
            this.parent.showError(this.parent.getI18NString("SNMP_Timeout_Exceeds_Max"));
            return false;
        }
        if (this.CheckZero(this.snmpRetriesTextField)) {
            this.parent.showError(this.parent.getI18NString("Error_in_SNMP_Retries"));
            return false;
        }
        if (this.exceedsMaximum(this.snmpRetriesTextField, 15)) {
            this.parent.showError(this.parent.getI18NString("SNMP_Retries_Exceeds_Max"));
            return false;
        }
        if (this.CheckZero(this.maxHostsTextField)) {
            this.parent.showError(this.parent.getI18NString("Error_in_Max_Hosts"));
            return false;
        }
        if (this.CheckZero(this.maxHostDiscoverTextField)) {
            this.parent.showError(this.parent.getI18NString("Error_in_Max_Discover_Time"));
            return false;
        }
        String string = this.snmpCommunityTextField.getText().trim();
        if (!UcListUtil.isAsciiString((String)string)) {
            this.parent.showError(this.parent.getI18NString("communityStringNonAscii"));
            return false;
        }
        if (string.length() == 0) {
            this.parent.showError(this.parent.getI18NString("Error_in_NULL_SNMP_Community_String"));
            return false;
        }
        if (string.indexOf(32) != -1 || string.indexOf(9) != -1) {
            this.parent.showError(this.parent.getI18NString("Error_in_Space_SNMP_Community_String"));
            return false;
        }
        return true;
    }

    public void OKPressed() {
        if (!this.CheckData()) {
            return;
        }
        if (!this.enableSched.isSelected()) {
            if (this.operation.equals("add") || this.operation.equals("duplicate")) {
                this.parent.createConfirmDialog(this.request, this.parent.getI18NString("Do_you_want_to_start_the_request_upon_creation_?"), "add");
            } else {
                this.parent.createConfirmDialog(this.request, this.parent.getI18NString("Do_you_want_to_restart_the_request_upon_updating_the_data_?"), "edit");
            }
        } else {
            try {
                this.parent.doRequestOperation(this.request.getId(), this.operation, true);
            }
            catch (DiscoverGUIException discoverGUIException) {
                discoverGUIException.print();
            }
        }
    }

    public boolean confirmStart(boolean bl) {
        if (!this.readMonitorPanel()) {
            return false;
        }
        this.readDiscoverPanel();
        this.readPrefPanel();
        this.requestFilterPanel.readFilterData();
        boolean bl2 = true;
        try {
            if (this.operation.equals("add") || this.operation.equals("duplicate")) {
                bl2 = this.request.createInDatabase(this.parent.getSMDiscoveryRequestHandle(), bl);
            } else {
                bl2 = this.request.updateInDatabase(this.parent.getSMDiscoveryRequestHandle(), bl);
                if (!bl2) {
                    this.request.reInit(this.originalRequest);
                }
            }
        }
        catch (DiscoverGUIException discoverGUIException) {
            discoverGUIException.print();
        }
        if (bl2) {
            ((Component)this).setVisible(false);
            this.dispose();
        }
        return bl2;
    }

    public void CancelPressed() {
        ((Component)this).setVisible(false);
        this.parent.closeRequestDialog();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.dTopMethComboBox && itemEvent.getStateChange() == 1) {
            switch (this.dTopMethComboBox.getSelectedIndex()) {
                case 0: {
                    this.showTopologyDiscoveryOptions("ping");
                    break;
                }
                case 1: {
                    this.showTopologyDiscoveryOptions("RoutingTable");
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    static boolean compareIpAddress(String var0, String var1_1) {
        var2_2 = new StringTokenizer(var0, ".");
        var3_3 = new StringTokenizer(var1_1, ".");
        if (var2_2.countTokens() != 4) {
            return false;
        }
        if (var3_3.countTokens() == 4) ** GOTO lbl21
        return false;
lbl-1000:
        // 1 sources

        {
            try {
                var4_4 = Integer.parseInt(var2_2.nextToken());
                if (var4_4 < 0 || var4_4 > 255) {
                    return false;
                }
                var5_6 = Integer.parseInt(var3_3.nextToken());
                if (var5_6 < 0 || var5_6 > 255) {
                    return false;
                }
                if (var5_6 > var4_4) {
                    return true;
                }
                if (var4_4 > var5_6) {
                    return false;
                }
                continue;
            }
            catch (Exception var4_5) {
                return false;
            }
lbl21:
            // 2 sources

            ** while (var2_2.hasMoreTokens())
        }
lbl22:
        // 1 sources

        return true;
    }
}

