/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.tools.discovery.console.presentation;

import com.sun.symon.base.client.SMAPIException;
import com.sun.symon.base.console.discovery.SMDiscoveryData;
import com.sun.symon.base.console.discovery.SMDiscoveryRequest;
import com.sun.symon.base.utility.UcListUtil;
import com.sun.symon.tools.discovery.console.presentation.DiscoverGUIException;
import com.sun.symon.tools.discovery.console.presentation.DiscoverPanel;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class DiscoverRequest {
    String requestId = null;
    String requestName = null;
    String domain = null;
    String view = null;
    String discoveryHost = null;
    String pingTimeout = "1";
    String snmpTimeout = "3";
    String pingRetries = "1";
    String snmpRetries = "1";
    String maxHosts = "256";
    String maxDiscoveryTime = "1000000";
    boolean useDefaultPort = true;
    String symonPort = "";
    String ports = "";
    boolean logging = true;
    boolean monitoring = false;
    String startingTime = "";
    String repeatInterval = "weekly";
    String dayOfWeek = "Saturday";
    String dayOfMonth = "1";
    String discoverTopologyMethod = "ping";
    String startIPAddress = DiscoverPanel.getTopologyAgentIpAddress();
    String endIPAddress = DiscoverPanel.getTopologyAgentIpAddress();
    String netmask = "255.255.255.0";
    String numberOfHops = "0";
    String discoverEntityMethod = "ping";
    String communityString = "public";
    String filter = null;
    String[] dayNamesOfWeek = new String[]{"Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"};
    String requestStatus = "";
    int numFilterCriteria = 0;
    long timeval;
    int[] filterCriteria;
    String[][] includeItemArray = null;
    String[][] excludeItemArray = null;
    DiscoverPanel parent;
    static final String NO_ACCESS = "error status 6";

    public DiscoverRequest(DiscoverPanel discoverPanel, SMDiscoveryData sMDiscoveryData) {
        this.parent = discoverPanel;
        this.requestId = sMDiscoveryData.getdiscoveryRequestId();
        this.requestName = UcListUtil.AsciiToUnicode((String)sMDiscoveryData.getrequestDescription());
        this.domain = UcListUtil.AsciiToUnicode((String)sMDiscoveryData.getdomainName());
        this.view = sMDiscoveryData.getviewName();
        Properties properties = sMDiscoveryData.getalgoParameters();
        this.pingTimeout = properties.getProperty("pingtimeout");
        this.pingRetries = properties.getProperty("pingretries");
        this.snmpTimeout = properties.getProperty("snmptimeout");
        this.snmpRetries = properties.getProperty("snmpretries");
        this.maxHosts = String.valueOf(sMDiscoveryData.getmaxHosts());
        this.maxDiscoveryTime = String.valueOf(sMDiscoveryData.getmaxDiscoveryTime());
        this.logging = sMDiscoveryData.getlogResults();
        this.timeval = sMDiscoveryData.getdiscoveryStartTime();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date(this.timeval * 1000L));
        this.dayOfWeek = this.dayNamesOfWeek[calendar.get(7) - 1];
        this.dayOfMonth = String.valueOf(calendar.get(5));
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        this.startingTime = n2 < 10 ? String.valueOf(n) + ":0" + String.valueOf(n2) : String.valueOf(n) + ":" + String.valueOf(n2);
        this.repeatInterval = sMDiscoveryData.getdiscoveryFrequency();
        this.discoverTopologyMethod = sMDiscoveryData.gettopologyDiscoveryAlgo();
        this.startIPAddress = sMDiscoveryData.getstartIpAddress();
        this.endIPAddress = sMDiscoveryData.getendIpAddress();
        this.netmask = sMDiscoveryData.getnetMask();
        this.numberOfHops = String.valueOf(sMDiscoveryData.getmaxHops());
        this.discoverEntityMethod = sMDiscoveryData.gethostDiscoveryAlgo();
        this.communityString = properties.getProperty("snmpcommunity");
        this.ports = properties.getProperty("snmpports");
        this.parsePorts();
        this.filter = sMDiscoveryData.getfilter();
        try {
            this.parseFilter(sMDiscoveryData.getfilter());
        }
        catch (DiscoverGUIException discoverGUIException) {
            this.numFilterCriteria = 0;
            discoverGUIException.print();
        }
        this.monitoring = sMDiscoveryData.getschedulingState();
    }

    public DiscoverRequest(DiscoverPanel discoverPanel, String string) {
        this.parent = discoverPanel;
        this.domain = string;
        this.requestName = this.parent.getI18NString("NoName");
        this.createPorts();
    }

    public DiscoverRequest(DiscoverPanel discoverPanel, DiscoverRequest discoverRequest) {
        this.parent = discoverPanel;
        this.requestId = null;
        this.requestName = discoverRequest.requestName;
        this.view = discoverRequest.view;
        this.domain = discoverRequest.domain;
        this.requestStatus = discoverRequest.requestStatus;
        this.pingTimeout = discoverRequest.pingTimeout;
        this.pingRetries = discoverRequest.pingRetries;
        this.snmpTimeout = discoverRequest.snmpTimeout;
        this.snmpRetries = discoverRequest.snmpRetries;
        this.maxHosts = discoverRequest.maxHosts;
        this.maxDiscoveryTime = discoverRequest.maxDiscoveryTime;
        this.logging = discoverRequest.logging;
        this.monitoring = discoverRequest.monitoring;
        this.timeval = discoverRequest.timeval;
        this.startingTime = discoverRequest.startingTime;
        this.dayOfWeek = discoverRequest.dayOfWeek;
        this.dayOfMonth = discoverRequest.dayOfMonth;
        this.repeatInterval = discoverRequest.repeatInterval;
        this.discoverTopologyMethod = discoverRequest.discoverTopologyMethod;
        this.startIPAddress = discoverRequest.startIPAddress;
        this.endIPAddress = discoverRequest.endIPAddress;
        this.netmask = discoverRequest.netmask;
        this.numberOfHops = discoverRequest.numberOfHops;
        this.discoverEntityMethod = discoverRequest.discoverEntityMethod;
        this.communityString = discoverRequest.communityString;
        this.ports = discoverRequest.ports;
        this.filter = discoverRequest.filter;
        if (discoverRequest.numFilterCriteria != 0) {
            this.numFilterCriteria = discoverRequest.numFilterCriteria;
            this.filterCriteria = new int[this.numFilterCriteria];
            this.includeItemArray = new String[this.numFilterCriteria][];
            this.excludeItemArray = new String[this.numFilterCriteria][];
            int n = 0;
            while (n < this.numFilterCriteria) {
                int n2;
                this.filterCriteria[n] = discoverRequest.filterCriteria[n];
                if (discoverRequest.includeItemArray[n] != null) {
                    this.includeItemArray[n] = new String[discoverRequest.includeItemArray[n].length];
                    n2 = 0;
                    while (n2 < discoverRequest.includeItemArray[n].length) {
                        this.includeItemArray[n][n2] = discoverRequest.includeItemArray[n][n2];
                        ++n2;
                    }
                }
                if (discoverRequest.excludeItemArray[n] != null) {
                    this.excludeItemArray[n] = new String[discoverRequest.excludeItemArray[n].length];
                    n2 = 0;
                    while (n2 < discoverRequest.excludeItemArray[n].length) {
                        this.excludeItemArray[n][n2] = discoverRequest.excludeItemArray[n][n2];
                        ++n2;
                    }
                }
                ++n;
            }
        }
        this.useDefaultPort = discoverRequest.useDefaultPort;
        this.symonPort = discoverRequest.symonPort;
    }

    public void reInit(DiscoverRequest discoverRequest) {
        this.requestId = discoverRequest.requestId;
        this.requestName = discoverRequest.requestName;
        this.view = discoverRequest.view;
        this.domain = discoverRequest.domain;
        this.requestStatus = discoverRequest.requestStatus;
        this.pingTimeout = discoverRequest.pingTimeout;
        this.pingRetries = discoverRequest.pingRetries;
        this.snmpTimeout = discoverRequest.snmpTimeout;
        this.snmpRetries = discoverRequest.snmpRetries;
        this.maxHosts = discoverRequest.maxHosts;
        this.maxDiscoveryTime = discoverRequest.maxDiscoveryTime;
        this.logging = discoverRequest.logging;
        this.monitoring = discoverRequest.monitoring;
        this.timeval = discoverRequest.timeval;
        this.startingTime = discoverRequest.startingTime;
        this.dayOfWeek = discoverRequest.dayOfWeek;
        this.dayOfMonth = discoverRequest.dayOfMonth;
        this.repeatInterval = discoverRequest.repeatInterval;
        this.discoverTopologyMethod = discoverRequest.discoverTopologyMethod;
        this.startIPAddress = discoverRequest.startIPAddress;
        this.endIPAddress = discoverRequest.endIPAddress;
        this.netmask = discoverRequest.netmask;
        this.numberOfHops = discoverRequest.numberOfHops;
        this.discoverEntityMethod = discoverRequest.discoverEntityMethod;
        this.communityString = discoverRequest.communityString;
        this.ports = discoverRequest.ports;
        this.filter = discoverRequest.filter;
        if (discoverRequest.numFilterCriteria != 0) {
            this.numFilterCriteria = discoverRequest.numFilterCriteria;
            this.filterCriteria = new int[this.numFilterCriteria];
            this.includeItemArray = new String[this.numFilterCriteria][];
            this.excludeItemArray = new String[this.numFilterCriteria][];
            int n = 0;
            while (n < this.numFilterCriteria) {
                int n2;
                this.filterCriteria[n] = discoverRequest.filterCriteria[n];
                if (discoverRequest.includeItemArray[n] != null) {
                    this.includeItemArray[n] = new String[discoverRequest.includeItemArray[n].length];
                    n2 = 0;
                    while (n2 < discoverRequest.includeItemArray[n].length) {
                        this.includeItemArray[n][n2] = discoverRequest.includeItemArray[n][n2];
                        ++n2;
                    }
                }
                if (discoverRequest.excludeItemArray[n] != null) {
                    this.excludeItemArray[n] = new String[discoverRequest.excludeItemArray[n].length];
                    n2 = 0;
                    while (n2 < discoverRequest.excludeItemArray[n].length) {
                        this.excludeItemArray[n][n2] = discoverRequest.excludeItemArray[n][n2];
                        ++n2;
                    }
                }
                ++n;
            }
        } else {
            this.numFilterCriteria = 0;
            this.filterCriteria = null;
            this.includeItemArray = null;
            this.excludeItemArray = null;
        }
        this.useDefaultPort = discoverRequest.useDefaultPort;
        this.symonPort = discoverRequest.symonPort;
    }

    public void parseFilter(String string) throws DiscoverGUIException {
        int n;
        int n2;
        char c;
        Vector[] vectorArray = new Vector[4];
        Vector[] vectorArray2 = new Vector[4];
        Vector<String> vector = new Vector<String>();
        int n3 = 0;
        int n4 = -1;
        boolean bl = false;
        int n5 = 120;
        int n6 = 0;
        while (n6 < string.length()) {
            c = string.charAt(n6);
            if (bl) {
                if (c == '\"' && n5 != 92) {
                    bl = false;
                }
            } else if (c == '\"') {
                bl = true;
            } else {
                String string2 = string.substring(n6);
                if (string2.startsWith(" OR ")) {
                    n4 = n6;
                    vector.addElement(string.substring(n3, n4));
                    n3 = n6 += 4;
                } else if (string2.startsWith(" AND ")) {
                    n4 = n6;
                    vector.addElement(string.substring(n3, n4));
                    n3 = n6 += 5;
                }
            }
            ++n6;
        }
        vector.addElement(string.substring(n3));
        this.numFilterCriteria = 0;
        this.filterCriteria = new int[4];
        c = '\u0001';
        int n7 = 0;
        while (n7 < vector.size()) {
            n2 = -1;
            n = -1;
            String string3 = (String)vector.elementAt(n7);
            int n8 = 0;
            while (n8 < string3.length()) {
                char c2 = string3.charAt(n8);
                if (c2 != ' ' && c2 != '\t') {
                    if (c2 == '-') {
                        c = '\u0000';
                        ++n8;
                    } else if (c2 == '+') {
                        c = '\u0001';
                        ++n8;
                    } else {
                        c = '\u0001';
                    }
                    String string4 = string3.substring(n8);
                    if (string4.startsWith("OS")) {
                        n2 = 1;
                    } else if (string4.startsWith("NAME")) {
                        n2 = 0;
                    } else if (string4.startsWith("ARCH")) {
                        n2 = 2;
                    } else if (string4.startsWith("MODULE")) {
                        n2 = 3;
                    } else {
                        System.out.println("Invalid filter");
                        System.out.println(string4);
                    }
                    int n9 = 0;
                    while (n9 < this.numFilterCriteria) {
                        if (n2 == this.filterCriteria[n9]) {
                            n = n9;
                            break;
                        }
                        ++n9;
                    }
                    if (n < 0) {
                        this.filterCriteria[this.numFilterCriteria] = n2;
                        n = this.numFilterCriteria++;
                        vectorArray[n] = new Vector();
                        vectorArray2[n] = new Vector();
                    }
                    while (string3.charAt(n8) != '=') {
                        ++n8;
                    }
                    String string5 = string3.substring(n8 + 1);
                    if (c == '\u0001') {
                        vectorArray[n].addElement(string5);
                        break;
                    }
                    vectorArray2[n].addElement(string5);
                    break;
                }
                ++n8;
            }
            ++n7;
        }
        if (this.numFilterCriteria > 0) {
            this.includeItemArray = new String[this.numFilterCriteria][];
            this.excludeItemArray = new String[this.numFilterCriteria][];
            n2 = 0;
            while (n2 < this.numFilterCriteria) {
                if (vectorArray[n2].size() > 0) {
                    this.includeItemArray[n2] = new String[vectorArray[n2].size()];
                    n = 0;
                    while (n < vectorArray[n2].size()) {
                        this.includeItemArray[n2][n] = (String)vectorArray[n2].elementAt(n);
                        ++n;
                    }
                }
                if (vectorArray2[n2].size() > 0) {
                    this.excludeItemArray[n2] = new String[vectorArray2[n2].size()];
                    n = 0;
                    while (n < vectorArray2[n2].size()) {
                        this.excludeItemArray[n2][n] = (String)vectorArray2[n2].elementAt(n);
                        ++n;
                    }
                }
                ++n2;
            }
        }
    }

    public String createFilter() {
        String string = new String();
        String string2 = null;
        boolean bl = false;
        int n = 0;
        while (n < this.numFilterCriteria) {
            String string3;
            int n2;
            String string4;
            if (this.filterCriteria[n] == 1) {
                string2 = "OS";
            } else if (this.filterCriteria[n] == 0) {
                string2 = "NAME";
            } else if (this.filterCriteria[n] == 2) {
                string2 = "ARCH";
            } else if (this.filterCriteria[n] == 3) {
                string2 = "MODULE";
            }
            if (this.includeItemArray[n] != null && this.includeItemArray[n].length > 0) {
                if (bl) {
                    string = string + " AND ";
                }
                string4 = " +" + string2 + "=" + this.includeItemArray[n][0];
                n2 = 1;
                while (n2 < this.includeItemArray[n].length) {
                    string3 = " OR +" + string2 + "=" + this.includeItemArray[n][n2];
                    string4 = string4 + string3;
                    ++n2;
                }
                string = string + string4;
                bl = true;
            } else if (this.excludeItemArray[n] != null && this.excludeItemArray[n].length > 0) {
                if (bl) {
                    string = string + " AND ";
                }
                string4 = " -" + string2 + "=" + this.excludeItemArray[n][0];
                n2 = 1;
                while (n2 < this.excludeItemArray[n].length) {
                    string3 = " AND -" + string2 + "=" + this.excludeItemArray[n][n2];
                    string4 = string4 + string3;
                    ++n2;
                }
                string = string + string4;
                bl = true;
            } else {
                bl = false;
            }
            ++n;
        }
        return string;
    }

    public boolean createInDatabase(SMDiscoveryRequest sMDiscoveryRequest, boolean bl) throws DiscoverGUIException {
        String string = this.parent.getI18NString("createRequestFailedSec");
        String string2 = this.parent.getI18NString("createRequestFailed");
        if (this.requestId != null) {
            return false;
        }
        this.createPorts();
        Properties properties = new Properties();
        ((Hashtable)properties).put("pingtimeout", this.pingTimeout);
        ((Hashtable)properties).put("pingretries", this.pingRetries);
        ((Hashtable)properties).put("snmptimeout", this.snmpTimeout);
        ((Hashtable)properties).put("snmpretries", this.snmpRetries);
        ((Hashtable)properties).put("snmpcommunity", this.communityString);
        ((Hashtable)properties).put("snmpports", this.ports);
        boolean bl2 = true;
        try {
            SMDiscoveryData sMDiscoveryData = new SMDiscoveryData(this.requestId, this.discoveryHost, UcListUtil.UnicodeToAscii((String)this.requestName), UcListUtil.UnicodeToAscii((String)this.domain), this.view, this.startIPAddress, this.endIPAddress, Integer.valueOf(this.numberOfHops), this.netmask, Integer.valueOf(this.maxHosts), Long.valueOf(this.maxDiscoveryTime), this.timeval, this.repeatInterval, this.monitoring, bl, this.logging, this.createFilter(), this.discoverTopologyMethod, this.discoverEntityMethod, properties);
            bl2 = sMDiscoveryRequest.createRequest(sMDiscoveryData);
            if (!bl2) {
                boolean bl3 = true;
                SMAPIException sMAPIException = sMDiscoveryRequest.getException();
                if (sMAPIException != null && sMAPIException.getReasonCode() == 1) {
                    bl3 = false;
                    this.parent.showError(string);
                }
                if (bl3) {
                    this.parent.showError(string2);
                }
            }
        }
        catch (SMAPIException sMAPIException) {
            throw new DiscoverGUIException("SMAPI Exception in createRequest");
        }
        return bl2;
    }

    public boolean updateInDatabase(SMDiscoveryRequest sMDiscoveryRequest, boolean bl) throws DiscoverGUIException {
        this.createPorts();
        Properties properties = new Properties();
        ((Hashtable)properties).put("pingtimeout", this.pingTimeout);
        ((Hashtable)properties).put("pingretries", this.pingRetries);
        ((Hashtable)properties).put("snmptimeout", this.snmpTimeout);
        ((Hashtable)properties).put("snmpretries", this.snmpRetries);
        ((Hashtable)properties).put("snmpcommunity", this.communityString);
        ((Hashtable)properties).put("snmpports", this.ports);
        boolean bl2 = true;
        try {
            SMDiscoveryData sMDiscoveryData = new SMDiscoveryData(this.requestId, this.discoveryHost, UcListUtil.UnicodeToAscii((String)this.requestName), UcListUtil.UnicodeToAscii((String)this.domain), this.view, this.startIPAddress, this.endIPAddress, Integer.valueOf(this.numberOfHops), this.netmask, Integer.valueOf(this.maxHosts), Long.valueOf(this.maxDiscoveryTime), this.timeval, this.repeatInterval, this.monitoring, bl, this.logging, this.createFilter(), this.discoverTopologyMethod, this.discoverEntityMethod, properties);
            bl2 = sMDiscoveryRequest.updateRequest(sMDiscoveryData);
            if (!bl2) {
                boolean bl3 = true;
                SMAPIException sMAPIException = sMDiscoveryRequest.getException();
                if (sMAPIException != null && sMAPIException.getReasonCode() == 1) {
                    bl3 = false;
                    this.parent.showError(this.parent.getI18NString("updateRequestFailedSec"));
                }
                if (bl3) {
                    this.parent.showError(this.parent.getI18NString("updateRequestFailed"));
                }
            }
        }
        catch (SMAPIException sMAPIException) {
            throw new DiscoverGUIException("SMAPI Exception in craeteRequest");
        }
        return bl2;
    }

    public String getId() {
        return this.requestId;
    }

    public String getName() {
        return this.requestName;
    }

    public String getDomain() {
        return this.domain;
    }

    public String getView() {
        return this.view;
    }

    public boolean getMonitoring() {
        return this.monitoring;
    }

    public boolean getLogging() {
        return this.logging;
    }

    public String getStartingTime() {
        return this.startingTime;
    }

    public long getTimeval() {
        return this.timeval * 1000L;
    }

    public String getRepeatInterval() {
        return this.repeatInterval;
    }

    public String getDayOfWeek() {
        return this.dayOfWeek;
    }

    public String getDayOfMonth() {
        return this.dayOfMonth;
    }

    public String getDiscoverTopologyMethod() {
        return this.discoverTopologyMethod;
    }

    public String getStartIPAddress() {
        return this.startIPAddress;
    }

    public String getEndIPAddress() {
        return this.endIPAddress;
    }

    public String getNetmask() {
        return this.netmask;
    }

    public String getNumberOfHops() {
        return this.numberOfHops;
    }

    public String getDiscoverEntityMethod() {
        return this.discoverEntityMethod;
    }

    public String getCommunityString() {
        return this.communityString;
    }

    public String getPorts() {
        return this.ports;
    }

    public String getPingTimeout() {
        return this.pingTimeout;
    }

    public String getPingRetries() {
        return this.pingRetries;
    }

    public String getSnmpTimeout() {
        return this.snmpTimeout;
    }

    public String getSnmpRetries() {
        return this.snmpRetries;
    }

    public String getMaxHosts() {
        return this.maxHosts;
    }

    public String getMaxDiscoveryTime() {
        return this.maxDiscoveryTime;
    }

    public int getNumFilterCriteria() {
        return this.numFilterCriteria;
    }

    public int getFilterCriteria(int n) {
        return this.filterCriteria[n];
    }

    public String[] getIncludeItemValue(int n) {
        return this.includeItemArray[n];
    }

    public String[] getExcludeItemValue(int n) {
        return this.excludeItemArray[n];
    }

    public String getRequestStatus() {
        return this.requestStatus;
    }

    public String getPropertyValue(String string) {
        this.createPorts();
        if (string.equals("RequestId")) {
            return this.requestId;
        }
        if (string.equals("Name")) {
            return this.requestName;
        }
        if (string.equals("Logging")) {
            if (this.logging) {
                return "Enabled";
            }
            return "Disabled";
        }
        if (string.equals("Frequency")) {
            return this.repeatInterval;
        }
        if (string.equals("DayOfWeek")) {
            return this.dayOfWeek;
        }
        if (string.equals("DayOfMonth")) {
            return this.dayOfMonth;
        }
        if (string.equals("Time")) {
            return this.startingTime;
        }
        if (string.equals("Scheduled")) {
            if (this.monitoring) {
                return "Yes";
            }
            return "No";
        }
        if (string.equals("Status")) {
            return this.requestStatus;
        }
        if (string.equals("PingTimeout")) {
            return this.pingTimeout;
        }
        if (string.equals("PingRetries")) {
            return this.pingRetries;
        }
        if (string.equals("SnmpTimeout")) {
            return this.snmpTimeout;
        }
        if (string.equals("SnmpRetries")) {
            return this.snmpRetries;
        }
        if (string.equals("MaxHosts")) {
            return this.maxHosts;
        }
        if (string.equals("MaxDiscoveryTime")) {
            return this.maxDiscoveryTime;
        }
        if (string.equals("DiscoverTopologyMethod")) {
            return this.discoverTopologyMethod;
        }
        if (string.equals("StartIPAddress")) {
            return this.startIPAddress;
        }
        if (string.equals("EndIPAddress")) {
            return this.endIPAddress;
        }
        if (string.equals("Netmask")) {
            return this.netmask;
        }
        if (string.equals("NumberOfHops")) {
            return this.numberOfHops;
        }
        if (string.equals("CommunityString")) {
            return this.communityString;
        }
        if (string.equals("Ports")) {
            return this.ports;
        }
        if (string.equals("FilterCriteria")) {
            return this.filter;
        }
        return "Property name not found";
    }

    /*
     * Unable to fully structure code
     */
    public void parsePorts() {
        block2: {
            block1: {
                if (this.ports == null) break block1;
                var1_1 = new StringTokenizer(this.ports, "|");
                if (var1_1.countTokens() != 1) ** GOTO lbl9
                this.useDefaultPort = this.ports.equals("161");
                this.symonPort = this.useDefaultPort != false ? "" : this.ports;
                break block2;
lbl-1000:
                // 1 sources

                {
                    this.symonPort = var1_1.nextToken();
                    if (!this.symonPort.equals("161")) break;
lbl9:
                    // 2 sources

                    ** while (var1_1.hasMoreTokens())
                }
lbl10:
                // 2 sources

                this.useDefaultPort = true;
                break block2;
            }
            this.useDefaultPort = true;
            this.symonPort = "";
        }
    }

    public void createPorts() {
        if (!this.symonPort.equals("")) {
            this.ports = this.symonPort;
            if (this.useDefaultPort) {
                this.ports = "161|" + this.symonPort;
            }
        } else if (this.useDefaultPort) {
            this.ports = "161";
        }
    }

    public void setId(String string) {
        this.requestId = string;
    }

    public void setName(String string) {
        this.requestName = string;
    }

    public void setDomain(String string) {
        this.domain = string;
    }

    public void setView(String string) {
        this.view = string;
    }

    public void setLogging(boolean bl) {
        this.logging = bl;
    }

    public void setMonitoring(boolean bl) {
        this.monitoring = bl;
    }

    public void setTimeval(long l) {
        this.timeval = l / 1000L;
    }

    public void setRepeatInterval(String string) {
        this.repeatInterval = string;
    }

    public void setDayOfWeek(int n) {
        this.dayOfWeek = this.dayNamesOfWeek[n - 1];
    }

    public void setDayOfMonth(int n) {
        this.dayOfMonth = String.valueOf(n);
    }

    public void setStartingTime(String string) {
        this.startingTime = string;
    }

    public void setPingTimeout(String string) {
        this.pingTimeout = string;
    }

    public void setPingRetries(String string) {
        this.pingRetries = string;
    }

    public void setSnmpTimeout(String string) {
        this.snmpTimeout = string;
    }

    public void setSnmpRetries(String string) {
        this.snmpRetries = string;
    }

    public void setMaxHosts(String string) {
        this.maxHosts = string;
    }

    public void setMaxDiscoveryTime(String string) {
        this.maxDiscoveryTime = string;
    }

    public void setDiscoverTopologyMethod(String string) {
        this.discoverTopologyMethod = string;
    }

    public void setStartIPAddress(String string) {
        this.startIPAddress = string;
    }

    public void setEndIPAddress(String string) {
        this.endIPAddress = string;
    }

    public void setNetmask(String string) {
        this.netmask = string;
    }

    public void setNumberOfHops(String string) {
        this.numberOfHops = string;
    }

    public void setDiscoverEntityMethod(String string) {
        this.discoverEntityMethod = string;
    }

    public void setCommunityString(String string) {
        this.communityString = string;
    }

    public void setNumFilterCriteria(int n) {
        this.numFilterCriteria = n;
        this.filterCriteria = new int[this.numFilterCriteria];
        this.includeItemArray = new String[this.numFilterCriteria][];
        this.excludeItemArray = new String[this.numFilterCriteria][];
    }

    public void setFilterCriteria(int n, int n2) {
        this.filterCriteria[n] = n2;
    }

    public void setIncludeItemValue(int n, String[] stringArray) {
        this.includeItemArray[n] = stringArray;
    }

    public void setExcludeItemValue(int n, String[] stringArray) {
        this.excludeItemArray[n] = stringArray;
    }

    public void setRequestStatus(String string) {
        this.requestStatus = string;
    }

    public void setDiscoveryHostIPAddress(String string) {
        this.discoveryHost = string;
    }

    public void setUseDefaultPort(boolean bl) {
        this.useDefaultPort = bl;
    }

    public void setSymonPort(String string) {
        this.symonPort = string;
    }

    public String getSymonPort() {
        return this.symonPort;
    }

    public boolean getUseDefaultPort() {
        return this.useDefaultPort;
    }
}

