/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.topology;

import com.sun.symon.base.client.alarm.SMAlarmStatusData;
import com.sun.symon.base.client.topology.SMFamilyImages;
import com.sun.symon.base.console.views.topology.CvTopologyNodeEntity;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;

public class CvTopBusNodeEntity
extends CvTopologyNodeEntity {
    protected static final int SEPARATION = 5;
    private int DispMajor;
    private int TextWidth;
    private int TextHeight;
    private int TextVOffset;
    private String CurrentStatus = "OK ";
    private Icon CurrentIcon = null;

    public void setConfigureInfo(String string) {
    }

    public void setFamilyImages(SMFamilyImages sMFamilyImages) {
        super.setFamilyImages(sMFamilyImages);
        this.CurrentIcon = null;
        if (sMFamilyImages != null) {
            this.CurrentIcon = sMFamilyImages.getIcon(this.CurrentStatus, true);
        }
        this.determineLayout(this.getFont());
        this.ViewParent.requestUpdate(true);
    }

    public void handleNewFont(Font font) {
        this.determineLayout(this.getFont());
    }

    public void init() {
        this.determineLayout(this.getFont());
    }

    public void setListAlignment(boolean bl) {
        if (this.ListAlignment == bl) {
            return;
        }
        super.setListAlignment(bl);
        this.determineLayout(this.getFont());
    }

    public void setCurrentStatus(SMAlarmStatusData sMAlarmStatusData) {
        super.setCurrentStatus(sMAlarmStatusData);
        String string = sMAlarmStatusData.getState();
        if (this.CurrentStatus.compareTo(string) != 0) {
            this.CurrentStatus = string;
            if (this.FamilyImages != null) {
                this.CurrentIcon = this.FamilyImages.getIcon(this.CurrentStatus, true);
            }
            this.determineLayout(this.getFont());
            this.ViewParent.requestUpdate(true);
        }
    }

    public void determineLayout(Font font) {
        FontMetrics fontMetrics = ((Component)this.ViewParent).getFontMetrics(font);
        this.TextWidth = fontMetrics.stringWidth(this.Name);
        this.TextHeight = fontMetrics.getAscent() + fontMetrics.getDescent();
        this.DispMajor = this.CurrentIcon != null ? (this.ListAlignment ? this.CurrentIcon.getIconWidth() + 5 + this.TextWidth : this.CurrentIcon.getIconHeight() + 5 + this.TextHeight) : (this.ListAlignment ? this.TextWidth : this.TextHeight);
        this.TextVOffset = this.ListAlignment ? this.TextHeight / 2 - fontMetrics.getDescent() : this.DispMajor / 2 - fontMetrics.getDescent();
    }

    public Dimension getBounds() {
        if (this.CurrentIcon != null) {
            if (this.ListAlignment) {
                int n = this.CurrentIcon.getIconHeight();
                if (this.TextHeight > n) {
                    n = this.TextHeight;
                }
                return new Dimension(this.DispMajor, n);
            }
            int n = this.CurrentIcon.getIconWidth();
            if (this.TextWidth > n) {
                n = this.TextWidth;
            }
            return new Dimension(n, this.DispMajor);
        }
        return new Dimension(this.TextWidth, this.TextHeight);
    }

    public boolean contains(int n, int n2) {
        Rectangle rectangle;
        if (this.ListAlignment) {
            Rectangle rectangle2;
            if (this.CurrentIcon != null && (rectangle2 = new Rectangle(this.XOrigin - this.DispMajor / 2, this.YOrigin - this.CurrentIcon.getIconHeight() / 2, this.CurrentIcon.getIconWidth(), this.CurrentIcon.getIconHeight())).contains(n, n2)) {
                return true;
            }
            rectangle2 = new Rectangle(this.XOrigin + this.DispMajor / 2 - this.TextWidth, this.YOrigin - this.TextHeight / 2, this.TextWidth, this.TextHeight);
            return rectangle2.contains(n, n2);
        }
        if (this.CurrentIcon != null && (rectangle = new Rectangle(this.XOrigin - this.CurrentIcon.getIconWidth() / 2, this.YOrigin - this.DispMajor / 2, this.CurrentIcon.getIconWidth(), this.CurrentIcon.getIconHeight())).contains(n, n2)) {
            return true;
        }
        rectangle = new Rectangle(this.XOrigin - this.TextWidth / 2, this.YOrigin + this.DispMajor / 2 - this.TextHeight, this.TextWidth, this.TextHeight);
        return rectangle.contains(n, n2);
    }

    public boolean within(Rectangle rectangle) {
        Dimension dimension = this.getBounds();
        dimension.setSize(dimension.width / 2, dimension.height / 2);
        if (!rectangle.contains(this.XOrigin - dimension.width, this.YOrigin - dimension.height)) {
            return false;
        }
        return rectangle.contains(this.XOrigin + dimension.width, this.YOrigin + dimension.height);
    }

    public void draw(Graphics graphics, int n, int n2) {
        int n3;
        int n4;
        if (this.CurrentIcon != null) {
            int n5;
            if (this.ListAlignment) {
                n4 = this.XOrigin - this.DispMajor / 2;
                n5 = this.YOrigin - this.CurrentIcon.getIconHeight() / 2;
            } else {
                n4 = this.XOrigin - this.CurrentIcon.getIconWidth() / 2;
                n5 = this.YOrigin - this.DispMajor / 2;
            }
            this.CurrentIcon.paintIcon(this.ViewParent, graphics, n + n4, n2 + n5);
            if (this.IsSelected) {
                graphics.setColor(Color.blue.darker().darker());
                graphics.drawRect(n + n4 - 1, n2 + n5 - 1, this.CurrentIcon.getIconWidth() + 2, this.CurrentIcon.getIconHeight() + 2);
            }
        }
        if (this.ListAlignment) {
            n4 = this.XOrigin + this.DispMajor / 2 - this.TextWidth;
            n3 = this.YOrigin - this.TextHeight / 2;
        } else {
            n4 = this.XOrigin - this.TextWidth / 2;
            n3 = this.YOrigin + this.DispMajor / 2 - this.TextHeight;
        }
        if (!this.IsSelected) {
            graphics.setColor(this.ViewParent.getBackground());
            graphics.fillRect(n + n4 - 1, n2 + n3 - 1, this.TextWidth + 2, this.TextHeight + 2);
            graphics.setColor(Color.black);
            graphics.drawString(this.Name, n + n4, n2 + this.YOrigin + this.TextVOffset);
        } else {
            graphics.setColor(Color.blue.darker().darker());
            graphics.fillRect(n + n4 - 1, n2 + n3 - 1, this.TextWidth + 2, this.TextHeight + 2);
            graphics.setColor(Color.white);
            graphics.drawString(this.Name, n + n4, n2 + this.YOrigin + this.TextVOffset);
        }
    }

    public void shutdown() {
    }

    public boolean getIsStaticNode() {
        return true;
    }

    public Point getStaticEndPoint() {
        if (this.CurrentIcon != null) {
            int n = this.XOrigin;
            int n2 = this.YOrigin;
            if (this.ListAlignment) {
                n += -this.DispMajor / 2 + this.CurrentIcon.getIconWidth() / 2;
            } else {
                n2 += -this.DispMajor / 2 + this.CurrentIcon.getIconHeight() / 2;
            }
            return new Point(n, n2);
        }
        return new Point(this.XOrigin, this.YOrigin);
    }
}

