/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.table;

import com.sun.symon.base.client.SMResourceAccess;
import com.sun.symon.base.client.console.SMConsoleContext;
import com.sun.symon.base.console.views.table.CvCommonTable;
import com.sun.symon.base.console.views.table.CvTable;
import com.sun.symon.base.console.views.table.CvTblCell;
import com.sun.symon.base.console.views.table.CvTblTableEventListener;
import com.sun.symon.base.console.views.table.CvTblTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class CvTblTableColumn
extends TableColumn
implements TableCellRenderer {
    private String dataType = "";
    private Vector tableEventListeners = new Vector();
    private Border nonSelBorder;
    private Border nonSelHdrBorder;
    private Border selBorder;
    private Border focusBorder;
    private Border noFocusBorder;
    static int ASCENDING = 0;
    static int DESCENDING = 1;
    static int NORMAL = 2;
    int status = NORMAL;
    int headerAlignment = 0;
    Icon ascendingIcon = null;
    Icon descendingIcon = null;
    private Vector rowsDataType = null;

    public CvTblTableColumn(int n, String string, String string2, int n2) {
        this.setModelIndex(n);
        this.setDataType(string2);
        this.setWidth(n2);
        JLabel jLabel = new JLabel(string);
        jLabel.setToolTipText(string);
        jLabel.setFont(CvTable.DEFAULT_HEADER_FONT);
        jLabel.setBorder(new LineBorder(Color.black, 1));
        this.setHeaderValue(jLabel);
        this.setHeaderRenderer(this);
        this.setCellRenderer(this);
        this.setResizable(true);
        this.enableResizedPosting();
        this.nonSelBorder = BorderFactory.createEmptyBorder(2, 2, 2, 2);
        this.nonSelHdrBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black, 1), BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.selBorder = BorderFactory.createLineBorder(Color.blue.darker().darker(), 2);
        this.focusBorder = BorderFactory.createLineBorder(new Color(102, 102, 153), 1);
        this.noFocusBorder = new EmptyBorder(1, 2, 1, 2);
        try {
            SMResourceAccess sMResourceAccess = new SMResourceAccess(SMConsoleContext.getInstance().getAPIHandle());
            this.ascendingIcon = new ImageIcon(sMResourceAccess.getImage("stdimages/sort-up.gif"));
            this.descendingIcon = new ImageIcon(sMResourceAccess.getImage("stdimages/sort-down.gif"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void addTableEventListener(CvTblTableEventListener cvTblTableEventListener) {
        this.tableEventListeners.addElement(cvTblTableEventListener);
    }

    public String getDataType() {
        return this.dataType;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JLabel jLabel;
        CvCommonTable cvCommonTable = (CvCommonTable)jTable;
        if (object instanceof CvTblCell) {
            boolean bl3 = true;
            CvTblCell cvTblCell = (CvTblCell)object;
            if (cvTblCell.getAlarmStatus() != null) {
                if (cvTblCell.getAlarmStatus().isAcknowledged()) {
                    cvTblCell.setIcon(cvCommonTable.getAcknowledgedIcon());
                    cvTblCell.setIconTextGap(5);
                    cvTblCell.setHorizontalAlignment(4);
                    cvTblCell.setHorizontalTextPosition(2);
                } else {
                    cvTblCell.setAlarmMode(cvTblCell.getAlarmMode());
                    if (cvTblCell.getAlarmStatus().getState().equals("DIS")) {
                        bl3 = true;
                    } else if (cvTblCell.getAlarmStatus().getStatusColor() != null && cvTblCell.getAlarmMode() == "background") {
                        bl3 = false;
                    }
                }
            }
            if (bl) {
                if (bl3) {
                    cvTblCell.setForeground(jTable.getSelectionForeground());
                    cvTblCell.setBackground(jTable.getSelectionBackground());
                }
            } else if (bl3) {
                int n3;
                CvTblTableModel cvTblTableModel = (CvTblTableModel)((CvCommonTable)jTable).getModel();
                cvTblCell.setBackground(cvTblTableModel.isCellEditable(n, n3 = cvCommonTable.convertColumnIndexToModel(n2)) ? cvCommonTable.getBackground() : cvCommonTable.getAlternateBackground());
            }
            if (bl2) {
                if (cvCommonTable.getContextSelection() != null && cvCommonTable.getContextSelection().getSelectionType() != 3) {
                    cvTblCell.setBorder(this.focusBorder);
                    if (jTable.isCellEditable(n, n2)) {
                        cvTblCell.setForeground(UIManager.getColor("Table.focusCellForeground"));
                        cvTblCell.setBackground(UIManager.getColor("Table.focusCellBackground"));
                    }
                } else {
                    cvTblCell.setBorder(this.noFocusBorder);
                }
            } else {
                cvTblCell.setBorder(this.noFocusBorder);
            }
            jLabel = cvTblCell;
        } else if (object instanceof JLabel) {
            jLabel = (JLabel)object;
            jLabel.setIcon(null);
            if (this.status != NORMAL) {
                if (this.status == ASCENDING) {
                    jLabel.setIcon(this.ascendingIcon);
                } else if (this.status == DESCENDING) {
                    jLabel.setIcon(this.descendingIcon);
                }
                jLabel.setHorizontalTextPosition(2);
                jLabel.setFont(CvTable.DEFAULT_SORT_HEADER_FONT);
            } else {
                jLabel.setFont(CvTable.DEFAULT_HEADER_FONT);
            }
            jLabel.setBackground(cvCommonTable.getBackground());
            jLabel.setForeground(cvCommonTable.getForeground());
            Dimension dimension = jLabel.getPreferredSize();
            dimension.height = jTable.getRowHeight();
            jLabel.setPreferredSize(dimension);
            if (jTable instanceof CvCommonTable) {
                if (((CvCommonTable)jTable).getHeaderSelected()) {
                    jLabel.setBorder(this.selBorder);
                } else {
                    jLabel.setBorder(this.nonSelHdrBorder);
                }
            }
        } else {
            jLabel = new JLabel(" ");
            jLabel.setBackground(cvCommonTable.getBackground());
            jLabel.setForeground(cvCommonTable.getForeground());
        }
        return jLabel;
    }

    public void removeTableEventListener(CvTblTableEventListener cvTblTableEventListener) {
        this.tableEventListeners.removeElement(cvTblTableEventListener);
    }

    public void setDataType(String string) {
        String string2 = this.dataType = string != null ? string : "";
        if (!(this.dataType.equals("int") || this.dataType.equals("float") || this.dataType.equals("date") || this.dataType.equals("boolean"))) {
            this.dataType = "string";
        }
    }

    public void setRowsDataType(Vector vector) {
        this.rowsDataType = vector;
    }

    public String getRowDataType(int n) {
        if (this.rowsDataType == null) {
            return "string";
        }
        try {
            String string = (String)this.rowsDataType.elementAt(n);
            return string;
        }
        catch (Exception exception) {
            return "string";
        }
    }

    public void setStatus(int n) {
        this.status = n;
    }

    public int getStatus() {
        return this.status;
    }
}

