/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.views.graph;

import com.sun.symon.base.console.views.graph.CvGraphFormat;
import com.sun.symon.base.console.views.graph.CvGraphInvalidInputException;
import com.sun.symon.base.utility.UcDDL;
import com.sun.symon.base.utility.UcInternationalizer;

public class CvGraphBorderFormat {
    private String outsideBorderType = "etchedout";
    private String insideBorderType = "none";
    private int outsideBorderWidth = 2;
    private int insideBorderWidth = 2;

    public CvGraphBorderFormat() {
        this.setupBorderFormat(this.outsideBorderType, this.outsideBorderWidth, this.insideBorderType, this.insideBorderWidth);
    }

    public CvGraphBorderFormat(String string, int n, String string2, int n2) {
        this.setupBorderFormat(string, n, string2, n2);
    }

    public String getConfiguration() {
        String string = new Integer(this.getOutsideBorderWidth()).toString();
        String string2 = new Integer(this.getInsideBorderWidth()).toString();
        return "Border^" + this.getOutsideBorderType() + "^" + string + "^" + this.getInsideBorderType() + "^" + string2;
    }

    public String getOutsideBorderType() {
        return this.outsideBorderType;
    }

    public int getOutsideBorderWidth() {
        return this.outsideBorderWidth;
    }

    public String getInsideBorderType() {
        return this.insideBorderType;
    }

    public int getInsideBorderWidth() {
        return this.insideBorderWidth;
    }

    public void setConfiguration(String string) throws CvGraphInvalidInputException {
        if (string == null) {
            return;
        }
        String[] stringArray = CvGraphFormat.splitString(string, "^");
        if (stringArray.length != 5) {
            UcDDL.logDebugMessage((String)("CvGraphBorderFormat::setConfiguration - invalid number of parameters '" + string + "'"));
            return;
        }
        if (!stringArray[0].equals("Border")) {
            UcDDL.logDebugMessage((String)("CvGraphBorderFormat::setConfiguration - invalid format keyword '" + stringArray[0] + "'"));
            return;
        }
        this.setOutsideBorderType(stringArray[1]);
        int n = 0;
        try {
            n = new Integer(stringArray[2]);
        }
        catch (NumberFormatException numberFormatException) {
            UcDDL.logDebugMessage((String)("CvGraphBorderFormat::setConfiguration - invalid border size keyword '" + stringArray[2] + "'"));
            String string2 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:invalidBorder");
            throw new CvGraphInvalidInputException(string2);
        }
        this.setOutsideBorderWidth(n);
        this.setInsideBorderType(stringArray[3]);
        try {
            n = new Integer(stringArray[4]);
        }
        catch (NumberFormatException numberFormatException) {
            UcDDL.logDebugMessage((String)("CvGraphBorderFormat::setConfiguration - invalid border size keyword '" + stringArray[4] + "'"));
            String string3 = UcInternationalizer.translateKey((String)"base.console.views.graph.Graph:invalidBorder");
            throw new CvGraphInvalidInputException(string3);
        }
        this.setInsideBorderWidth(n);
    }

    public void setOutsideBorderType(String string) {
        this.outsideBorderType = string != null ? string : this.outsideBorderType;
    }

    public void setOutsideBorderWidth(int n) {
        this.outsideBorderWidth = n;
    }

    public void setInsideBorderType(String string) {
        this.insideBorderType = string != null ? string : this.insideBorderType;
    }

    public void setInsideBorderWidth(int n) {
        this.insideBorderWidth = n;
    }

    private void setupBorderFormat(String string, int n, String string2, int n2) {
        this.outsideBorderType = string;
        this.outsideBorderWidth = n;
        this.insideBorderType = string2;
        this.insideBorderWidth = n2;
    }
}

