/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import com.sun.symon.base.client.attribute.SMAttributeEntryData;
import com.sun.symon.base.client.attribute.SMAttributeUpdateData;
import com.sun.symon.base.console.tools.editor.CtAttributeEditor;
import com.sun.symon.base.console.tools.editor.CtFocusChangeEvent;
import com.sun.symon.base.console.tools.editor.CtFocusChangeListener;
import com.sun.symon.base.console.tools.editor.CtFocusTraversable;
import com.sun.symon.base.console.tools.editor.CtResetEvent;
import com.sun.symon.base.console.tools.editor.CtResetListener;
import com.sun.symon.base.console.tools.editor.CtSaveEvent;
import com.sun.symon.base.console.tools.editor.CtSaveListener;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JPasswordField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;

public class CtPasswordField
extends JPasswordField
implements FocusListener,
CtFocusTraversable,
CtResetListener,
CtSaveListener,
DocumentListener {
    private CtAttributeEditor theEditor;
    private String key;
    private boolean access;
    private String originalValue = "";
    private String currentValue = "";
    private String currentGroupKey = "";
    private boolean lastEditable = false;
    private boolean changed = false;
    private boolean hasFocus = false;
    private Vector focusListener = new Vector();

    public CtPasswordField(SMAttributeEntryData sMAttributeEntryData, String string, CtAttributeEditor ctAttributeEditor) {
        this.theEditor = ctAttributeEditor;
        this.originalValue = sMAttributeEntryData.getValue();
        this.currentValue = this.originalValue = this.originalValue.replace('\t', ' ');
        this.currentGroupKey = string;
        this.key = sMAttributeEntryData.getKey();
        this.access = sMAttributeEntryData.getAccess();
        ((JTextComponent)this).setText(this.currentValue);
        this.setEditable(this.access);
        this.setEnabled(this.access);
        if (!this.access) {
            this.getCaret().setVisible(false);
        }
        if (this.access) {
            this.addFocusListener(this);
            this.getDocument().addDocumentListener(this);
            this.theEditor.addCtResetListener(this);
            this.theEditor.addCtSaveListener(this);
        }
        this.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CtPasswordField.this.transferFocus();
            }
        });
    }

    public synchronized void addCtFocusChangeListener(CtFocusChangeListener ctFocusChangeListener) {
        if (!this.focusListener.contains(ctFocusChangeListener)) {
            this.focusListener.addElement(ctFocusChangeListener);
        }
    }

    public void attributeReset(CtResetEvent ctResetEvent) {
        this.currentValue = this.originalValue;
        ((JTextComponent)this).setText(this.currentValue);
        this.setFont(this.theEditor.getAttValueFont());
        this.setForeground(this.theEditor.getAttValueForeground());
        this.setBackground(this.theEditor.getAttValueBackground());
        this.changed = false;
    }

    public void attributeSaved(CtSaveEvent ctSaveEvent) {
        this.currentValue = this.getText();
        this.originalValue = this.getText();
        this.setFont(this.theEditor.getAttValueFont());
        this.setForeground(this.theEditor.getAttValueForeground());
        this.setBackground(this.theEditor.getAttValueBackground());
        this.changed = false;
        this.validate();
        this.repaint();
        super.repaint();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.updateSaveData();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.updateSaveData();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.updateSaveData();
    }

    private void updateSaveData() {
        this.changed = true;
        this.setForeground(this.theEditor.getEditedForeground());
        this.theEditor.notifyEdited();
        this.setScrollOffset(0);
        this.invalidate();
        this.validate();
        this.repaint();
        this.currentValue = this.getText();
        SMAttributeUpdateData sMAttributeUpdateData = new SMAttributeUpdateData(this.currentGroupKey, this.key, this.currentValue);
        this.theEditor.updateSaveData(sMAttributeUpdateData);
        this.setBackground(this.theEditor.getAttValueBackground());
        this.setForeground(this.theEditor.getEditedForeground());
    }

    public void focusGained(FocusEvent focusEvent) {
        this.selectAll();
        this.requestFocus();
        this.getCaret().setVisible(true);
        this.notifyFocusChange();
        this.hasFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        if (this.changed) {
            this.currentValue = this.getText();
            SMAttributeUpdateData sMAttributeUpdateData = new SMAttributeUpdateData(this.currentGroupKey, this.key, this.currentValue);
            this.theEditor.updateSaveData(sMAttributeUpdateData);
            this.setBackground(this.theEditor.getAttValueBackground());
            this.setForeground(this.theEditor.getEditedForeground());
        } else {
            this.setBackground(this.theEditor.getAttValueBackground());
            this.setForeground(this.theEditor.getAttValueForeground());
        }
        this.getCaret().setVisible(false);
        this.hasFocus = false;
        this.repaint();
    }

    public Insets getInsets() {
        return new Insets(4, 4, 4, 4);
    }

    public boolean isFocusTraversable() {
        return this.access;
    }

    public boolean isRequestFocusEnabled() {
        return this.access;
    }

    public void notifyFocusChange() {
        Vector vector;
        CtFocusChangeEvent ctFocusChangeEvent = new CtFocusChangeEvent(this);
        CtPasswordField ctPasswordField = this;
        synchronized (ctPasswordField) {
            vector = (Vector)this.focusListener.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            CtFocusChangeListener ctFocusChangeListener = (CtFocusChangeListener)vector.elementAt(n);
            ctFocusChangeListener.attributeFocusChanged(ctFocusChangeEvent);
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        super.paint(graphics);
        if (this.hasFocus) {
            graphics.setColor(this.theEditor.getFocusedBorderColor());
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public String getSelectedText() {
        String string;
        String string2 = super.getSelectedText();
        if (string2 != null) {
            char c = this.getEchoChar();
            StringBuffer stringBuffer = new StringBuffer();
            int n = 0;
            while (n < string2.length()) {
                stringBuffer.append(c);
                ++n;
            }
            string = stringBuffer.toString();
        } else {
            string = null;
        }
        return string;
    }
}

