/*
 * Decompiled with CFR 0.152.
 */
package com.sun.symon.base.console.tools.editor;

import com.sun.symon.base.client.attribute.SMAttributeEntryData;
import com.sun.symon.base.console.tools.editor.CtAttributeEditor;
import com.sun.symon.base.console.tools.editor.CtFocusChangeEvent;
import com.sun.symon.base.console.tools.editor.CtFocusChangeListener;
import com.sun.symon.base.console.tools.editor.CtFocusTraversable;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Vector;
import javax.swing.JLabel;

public class CtLabel
extends JLabel
implements FocusListener,
CtFocusTraversable {
    private CtAttributeEditor theEditor;
    private String key;
    private boolean access;
    private String originalValue = "";
    private String currentValue = "";
    private String currentGroupKey = "";
    private boolean lastEditable = false;
    private boolean changed = false;
    private boolean hasFocus = false;
    private Vector focusListener = new Vector();
    private Vector textListener = new Vector();

    public CtLabel(SMAttributeEntryData sMAttributeEntryData, String string, CtAttributeEditor ctAttributeEditor) {
        this.theEditor = ctAttributeEditor;
        this.originalValue = sMAttributeEntryData.getValue();
        this.currentValue = this.originalValue = this.originalValue.replace('\t', ' ');
        this.currentGroupKey = string;
        this.key = sMAttributeEntryData.getKey();
        this.access = sMAttributeEntryData.getAccess();
        this.setText(this.currentValue);
        this.addFocusListener(this);
    }

    public synchronized void addCtFocusChangeListener(CtFocusChangeListener ctFocusChangeListener) {
        if (!this.focusListener.contains(ctFocusChangeListener)) {
            this.focusListener.addElement(ctFocusChangeListener);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.requestFocus();
        this.notifyFocusChange();
        this.hasFocus = true;
        this.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.hasFocus = false;
        this.repaint();
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public boolean isRequestFocusEnabled() {
        return true;
    }

    public void notifyFocusChange() {
        Vector vector;
        CtFocusChangeEvent ctFocusChangeEvent = new CtFocusChangeEvent(this);
        CtLabel ctLabel = this;
        synchronized (ctLabel) {
            vector = (Vector)this.focusListener.clone();
        }
        int n = 0;
        while (n < vector.size()) {
            CtFocusChangeListener ctFocusChangeListener = (CtFocusChangeListener)vector.elementAt(n);
            ctFocusChangeListener.attributeFocusChanged(ctFocusChangeEvent);
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        super.paint(graphics);
        if (this.hasFocus) {
            graphics.setColor(this.theEditor.getFocusedBorderColor());
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

